/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.consumer.Whitelist;
import kafka.log.LogConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicCommand$
implements ScalaObject {
    public static final TopicCommand$ MODULE$;

    static {
        new TopicCommand$();
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts$1 = new TopicCommand.TopicCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.createOpt(), opts$1.deleteOpt(), opts$1.listOpt(), opts$1.alterOpt(), opts$1.describeOpt()}))).count((Function1)new Serializable(opts$1){
            public static final long serialVersionUID;
            private final TopicCommand.TopicCommandOptions opts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.opts$1.options().has(optionSpec);
            }
            {
                this.opts$1 = topicCommandOptions;
            }
        });
        if (actions != 1) {
            System.err.println("Command must include exactly one action: --list, --describe, --create, --delete, or --alter");
            opts$1.parser().printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        opts$1.checkArgs();
        ZkClient zkClient = new ZkClient((String)opts$1.options().valueOf(opts$1.zkConnectOpt()), 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has((OptionSpec)opts$1.createOpt())) {
                this.createTopic(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.alterOpt())) {
                this.alterTopic(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.deleteOpt())) {
                this.deleteTopic(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.listOpt())) {
                this.listTopics(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.describeOpt())) {
                this.describeTopic(zkClient, opts$1);
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
        }
        zkClient.close();
        return;
        {
            finally {
                zkClient.close();
            }
        }
    }

    private Seq<String> getTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)ZkUtils$.MODULE$.getAllTopics(zkClient).sorted((Ordering)Ordering.String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter$1 = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter((Function1)new Serializable(topicsFilter$1){
                public static final long serialVersionUID;
                private final Whitelist topicsFilter$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String string) {
                    return this.topicsFilter$1.isTopicAllowed(string);
                }
                {
                    this.topicsFilter$1 = whitelist;
                }
            });
        } else {
            seq = allTopics;
        }
        return seq;
    }

    public void createTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        String topic = (String)opts.options().valueOf(opts.topicOpt());
        Properties configs = this.parseTopicConfigsToBeAdded(opts);
        if (opts.options().has(opts.replicaAssignmentOpt())) {
            Map<Object, List<Object>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, assignment, configs, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        } else {
            CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
            int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
            int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
            AdminUtils$.MODULE$.createTopic(zkClient, topic, partitions, replicas, configs);
        }
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Created topic \"%s\".").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    public void alterTopic(ZkClient zkClient$1, TopicCommand.TopicCommandOptions opts$2) {
        Seq<String> topics = this.getTopics(zkClient$1, opts$2);
        topics.foreach((Function1)new Serializable(zkClient$1, opts$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            private final TopicCommand.TopicCommandOptions opts$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                if (this.opts$2.options().has(this.opts$2.configOpt()) || this.opts$2.options().has(this.opts$2.deleteConfigOpt())) {
                    Properties configsToBeAdded = TopicCommand$.MODULE$.parseTopicConfigsToBeAdded(this.opts$2);
                    Seq<String> configsToBeDeleted = TopicCommand$.MODULE$.parseTopicConfigsToBeDeleted(this.opts$2);
                    Properties configs$1 = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$1, topic);
                    configs$1.putAll((java.util.Map<?, ?>)configsToBeAdded);
                    configsToBeDeleted.foreach((Function1)new Serializable(this, configs$1){
                        public static final long serialVersionUID;
                        private final Properties configs$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Object apply(String config) {
                            return this.configs$1.remove(config);
                        }
                        {
                            this.configs$1 = properties;
                        }
                    });
                    AdminUtils$.MODULE$.changeTopicConfig(this.zkClient$1, topic, configs$1);
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Updated config for topic \"%s\".").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                if (this.opts$2.options().has(this.opts$2.partitionsOpt())) {
                    Predef$.MODULE$.println((Object)"WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
                    int nPartitions = (Integer)this.opts$2.options().valueOf(this.opts$2.partitionsOpt());
                    String replicaAssignmentStr = (String)this.opts$2.options().valueOf(this.opts$2.replicaAssignmentOpt());
                    AdminUtils$.MODULE$.addPartitions(this.zkClient$1, topic, nPartitions, replicaAssignmentStr);
                    Predef$.MODULE$.println((Object)"Adding partitions succeeded!");
                }
            }
            {
                this.zkClient$1 = zkClient;
                this.opts$2 = topicCommandOptions;
            }
        });
    }

    public void deleteTopic(ZkClient zkClient$2, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient$2, opts);
        topics.foreach((Function1)new Serializable(zkClient$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                AdminUtils$.MODULE$.deleteTopic(this.zkClient$2, topic);
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Topic \"%s\" queued for deletion.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            {
                this.zkClient$2 = zkClient;
            }
        });
    }

    public void listTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                Predef$.MODULE$.println((Object)topic);
            }
        });
    }

    public void describeTopic(ZkClient zkClient$3, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient$3, opts);
        boolean reportUnderReplicatedPartitions$1 = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions$1 = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs$1 = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers$1 = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient$3).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Broker broker) {
                return broker.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1)new Serializable(zkClient$3, reportUnderReplicatedPartitions$1, reportUnavailablePartitions$1, reportOverriddenConfigs$1, liveBrokers$1){
            public static final long serialVersionUID;
            public final ZkClient zkClient$3;
            public final boolean reportUnderReplicatedPartitions$1;
            public final boolean reportUnavailablePartitions$1;
            private final boolean reportOverriddenConfigs$1;
            public final Set liveBrokers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic$1) {
                Option option;
                block9: {
                    block8: {
                        block7: {
                            Map map;
                            option = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(this.zkClient$3, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).get((Object)topic$1);
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            Map topicPartitionAssignment = map = (Map)some.x();
                            boolean describeConfigs = !this.reportUnavailablePartitions$1 && !this.reportUnderReplicatedPartitions$1;
                            boolean describePartitions = !this.reportOverriddenConfigs$1;
                            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                                }
                            });
                            if (describeConfigs) {
                                Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$3, topic$1);
                                if (!this.reportOverriddenConfigs$1 || configs.size() != 0) {
                                    int numPartitions = topicPartitionAssignment.size();
                                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor), ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply(Tuple2<String, String> kv) {
                                            return new StringBuilder().append((Object)((String)kv._1())).append((Object)"=").append(kv._2()).toString();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                                }
                            }
                            if (describePartitions) {
                                ((LinearSeqOptimized)sortedPartitions.filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final boolean apply(Tuple2<Object, Seq<Object>> tuple2) {
                                        Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                                        return tuple22 != null;
                                    }
                                })).foreach((Function1)new Serializable(this, topic$1){
                                    public static final long serialVersionUID;
                                    private final anonfun.describeTopic.1 $outer;
                                    private final String topic$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final void apply(Tuple2<Object, Seq<Object>> tuple2) {
                                        Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                                        if (tuple22 != null) {
                                            int n = BoxesRunTime.unboxToInt((Object)tuple22._1());
                                            Seq seq = (Seq)tuple22._2();
                                            int partitionId = n;
                                            Seq assignedReplicas = seq;
                                            Seq<Object> inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.$outer.zkClient$3, this.topic$1, partitionId);
                                            Option<Object> leader = ZkUtils$.MODULE$.getLeaderForPartition(this.$outer.zkClient$3, this.topic$1, partitionId);
                                            if (!this.$outer.reportUnderReplicatedPartitions$1 && !this.$outer.reportUnavailablePartitions$1 || this.$outer.reportUnderReplicatedPartitions$1 && inSyncReplicas.size() < assignedReplicas.size() || this.$outer.reportUnavailablePartitions$1 && (!leader.isDefined() || !this.$outer.liveBrokers$1.contains(leader.get()))) {
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tTopic: ").append((Object)this.topic$1).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tPartition: ").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tLeader: ").append(leader.isDefined() ? leader.get() : "none").toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tReplicas: ").append((Object)assignedReplicas.mkString(",")).toString());
                                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\tIsr: ").append((Object)inSyncReplicas.mkString(",")).toString());
                                            }
                                            return;
                                        }
                                        throw new MatchError(tuple22);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = string;
                                    }
                                });
                            }
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Topic ").append((Object)topic$1).append((Object)" doesn't exist!").toString());
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$3 = zkClient;
                this.reportUnderReplicatedPartitions$1 = bl;
                this.reportUnavailablePartitions$1 = bl2;
                this.reportOverriddenConfigs$1 = bl3;
                this.liveBrokers$1 = set;
            }
        });
    }

    public String formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)broker.host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)broker.port())).append((Object)")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.configOpt())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String string) {
                return string.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        });
        Properties props$1 = new Properties();
        configsToBeAdded.foreach((Function1)new Serializable(props$1){
            public static final long serialVersionUID;
            private final Properties props$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String[] pair) {
                return this.props$1.setProperty(pair[0].trim(), pair[1].trim());
            }
            {
                this.props$1 = properties;
            }
        });
        LogConfig$.MODULE$.validate(props$1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfigOpt())).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(String string) {
                    return string.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted$1 = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted$1){
                public static final long serialVersionUID;
                private final Properties propsToBeDeleted$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String string) {
                    return this.propsToBeDeleted$1.setProperty(string, "");
                }
                {
                    this.propsToBeDeleted$1 = properties;
                }
            });
            LogConfig$.MODULE$.validateNames(propsToBeDeleted$1);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList$1 = replicaAssignmentList.split(",");
        HashMap ret$1 = new HashMap();
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])partitionList$1).size()).foreach$mVc$sp((Function1)new Serializable(partitionList$1, ret$1){
            public static final long serialVersionUID;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[v1].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String s) {
                        return Predef$.MODULE$.augmentString(s.trim()).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()));
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)v1), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)v1))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
            }
            {
                this.partitionList$1 = stringArray;
                this.ret$1 = hashMap;
            }
        });
        return ret$1.toMap(Predef$.MODULE$.conforms());
    }

    private TopicCommand$() {
        MODULE$ = this;
    }
}

