/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.locks.Condition;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t!Y\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tQ!\u001e;jYNL!!\u0006\n\u0003\u000f1{wmZ5oOB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011!\u0019\u0001A!A!\u0002\u0013i\u0002C\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u00021%t\u0017\u000e^5bYR{\u0007/[2t)>\u0014U\rR3mKR,G\rE\u0002%O%j\u0011!\n\u0006\u0003Ma\t!bY8mY\u0016\u001cG/[8o\u0013\tASEA\u0002TKR\u0004\"AK\u0017\u000f\u0005]Y\u0013B\u0001\u0017\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051B\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002E%t\u0017\u000e^5bYR{\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q!QGN\u001c9!\tq\u0002\u0001C\u0003\u0004e\u0001\u0007Q\u0004C\u0004#eA\u0005\t\u0019A\u0012\t\u000fE\u0012\u0004\u0013!a\u0001G!9!\b\u0001b\u0001\n\u0003Y\u0014!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\tA\b\u0005\u0002\u001f{%\u0011aH\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bB\u0002!\u0001A\u0003%A(\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003b\u0002\"\u0001\u0005\u0004%\taQ\u0001\u0016a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\u0005!\u0005C\u0001\u0010F\u0013\t1%AA\u000bQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\t\r!\u0003\u0001\u0015!\u0003E\u0003Y\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\u0003b\u0002&\u0001\u0005\u0004%\taS\u0001\u0014e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.Z\u000b\u0002\u0019B\u0011a$T\u0005\u0003\u001d\n\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016Da\u0001\u0015\u0001!\u0002\u0013a\u0015\u0001\u0006:fa2L7-Y*uCR,W*Y2iS:,\u0007\u0005C\u0004S\u0001\u0001\u0007I\u0011A*\u0002#Q|\u0007/[2t)>\u0014U\rR3mKR,G-F\u0001U!\r)\u0006,K\u0007\u0002-*\u0011q+J\u0001\b[V$\u0018M\u00197f\u0013\tAc\u000bC\u0004[\u0001\u0001\u0007I\u0011A.\u0002+Q|\u0007/[2t)>\u0014U\rR3mKR,Gm\u0018\u0013fcR\u0011Al\u0018\t\u0003/uK!A\u0018\r\u0003\tUs\u0017\u000e\u001e\u0005\bAf\u000b\t\u00111\u0001U\u0003\rAH%\r\u0005\u0007E\u0002\u0001\u000b\u0015\u0002+\u0002%Q|\u0007/[2t)>\u0014U\rR3mKR,G\r\t\u0005\bI\u0002\u0001\r\u0011\"\u0001T\u0003m!x\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\"9a\r\u0001a\u0001\n\u00039\u0017a\b;pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|gn\u0018\u0013fcR\u0011A\f\u001b\u0005\bA\u0016\f\t\u00111\u0001U\u0011\u0019Q\u0007\u0001)Q\u0005)\u0006aBo\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:\u0004\u0003b\u00027\u0001\u0005\u0004%\t!\\\u0001\u0011I\u0016dW\r^3U_BL7m]\"p]\u0012,\u0012A\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\fQ\u0001\\8dWNT!a\u001d;\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002v\u0019\u0005!Q\u000f^5m\u0013\t9\bOA\u0005D_:$\u0017\u000e^5p]\"1\u0011\u0010\u0001Q\u0001\n9\f\u0011\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3!\u0011\u001dY\b\u00011A\u0005\u0002q\fq\u0003Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3\u0016\u0003u\u0004\"a\u0006@\n\u0005}D\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000b\t1\u0004Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3`I\u0015\fHc\u0001/\u0002\b!A\u0001-!\u0001\u0002\u0002\u0003\u0007Q\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015B?\u00021\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$\u0007\u0005C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012\u0005\u0011B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1e+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005]Q\"\u0001\u0001\u0007\r\u0005e\u0001\u0001AA\u000e\u0005I!U\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193\u0014\u000b\u0005]\u0011Q\u0004\f\u0011\u0007E\ty\"C\u0002\u0002\"I\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"91'a\u0006\u0005\u0002\u0005\u0015BCAA\n\u0011)\tI#a\u0006C\u0002\u0013\u0005\u00111F\u0001\tu.\u001cE.[3oiV\u0011\u0011Q\u0006\t\u0005\u0003_\ti$\u0004\u0002\u00022)!\u00111GA\u001b\u0003!Q8n\u00197jK:$(\u0002BA\u001c\u0003s\ta!\u0013\u0019Ji\u0016\u001c'BAA\u001e\u0003\ry'oZ\u0005\u0005\u0003\u007f\t\tD\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011%\t\u0019%a\u0006!\u0002\u0013\ti#A\u0005{W\u000ec\u0017.\u001a8uA!A\u0011qIA\f\t\u0003\nI%\u0001\u0004e_^{'o\u001b\u000b\u00029\"I\u0011Q\n\u0001A\u0002\u0013\u0005\u0011qJ\u0001\u0017I\u0016dW\r^3U_BL7m\u001d+ie\u0016\fGm\u0018\u0013fcR\u0019A,!\u0015\t\u0013\u0001\fY%!AA\u0002\u0005M\u0001\u0002CA+\u0001\u0001\u0006K!a\u0005\u0002'\u0011,G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\r\u001a\u0011\t\u000f\u0005e\u0003\u0001\"\u0001\u0002J\u0005)1\u000f^1si\"9\u0011Q\f\u0001\u0005\u0002\u0005%\u0013\u0001C:ikR$wn\u001e8\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007q\u000b)\u0007C\u0004\u0002h\u0005}\u0003\u0019A\u0012\u0002\rQ|\u0007/[2t\u0011\u001d\tY\u0007\u0001C\u0001\u0003[\nqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\u0007q\u000by\u0007C\u0005\u0002h\u0005%\u0004\u0013!a\u0001G!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014a\u00054bS2\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGc\u0001/\u0002x!A\u0011\u0011PA9\u0001\u0004\tY(\u0001\u0005sKBd\u0017nY1t!\u0011!s%! \u0011\u0007y\ty(C\u0002\u0002\u0002\n\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!!\"\u0001\t\u0003\t9)\u0001\u0010nCJ\\Gk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019A,!#\t\u000f\u0005\u001d\u00141\u0011a\u0001G!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015\u0001H5t)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004{\u0006E\u0005bBAJ\u0003\u0017\u0003\r!K\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003/\u0003A\u0011AAM\u0003eI7\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\u0007u\fY\nC\u0004\u0002\u0014\u0006U\u0005\u0019A\u0015\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006Q\u0012n\u001d+pa&\u001c\u0017+^3vK\u0012,\u0006OR8s\t\u0016dW\r^5p]R\u0019Q0a)\t\u000f\u0005M\u0015Q\u0014a\u0001S!9\u0011q\u0015\u0001\u0005\n\u0005%\u0013AH1xC&$Hk\u001c9jG\u0012+G.\u001a;j_:tu\u000e^5gS\u000e\fG/[8o\u0011\u001d\tY\u000b\u0001C\u0005\u0003\u0013\n\u0011D]3tk6,Gk\u001c9jG\u0012+G.\u001a;j_:$\u0006N]3bI\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0016aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\ra\u00161\u0017\u0005\t\u0003s\ni\u000b1\u0001\u0002|!9\u0011q\u0017\u0001\u0005\n\u0005e\u0016AG5t)>\u0004\u0018nY#mS\u001eL'\r\\3G_J$U\r\\3uS>tGcA?\u0002<\"9\u00111SA[\u0001\u0004I\u0003bBA`\u0001\u0011%\u0011\u0011Y\u0001\u001a[\u0006\u00148\u000eV8qS\u000e4uN\u001d#fY\u0016$\u0018n\u001c8SKR\u0014\u0018\u0010F\u0002]\u0003\u0007Dq!a%\u0002>\u0002\u0007\u0011\u0006C\u0004\u0002H\u0002!I!!3\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\u0007q\u000bY\rC\u0004\u0002\u0014\u0006\u0015\u0007\u0019A\u0015\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\u0006yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000eF\u0002]\u0003'Dq!a\u001a\u0002N\u0002\u00071\u0005C\u0004\u0002X\u0002!I!!7\u0002)M$\u0018M\u001d;SKBd\u0017nY1EK2,G/[8o)\ra\u00161\u001c\u0005\t\u0003;\f)\u000e1\u0001\u0002|\u0005a\"/\u001a9mS\u000e\f7OR8s)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007bBAq\u0001\u0011%\u00111]\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u00049\u0006\u0015\b\u0002CAt\u0003?\u0004\r!!;\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIB!AeJAv!\u0011\ti/a=\u000e\u0005\u0005=(bAAy\t\u000511m\\7n_:LA!!>\u0002p\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006qB-\u001a7fi\u0016$v\u000e]5d'R|\u0007OU3qY&\u001c\u0017mQ1mY\n\f7m\u001b\u000b\u00069\u0006u(Q\u0002\u0005\t\u0003\u007f\f9\u00101\u0001\u0003\u0002\u000512\u000f^8q%\u0016\u0004H.[2b%\u0016\u001c\bo\u001c8tK>\u0013'\u000e\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119\u0001B\u0001\u0004CBL\u0017\u0002\u0002B\u0006\u0005\u000b\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011!\u0011y!a>A\u0002\tE\u0011!\u0003:fa2L7-Y%e!\r9\"1C\u0005\u0004\u0005+A\"aA%oi\"I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005!1D\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u0005;Q3a\tB\u0010W\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u00161\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=\"Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!\u0003B\u001a\u0005\u0005\u0005\tR\u0001B\u001b\u0003Q!v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4feB\u0019aDa\u000e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0005s\u0019BAa\u000e\t-!91Ga\u000e\u0005\u0002\tuBC\u0001B\u001b\u0011)\u0011\tEa\u000e\u0012\u0002\u0013\u0005!1D\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011)Ea\u000e\u0012\u0002\u0013\u0005!1D\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private scala.collection.mutable.Set<String> topicsToBeDeleted;
    private scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private boolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Set init$default$3() {
        return TopicDeletionManager$.MODULE$.init$default$3();
    }

    public static final Set init$default$2() {
        return TopicDeletionManager$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public void topicsToBeDeleted_$eq(scala.collection.mutable.Set<String> set) {
        this.topicsToBeDeleted = set;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void topicsIneligibleForDeletion_$eq(scala.collection.mutable.Set<String> set) {
        this.topicsIneligibleForDeletion = set;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public boolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public void deleteTopicStateChanged_$eq(boolean bl) {
        this.deleteTopicStateChanged = bl;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread deleteTopicsThread) {
        this.deleteTopicsThread = deleteTopicsThread;
    }

    public void start() {
        this.deleteTopicsThread_$eq(new DeleteTopicsThread(this));
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsThread().start();
    }

    public void shutdown() {
        this.deleteTopicsThread().shutdown();
        this.topicsToBeDeleted().clear();
        this.topicsIneligibleForDeletion().clear();
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        this.topicsToBeDeleted().$plus$plus$eq(topics);
        this.resumeTopicDeletionThread();
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted());
        if (topicsToResumeDeletion.size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete$1 = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (replicasThatFailedToDelete$1.size() > 0) {
            Set topics$1 = (Set)replicasThatFailedToDelete$1.map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(PartitionAndReplica partitionAndReplica) {
                    return partitionAndReplica.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete$1, topics$1){
                public static final long serialVersionUID;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = set;
                    this.topics$1 = set2;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete$1, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics$1);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        scala.collection.mutable.Set newTopicsToHaltDeletion$1 = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
        this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion$1);
        if (newTopicsToHaltDeletion$1.size() > 0) {
            this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion$1){
                public static final long serialVersionUID;
                private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Halted deletion of topics %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                }
                {
                    this.newTopicsToHaltDeletion$1 = set;
                }
            });
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return this.topicsIneligibleForDeletion().contains((Object)topic);
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic);
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic);
    }

    public final void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        while (true) {
            if (this.deleteTopicStateChanged()) {
                this.deleteTopicStateChanged_$eq(false);
                return;
            }
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Waiting for signal to start or continue topic deletion";
                }
            });
            this.deleteTopicsCond().await();
        }
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsCond().signal();
    }

    public final void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas$1 = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas$1){
            public static final long serialVersionUID;
            private final Set successfullyDeletedReplicas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = set;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas$1, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public final boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public final void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public final void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicConfigPath(topic));
        this.controllerContext().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public final void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics$2) {
        this.info((Function0<String>)new Serializable(this, topics$2){
            public static final long serialVersionUID;
            private final Set topics$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Topic deletion callback for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = set;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq());
        Map partitionReplicaAssignmentByTopic$1 = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return ((TopicAndPartition)p._1()).topic();
            }
        });
        topics$2.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicAndPartition>)((TraversableOnce)((TraversableLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return (TopicAndPartition)tuple2._1();
                    }
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = map;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted$1) {
        replicasForTopicsToBeDeleted$1.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(PartitionAndReplica partitionAndReplica) {
                return partitionAndReplica.topic();
            }
        }).foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Set<PartitionAndReplica>> tuple2) {
                Tuple2<String, Set<PartitionAndReplica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string;
                    String topic$1 = string = (String)tuple22._1();
                    Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic$1){
                        public static final long serialVersionUID;
                        private final String topic$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(PartitionAndReplica p) {
                            return p.topic().equals(this.topic$1);
                        }
                        {
                            this.topic$1 = string;
                        }
                    });
                    Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$1, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry$1 = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry$1, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry$1){
                        public static final long serialVersionUID;
                        private final Set replicasForDeletionRetry$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Deletion started for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                        }
                        {
                            this.replicasForDeletionRetry$1 = set;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry$1, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<RequestOrResponse, Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$startReplicaDeletion$2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(RequestOrResponse requestOrResponse, int n) {
                            this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(requestOrResponse, n);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).build());
                    if (deadReplicasForTopic.size() > 0) {
                        this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))));
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }

            public TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = set;
            }
        });
    }

    public final void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted$1) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted$1){
            public static final long serialVersionUID;
            private final Set partitionsToBeDeleted$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Partition deletion callback for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = set;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted$1);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public final void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(RequestOrResponse stopReplicaResponseObj, int replicaId$1) {
        StopReplicaResponse stopReplicaResponse$1 = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)new Serializable(this, stopReplicaResponse$1){
            public static final long serialVersionUID;
            private final StopReplicaResponse stopReplicaResponse$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Delete topic callback invoked for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse;
            }
        });
        scala.collection.immutable.Set partitionsInError$1 = stopReplicaResponse$1.errorCode() != ErrorMapping$.MODULE$.NoError() ? stopReplicaResponse$1.responseMap().keySet() : ((TraversableOnce)((TraversableLike)stopReplicaResponse$1.responseMap().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Object> p) {
                return BoxesRunTime.unboxToShort((Object)p._2()) != ErrorMapping$.MODULE$.NoError();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> tuple2) {
                return (TopicAndPartition)tuple2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set replicasInError$1 = (scala.collection.immutable.Set)partitionsInError$1.map((Function1)new Serializable(this, replicaId$1){
            public static final long serialVersionUID;
            private final int replicaId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final PartitionAndReplica apply(TopicAndPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = n;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId$1, stopReplicaResponse$1, partitionsInError$1, replicasInError$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            public final int replicaId$1;
            private final StopReplicaResponse stopReplicaResponse$1;
            private final scala.collection.immutable.Set partitionsInError$1;
            private final scala.collection.immutable.Set replicasInError$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion((Set<PartitionAndReplica>)this.replicasInError$1);
                if (this.replicasInError$1.size() != this.stopReplicaResponse$1.responseMap().size()) {
                    scala.collection.immutable.Set deletedReplicas = (scala.collection.immutable.Set)this.stopReplicaResponse$1.responseMap().keySet().$minus$minus((GenTraversableOnce)this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final PartitionAndReplica apply(TopicAndPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = n;
                this.stopReplicaResponse$1 = stopReplicaResponse;
                this.partitionsInError$1 = set;
                this.replicasInError$1 = set2;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.controllerContext().controllerLock().newCondition();
        this.deleteTopicStateChanged = false;
        this.deleteTopicsThread = null;
    }

    public class DeleteTopicsThread
    extends ShutdownableThread
    implements ScalaObject {
        private final ZkClient zkClient;
        public final TopicDeletionManager $outer;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void doWork() {
            Utils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                public static final long serialVersionUID;
                private final DeleteTopicsThread $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
                    Set topicsQueuedForDeletion$1 = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                    if (topicsQueuedForDeletion$1.size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion$1){
                            public static final long serialVersionUID;
                            private final Set topicsQueuedForDeletion$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                            }
                            {
                                this.topicsQueuedForDeletion$1 = set;
                            }
                        });
                    }
                    topicsQueuedForDeletion$1.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final DeleteTopicsThread$$anonfun$doWork$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(String topic$2) {
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic$2)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic$2);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$2){
                                    public static final long serialVersionUID;
                                    private final String topic$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = string;
                                    }
                                });
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic$2)) {
                                Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$2, ReplicaDeletionStarted$.MODULE$);
                                Set replicaIds$1 = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final int apply(PartitionAndReplica partitionAndReplica) {
                                        return partitionAndReplica.replica();
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                Set partitions$1 = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final TopicAndPartition apply(PartitionAndReplica r) {
                                        return new TopicAndPartition(r.topic(), r.partition());
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$2, replicaIds$1, partitions$1){
                                    public static final long serialVersionUID;
                                    private final String topic$2;
                                    private final Set replicaIds$1;
                                    private final Set partitions$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = string;
                                        this.replicaIds$1 = set;
                                        this.partitions$1 = set2;
                                    }
                                });
                            } else {
                                Set<PartitionAndReplica> replicasInTopicDeletionFailedState$1 = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$2, ReplicaDeletionIneligible$.MODULE$);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic$2);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$2, replicasInTopicDeletionFailedState$1){
                                    public static final long serialVersionUID;
                                    private final String topic$2;
                                    private final Set replicasInTopicDeletionFailedState$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.replicasInTopicDeletionFailedState$1.mkString(",")}));
                                    }
                                    {
                                        this.topic$2 = string;
                                        this.replicasInTopicDeletionFailedState$1 = set;
                                    }
                                });
                            }
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic$2)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$2){
                                    public static final long serialVersionUID;
                                    private final String topic$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Deletion of topic %s (re)started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = string;
                                    }
                                });
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$2}))));
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic$2)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$2){
                                    public static final long serialVersionUID;
                                    private final String topic$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = string;
                                    }
                                });
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return this.$outer;
        }

        public DeleteTopicsThread(TopicDeletionManager $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("delete-topics-thread", ShutdownableThread$.MODULE$.init$default$2());
            this.zkClient = $outer.controllerContext().zkClient();
        }
    }
}

