/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\u0019\u0019wN\u001c4jOV\tq\u0004\u0005\u0002!C5\t!!\u0003\u0002#\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\bG>tg-[4!\u0011!1\u0003A!b\u0001\n\u00039\u0013a\u00027pO\u0012K'o]\u000b\u0002QA\u0019q#K\u0016\n\u0005)B\"!B!se\u0006L\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\r\u0003\tIw.\u0003\u00021[\t!a)\u001b7f\u0011!\u0011\u0004A!A!\u0002\u0013A\u0013\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\nA\u0001\\8hgV\ta\u0007\u0005\u0003\u0012oez\u0014B\u0001\u001d\u0013\u0005\u0011\u0001vn\u001c7\u0011\u0005ijT\"A\u001e\u000b\u0005q\"\u0011AB2p[6|g.\u0003\u0002?w\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005\u0001\u0002\u0015BA!\u0003\u0005\raun\u001a\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005m\u0005)An\\4tA!AQ\t\u0001B\u0001B\u0003%a)\u0001\u0003uS6,\u0007CA\tH\u0013\tA%C\u0001\u0003US6,\u0007\"\u0002&\u0001\t\u0003Y\u0015A\u0002\u001fj]&$h\bF\u0003M\u001b:{\u0005\u000b\u0005\u0002!\u0001!)Q$\u0013a\u0001?!)a%\u0013a\u0001Q!)A'\u0013a\u0001m!9Q)\u0013I\u0001\u0002\u00041\u0005b\u0002*\u0001\u0005\u0004%IaU\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\u0005!\u0006C\u0001\u0011V\u0013\t1&AA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJDa\u0001\u0017\u0001!\u0002\u0013!\u0016aD2mK\u0006tWM]'b]\u0006<WM\u001d\u0011\t\u000fi\u0003!\u0019!C\u00057\u0006IA\u000f\u001b:piRdWM]\u000b\u00029B\u0011\u0011#X\u0005\u0003=J\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\r\u0001\u0004\u0001\u0015!\u0003]\u0003)!\bN]8ui2,'\u000f\t\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003!\u0019G.Z1oKJ\u001cX#\u00013\u0011\u0007\u0015TG.D\u0001g\u0015\t9\u0007.A\u0005j[6,H/\u00192mK*\u0011\u0011\u000eG\u0001\u000bG>dG.Z2uS>t\u0017BA6g\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003[:l\u0011\u0001\u0001\u0004\u0005_\u0002!\u0001OA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0004]F4\u0002CA\ts\u0013\t\u0019(C\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007\u0002C;o\u0005\u0003\u0005\u000b\u0011\u0002<\u0002\u0011QD'/Z1e\u0013\u0012\u0004\"aF<\n\u0005aD\"aA%oi\")!J\u001cC\u0001uR\u0011An\u001f\u0005\u0006kf\u0004\rA\u001e\u0005\b{:\u0014\r\u0011\"\u0011\u007f\u0003)awnZ4fe:\u000bW.Z\u000b\u0002\u007fB\u0019\u0011\"!\u0001\n\u0007\u0005\r!B\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u000fq\u0007\u0015!\u0003\u0000\u0003-awnZ4fe:\u000bW.\u001a\u0011\t\u0013\u0005-aN1A\u0005\u0002\u00055\u0011aB2mK\u0006tWM]\u000b\u0003\u0003\u001f\u00012\u0001IA\t\u0013\r\t\u0019B\u0001\u0002\b\u00072,\u0017M\\3s\u0011!\t9B\u001cQ\u0001\n\u0005=\u0011\u0001C2mK\u0006tWM\u001d\u0011\t\u000f\u0005ma\u000e\"\u0003\u0002\u001e\u0005I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003?\t)\u0003E\u0002\u0018\u0003CI1!a\t\u0019\u0005\u0011)f.\u001b;\t\u000f\u0005\u001d\u0012\u0011\u0004a\u0001s\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000f\u0005-b\u000e\"\u0011\u0002.\u00051Am\\,pe.$\"!a\b\t\u000f\u0005Eb\u000e\"\u0003\u0002.\u0005a1\r\\3b]>\u00138\u000b\\3fa\"9\u0011Q\u00078\u0005\u0002\u0005]\u0012\u0001\u00037pON#\u0018\r^:\u0015\u0019\u0005}\u0011\u0011HA\u001f\u0003\u001b\n9&a\u0017\t\u000f\u0005m\u00121\u0007a\u0001m\u0006\u0011\u0011\u000e\u001a\u0005\t\u0003\u007f\t\u0019\u00041\u0001\u0002B\u0005!a.Y7f!\u0011\t\u0019%!\u0013\u000f\u0007]\t)%C\u0002\u0002Ha\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u0017R1!a\u0012\u0019\u0011!\ty%a\rA\u0002\u0005E\u0013\u0001\u00024s_6\u00042aFA*\u0013\r\t)\u0006\u0007\u0002\u0005\u0019>tw\r\u0003\u0005\u0002Z\u0005M\u0002\u0019AA)\u0003\t!x\u000e\u0003\u0005\u0002^\u0005M\u0002\u0019AA0\u0003\u0015\u0019H/\u0019;t!\r\u0001\u0013\u0011M\u0005\u0004\u0003G\u0012!\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA4\u0001\u0001\u0006I\u0001Z\u0001\nG2,\u0017M\\3sg\u0002Bq!a\u001b\u0001\t\u0003\ti#A\u0004ti\u0006\u0014H/\u001e9\t\u000f\u0005=\u0004\u0001\"\u0001\u0002.\u0005A1\u000f[;uI><h\u000eC\u0004\u0002t\u0001!\t!!\u001e\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\ty\"a\u001e\t\u000f\u0005\u001d\u0012\u0011\u000fa\u0001s!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003?\ty\bC\u0004\u0002(\u0005e\u0004\u0019A\u001d\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA\u0010\u0003\u000fCq!a\n\u0002\u0002\u0002\u0007\u0011\bC\u0004\u0002\f\u0002!\t!!$\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0015\u0005}\u0011qRAJ\u0003/\u000bY\n\u0003\u0005\u0002\u0012\u0006%\u0005\u0019AA!\u0003\u0015!x\u000e]5d\u0011\u001d\t)*!#A\u0002Y\fA\u0001]1si\"A\u0011\u0011TAE\u0001\u0004\t\t&\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u000b\u0003;\u000bI\t%AA\u0002\u0005E\u0013a\u0002;j[\u0016|W\u000f\u001e\u0005\n\u0003C\u0003\u0011\u0013!C\u0001\u0003G\u000ba#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003KSC!!\u0015\u0002(.\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003%)hn\u00195fG.,GMC\u0002\u00024b\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9,!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u0002<\n\t\t\u0011#\u0002\u0002>\u0006QAj\\4DY\u0016\fg.\u001a:\u0011\u0007\u0001\nyL\u0002\u0005\u0002\u0005\u0005\u0005\tRAAa'\u0011\ty\f\u0003\f\t\u000f)\u000by\f\"\u0001\u0002FR\u0011\u0011Q\u0018\u0005\u000b\u0003\u0013\fy,%A\u0005\u0002\u0005-\u0017AD5oSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bT3ARAT\u0001")
public class LogCleaner
implements Logging {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return LogCleaner$.MODULE$.init$default$4();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public final LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public final Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    private IndexedSeq<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains((Object)new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, time);
        this.cleaners = (IndexedSeq)Predef$.MODULE$.intWrapper(0).until(config.numThreads()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public class CleanerThread
    extends ShutdownableThread
    implements ScalaObject {
        private final String loggerName;
        private final Cleaner cleaner;
        public final LogCleaner $outer;

        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public final void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        public void doWork() {
            this.cleanOrSleep();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            LogToClean logToClean;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time.sleep(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs());
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = logToClean = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.logStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                return;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            return;
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void logStats(int id, String name, long from, long to, CleanerStats stats) {
            String message$1 = new StringBuilder().append((Object)Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message$1){
                public static final long serialVersionUID;
                private final String message$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = string;
                }
            });
        }

        public LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return this.$outer;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(LogCleaner $outer, int threadId) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if ($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads(), Integer.MAX_VALUE), $outer.config().hashAlgorithm()), $outer.config().ioBufferSize() / $outer.config().numThreads() / 2, $outer.config().maxMessageSize(), $outer.config().dedupeBufferLoadFactor(), $outer.kafka$log$LogCleaner$$throttler(), $outer.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)new CleanerThread$$anonfun$3(this));
        }
    }
}

