/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.consumer.ConsumerConfig$;
import kafka.message.Message$;
import kafka.message.MessageSet$;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import kafka.utils.ZKConfig;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0001\u0003\u0001\u001d\u00111bS1gW\u0006\u001cuN\u001c4jO*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!\u0001\u0003.L\u0007>tg-[4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005)\u0001O]8qgV\tq\u0003\u0005\u0002\n1%\u0011\u0011D\u0003\u0002\u0015-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\t\u0011m\u0001!\u0011!Q\u0001\n]\ta\u0001\u001d:paN\u0004\u0003\"B\u000f\u0001\t\u0013q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u0005!)Q\u0003\ba\u0001/!)Q\u0004\u0001C\u0001GQ\u0011q\u0004\n\u0005\u0006K\t\u0002\rAJ\u0001\u000e_JLw-\u001b8bYB\u0013x\u000e]:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001B;uS2T\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\tQ\u0001K]8qKJ$\u0018.Z:\t\u000b=\u0002A\u0011\u0002\u0019\u00023\u001d,G\u000fT8h%\u0016$XM\u001c;j_:$\u0016.\\3NS2d\u0017n\u001d\u000b\u0002cA\u0011qBM\u0005\u0003gA\u0011A\u0001T8oO\"9Q\u0007\u0001b\u0001\n\u00031\u0014\u0001\u00032s_.,'/\u00133\u0016\u0003]\u0002\"a\u0004\u001d\n\u0005e\u0002\"aA%oi\"11\b\u0001Q\u0001\n]\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fu\u0002!\u0019!C\u0001m\u0005yQ.Z:tC\u001e,W*\u0019=CsR,7\u000f\u0003\u0004@\u0001\u0001\u0006IaN\u0001\u0011[\u0016\u001c8/Y4f\u001b\u0006D()\u001f;fg\u0002Bq!\u0011\u0001C\u0002\u0013\u0005a'A\tok6tU\r^<pe.$\u0006N]3bINDaa\u0011\u0001!\u0002\u00139\u0014A\u00058v[:+Go^8sWRC'/Z1eg\u0002Bq!\u0012\u0001C\u0002\u0013\u0005a'\u0001\u0007ok6Lu\u000e\u00165sK\u0006$7\u000f\u0003\u0004H\u0001\u0001\u0006IaN\u0001\u000e]Vl\u0017j\u001c+ie\u0016\fGm\u001d\u0011\t\u000f%\u0003!\u0019!C\u0001m\u0005\t\"-Y2lOJ|WO\u001c3UQJ,\u0017\rZ:\t\r-\u0003\u0001\u0015!\u00038\u0003I\u0011\u0017mY6he>,h\u000e\u001a+ie\u0016\fGm\u001d\u0011\t\u000f5\u0003!\u0019!C\u0001m\u0005\t\u0012/^3vK\u0012l\u0015\r\u001f*fcV,7\u000f^:\t\r=\u0003\u0001\u0015!\u00038\u0003I\tX/Z;fI6\u000b\u0007PU3rk\u0016\u001cHo\u001d\u0011\t\u000fE\u0003!\u0019!C\u0001m\u0005!\u0001o\u001c:u\u0011\u0019\u0019\u0006\u0001)A\u0005o\u0005)\u0001o\u001c:uA!9Q\u000b\u0001b\u0001\n\u00031\u0016\u0001\u00035pgRt\u0015-\\3\u0016\u0003]\u0003\"\u0001W.\u000f\u0005=I\u0016B\u0001.\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0003\u0002BB0\u0001A\u0003%q+A\u0005i_N$h*Y7fA!9\u0011\r\u0001b\u0001\n\u00031\u0016AE1em\u0016\u0014H/[:fI\"{7\u000f\u001e(b[\u0016Daa\u0019\u0001!\u0002\u00139\u0016aE1em\u0016\u0014H/[:fI\"{7\u000f\u001e(b[\u0016\u0004\u0003bB3\u0001\u0005\u0004%\tAN\u0001\u000fC\u00124XM\u001d;jg\u0016$\u0007k\u001c:u\u0011\u00199\u0007\u0001)A\u0005o\u0005y\u0011\r\u001a<feRL7/\u001a3Q_J$\b\u0005C\u0004j\u0001\t\u0007I\u0011\u0001\u001c\u0002+M|7m[3u'\u0016tGMQ;gM\u0016\u0014()\u001f;fg\"11\u000e\u0001Q\u0001\n]\nac]8dW\u0016$8+\u001a8e\u0005V4g-\u001a:CsR,7\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u00017\u0003a\u0019xnY6fiJ+7-Z5wK\n+hMZ3s\u0005f$Xm\u001d\u0005\u0007_\u0002\u0001\u000b\u0011B\u001c\u00023M|7m[3u%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:CsR,7\u000f\t\u0005\bc\u0002\u0011\r\u0011\"\u00017\u0003U\u0019xnY6fiJ+\u0017/^3ti6\u000b\u0007PQ=uKNDaa\u001d\u0001!\u0002\u00139\u0014AF:pG.,GOU3rk\u0016\u001cH/T1y\u0005f$Xm\u001d\u0011\t\u000fU\u0004!\u0019!C\u0001m\u0005ia.^7QCJ$\u0018\u000e^5p]NDaa\u001e\u0001!\u0002\u00139\u0014A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0003\u001dawn\u001a#jeN,\u0012a\u001f\t\u0004y~<V\"A?\u000b\u0005y\u0004\u0012AC2pY2,7\r^5p]&\u0019\u0011\u0011A?\u0003\u0007M+\u0017\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B>\u0002\u00111|w\rR5sg\u0002B\u0001\"!\u0003\u0001\u0005\u0004%\tAN\u0001\u0010Y><7+Z4nK:$()\u001f;fg\"9\u0011Q\u0002\u0001!\u0002\u00139\u0014\u0001\u00057pON+w-\\3oi\nKH/Z:!\u0011!\t\t\u0002\u0001b\u0001\n\u00031\u0014\u0001\u00047pOJ{G\u000e\u001c%pkJ\u001c\bbBA\u000b\u0001\u0001\u0006IaN\u0001\u000eY><'k\u001c7m\u0011>,(o\u001d\u0011\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0011A\u00067pOJ+G/\u001a8uS>tG+[7f\u001b&dG.[:\u0016\u0003EBq!a\b\u0001A\u0003%\u0011'A\fm_\u001e\u0014V\r^3oi&|g\u000eV5nK6KG\u000e\\5tA!I\u00111\u0005\u0001C\u0002\u0013\u0005\u00111D\u0001\u0012Y><'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\bbBA\u0014\u0001\u0001\u0006I!M\u0001\u0013Y><'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\b\u0005C\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002\u001c\u0005!Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bNDq!a\f\u0001A\u0003%\u0011'A\u000bm_\u001e\u001cE.Z1okBLe\u000e^3sm\u0006dWj\u001d\u0011\t\u0011\u0005M\u0002A1A\u0005\u0002Y\u000b\u0001\u0003\\8h\u00072,\u0017M\\;q!>d\u0017nY=\t\u000f\u0005]\u0002\u0001)A\u0005/\u0006\tBn\\4DY\u0016\fg.\u001e9Q_2L7-\u001f\u0011\t\u0011\u0005m\u0002A1A\u0005\u0002Y\n\u0011\u0003\\8h\u00072,\u0017M\\3s)\"\u0014X-\u00193t\u0011\u001d\ty\u0004\u0001Q\u0001\n]\n!\u0003\\8h\u00072,\u0017M\\3s)\"\u0014X-\u00193tA!I\u00111\t\u0001C\u0002\u0013\u0005\u0011QI\u0001\u001eY><7\t\\3b]\u0016\u0014\u0018j\\'bq\nKH/Z:QKJ\u001cVmY8oIV\u0011\u0011q\t\t\u0004\u001f\u0005%\u0013bAA&!\t1Ai\\;cY\u0016D\u0001\"a\u0014\u0001A\u0003%\u0011qI\u0001\u001fY><7\t\\3b]\u0016\u0014\u0018j\\'bq\nKH/Z:QKJ\u001cVmY8oI\u0002B\u0011\"a\u0015\u0001\u0005\u0004%\t!a\u0007\u000251|wm\u00117fC:,'\u000fR3ekB,')\u001e4gKJ\u001c\u0016N_3\t\u000f\u0005]\u0003\u0001)A\u0005c\u0005YBn\\4DY\u0016\fg.\u001a:EK\u0012,\b/\u001a\"vM\u001a,'oU5{K\u0002B\u0001\"a\u0017\u0001\u0005\u0004%\tAN\u0001\u0017Y><7\t\\3b]\u0016\u0014\u0018j\u001c\"vM\u001a,'oU5{K\"9\u0011q\f\u0001!\u0002\u00139\u0014a\u00067pO\u000ecW-\u00198fe&{')\u001e4gKJ\u001c\u0016N_3!\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003\t)%\u0001\u0011m_\u001e\u001cE.Z1oKJ$U\rZ;qK\n+hMZ3s\u0019>\fGMR1di>\u0014\b\u0002CA4\u0001\u0001\u0006I!a\u0012\u0002C1|wm\u00117fC:,'\u000fR3ekB,')\u001e4gKJdu.\u00193GC\u000e$xN\u001d\u0011\t\u0013\u0005-\u0004A1A\u0005\u0002\u0005m\u0011a\u00057pO\u000ecW-\u00198fe\n\u000b7m[8gM6\u001b\bbBA8\u0001\u0001\u0006I!M\u0001\u0015Y><7\t\\3b]\u0016\u0014()Y2l_\u001a4Wj\u001d\u0011\t\u0013\u0005M\u0004A1A\u0005\u0002\u0005\u0015\u0013a\u00067pO\u000ecW-\u00198fe6Kgn\u00117fC:\u0014\u0016\r^5p\u0011!\t9\b\u0001Q\u0001\n\u0005\u001d\u0013\u0001\u00077pO\u000ecW-\u00198fe6Kgn\u00117fC:\u0014\u0016\r^5pA!I\u00111\u0010\u0001C\u0002\u0013\u0005\u0011QP\u0001\u0011Y><7\t\\3b]\u0016\u0014XI\\1cY\u0016,\"!a \u0011\u0007=\t\t)C\u0002\u0002\u0004B\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA@\u0003EawnZ\"mK\u0006tWM]#oC\ndW\r\t\u0005\n\u0003\u0017\u0003!\u0019!C\u0001\u00037\t1\u0004\\8h\u00072,\u0017M\\3s\t\u0016dW\r^3SKR,g\u000e^5p]6\u001b\bbBAH\u0001\u0001\u0006I!M\u0001\u001dY><7\t\\3b]\u0016\u0014H)\u001a7fi\u0016\u0014V\r^3oi&|g.T:!\u0011!\t\u0019\n\u0001b\u0001\n\u00031\u0014\u0001\u00067pO&sG-\u001a=TSj,W*\u0019=CsR,7\u000fC\u0004\u0002\u0018\u0002\u0001\u000b\u0011B\u001c\u0002+1|w-\u00138eKb\u001c\u0016N_3NCb\u0014\u0015\u0010^3tA!A\u00111\u0014\u0001C\u0002\u0013\u0005a'A\u000bm_\u001eLe\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\t\u000f\u0005}\u0005\u0001)A\u0005o\u00051Bn\\4J]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\b\u0005C\u0005\u0002$\u0002\u0011\r\u0011\"\u0001\u0002\u001c\u0005ABn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\'fgN\fw-Z:\t\u000f\u0005\u001d\u0006\u0001)A\u0005c\u0005IBn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\'fgN\fw-Z:!\u0011%\tY\u000b\u0001b\u0001\n\u0003\tY\"\u0001\tm_\u001e$U\r\\3uK\u0012+G.Y=Ng\"9\u0011q\u0016\u0001!\u0002\u0013\t\u0014!\u00057pO\u0012+G.\u001a;f\t\u0016d\u0017-_'tA!I\u00111\u0017\u0001C\u0002\u0013\u0005\u00111D\u0001\u001cY><g\t\\;tQN\u001b\u0007.\u001a3vY\u0016\u0014\u0018J\u001c;feZ\fG.T:\t\u000f\u0005]\u0006\u0001)A\u0005c\u0005aBn\\4GYV\u001c\bnU2iK\u0012,H.\u001a:J]R,'O^1m\u001bN\u0004\u0003\"CA^\u0001\t\u0007I\u0011AA\u000e\u0003Iawn\u001a$mkND\u0017J\u001c;feZ\fG.T:\t\u000f\u0005}\u0006\u0001)A\u0005c\u0005\u0019Bn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\'tA!A\u00111\u0019\u0001C\u0002\u0013\u0005a'\u0001\u0012m_\u001e4E.^:i\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dWj\u001d\u0005\b\u0003\u000f\u0004\u0001\u0015!\u00038\u0003\rbwn\u001a$mkNDwJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197Ng\u0002B\u0011\"a3\u0001\u0005\u0004%\t!! \u0002-\u0005,Ho\\\"sK\u0006$X\rV8qS\u000e\u001cXI\\1cY\u0016D\u0001\"a4\u0001A\u0003%\u0011qP\u0001\u0018CV$xn\u0011:fCR,Gk\u001c9jGN,e.\u00192mK\u0002B\u0001\"a5\u0001\u0005\u0004%\tAN\u0001\u001aG>tGO]8mY\u0016\u00148k\\2lKR$\u0016.\\3pkRl5\u000fC\u0004\u0002X\u0002\u0001\u000b\u0011B\u001c\u00025\r|g\u000e\u001e:pY2,'oU8dW\u0016$H+[7f_V$Xj\u001d\u0011\t\u0011\u0005m\u0007A1A\u0005\u0002Y\n!dY8oiJ|G\u000e\\3s\u001b\u0016\u001c8/Y4f#V,W/Z*ju\u0016Dq!a8\u0001A\u0003%q'A\u000ed_:$(o\u001c7mKJlUm]:bO\u0016\fV/Z;f'&TX\r\t\u0005\t\u0003G\u0004!\u0019!C\u0001m\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\u0005\u001d\b\u0001)A\u0005o\u0005IB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u0011%\tY\u000f\u0001b\u0001\n\u0003\tY\"A\nsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fC\u0004\u0002p\u0002\u0001\u000b\u0011B\u0019\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0011%\t\u0019\u0010\u0001b\u0001\n\u0003\tY\"A\u000bsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:\t\u000f\u0005]\b\u0001)A\u0005c\u00051\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\b\u0005\u0003\u0005\u0002|\u0002\u0011\r\u0011\"\u00017\u0003Y\u0011X\r\u001d7jG\u0006\u001cvnY6fiRKW.Z8vi6\u001b\bbBA\u0000\u0001\u0001\u0006IaN\u0001\u0018e\u0016\u0004H.[2b'>\u001c7.\u001a;US6,w.\u001e;Ng\u0002B\u0001Ba\u0001\u0001\u0005\u0004%\tAN\u0001 e\u0016\u0004H.[2b'>\u001c7.\u001a;SK\u000e,\u0017N^3Ck\u001a4WM\u001d\"zi\u0016\u001c\bb\u0002B\u0004\u0001\u0001\u0006IaN\u0001!e\u0016\u0004H.[2b'>\u001c7.\u001a;SK\u000e,\u0017N^3Ck\u001a4WM\u001d\"zi\u0016\u001c\b\u0005\u0003\u0005\u0003\f\u0001\u0011\r\u0011\"\u00017\u0003Q\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D()\u001f;fg\"9!q\u0002\u0001!\u0002\u00139\u0014!\u0006:fa2L7-\u0019$fi\u000eDW*\u0019=CsR,7\u000f\t\u0005\t\u0005'\u0001!\u0019!C\u0001m\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\bb\u0002B\f\u0001\u0001\u0006IaN\u0001\u0017e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'tA!A!1\u0004\u0001C\u0002\u0013\u0005a'\u0001\u000bsKBd\u0017nY1GKR\u001c\u0007.T5o\u0005f$Xm\u001d\u0005\b\u0005?\u0001\u0001\u0015!\u00038\u0003U\u0011X\r\u001d7jG\u00064U\r^2i\u001b&t')\u001f;fg\u0002B\u0001Ba\t\u0001\u0005\u0004%\tAN\u0001\u0013]Vl'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u00148\u000fC\u0004\u0003(\u0001\u0001\u000b\u0011B\u001c\u0002'9,XNU3qY&\u001c\u0017MR3uG\",'o\u001d\u0011\t\u0013\t-\u0002A1A\u0005\u0002\u0005m\u0011\u0001\u000b:fa2L7-\u0019%jO\"<\u0016\r^3s[\u0006\u00148n\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY6\u001b\bb\u0002B\u0018\u0001\u0001\u0006I!M\u0001*e\u0016\u0004H.[2b\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dWj\u001d\u0011\t\u0011\tM\u0002A1A\u0005\u0002Y\n1EZ3uG\"\u0004VO]4bi>\u0014\u0018\u0010U;sO\u0016Le\u000e^3sm\u0006d'+Z9vKN$8\u000fC\u0004\u00038\u0001\u0001\u000b\u0011B\u001c\u0002I\u0019,Go\u00195QkJ<\u0017\r^8ssB+(oZ3J]R,'O^1m%\u0016\fX/Z:ug\u0002B\u0001Ba\u000f\u0001\u0005\u0004%\tAN\u0001'aJ|G-^2feB+(oZ1u_JL\b+\u001e:hK&sG/\u001a:wC2\u0014V-];fgR\u001c\bb\u0002B \u0001\u0001\u0006IaN\u0001(aJ|G-^2feB+(oZ1u_JL\b+\u001e:hK&sG/\u001a:wC2\u0014V-];fgR\u001c\b\u0005C\u0005\u0003D\u0001\u0011\r\u0011\"\u0001\u0002~\u0005I\u0012-\u001e;p\u0019\u0016\fG-\u001a:SK\n\fG.\u00198dK\u0016s\u0017M\u00197f\u0011!\u00119\u0005\u0001Q\u0001\n\u0005}\u0014AG1vi>dU-\u00193feJ+'-\u00197b]\u000e,WI\\1cY\u0016\u0004\u0003\u0002\u0003B&\u0001\t\u0007I\u0011\u0001\u001c\u0002E1,\u0017\rZ3s\u00136\u0014\u0017\r\\1oG\u0016\u0004VM\u001d\"s_.,'\u000fU3sG\u0016tG/Y4f\u0011\u001d\u0011y\u0005\u0001Q\u0001\n]\n1\u0005\\3bI\u0016\u0014\u0018*\u001c2bY\u0006t7-\u001a)fe\n\u0013xn[3s!\u0016\u00148-\u001a8uC\u001e,\u0007\u0005\u0003\u0005\u0003T\u0001\u0011\r\u0011\"\u00017\u0003\rbW-\u00193fe&k'-\u00197b]\u000e,7\t[3dW&sG/\u001a:wC2\u001cVmY8oINDqAa\u0016\u0001A\u0003%q'\u0001\u0013mK\u0006$WM]%nE\u0006d\u0017M\\2f\u0007\",7m[%oi\u0016\u0014h/\u00197TK\u000e|g\u000eZ:!\u0011!\u0011Y\u0006\u0001b\u0001\n\u00031\u0014\u0001H2p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:l\u0015\r\u001f*fiJLWm\u001d\u0005\b\u0005?\u0002\u0001\u0015!\u00038\u0003u\u0019wN\u001c;s_2dW\rZ*ikR$wn\u001e8NCb\u0014V\r\u001e:jKN\u0004\u0003\u0002\u0003B2\u0001\t\u0007I\u0011\u0001\u001c\u0002A\r|g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c*fiJL()Y2l_\u001a4Wj\u001d\u0005\b\u0005O\u0002\u0001\u0015!\u00038\u0003\u0005\u001awN\u001c;s_2dW\rZ*ikR$wn\u001e8SKR\u0014\u0018PQ1dW>4g-T:!\u0011%\u0011Y\u0007\u0001b\u0001\n\u0003\ti(\u0001\rd_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tWI\\1cY\u0016D\u0001Ba\u001c\u0001A\u0003%\u0011qP\u0001\u001aG>tGO]8mY\u0016$7\u000b[;uI><h.\u00128bE2,\u0007\u0005\u0003\u0005\u0003t\u0001\u0011\r\u0011\"\u00017\u0003UygMZ:fi6+G/\u00193bi\u0006l\u0015\r_*ju\u0016DqAa\u001e\u0001A\u0003%q'\u0001\fpM\u001a\u001cX\r^'fi\u0006$\u0017\r^1NCb\u001c\u0016N_3!\u0001")
public class KafkaConfig
extends ZKConfig
implements ScalaObject {
    private final VerifiableProperties props;
    private final int brokerId;
    private final int messageMaxBytes;
    private final int numNetworkThreads;
    private final int numIoThreads;
    private final int backgroundThreads;
    private final int queuedMaxRequests;
    private final int port;
    private final String hostName;
    private final String advertisedHostName;
    private final int advertisedPort;
    private final int socketSendBufferBytes;
    private final int socketReceiveBufferBytes;
    private final int socketRequestMaxBytes;
    private final int numPartitions;
    private final Seq<String> logDirs;
    private final int logSegmentBytes;
    private final int logRollHours;
    private final long logRetentionTimeMillis;
    private final long logRetentionBytes;
    private final long logCleanupIntervalMs;
    private final String logCleanupPolicy;
    private final int logCleanerThreads;
    private final double logCleanerIoMaxBytesPerSecond;
    private final long logCleanerDedupeBufferSize;
    private final int logCleanerIoBufferSize;
    private final double logCleanerDedupeBufferLoadFactor;
    private final long logCleanerBackoffMs;
    private final double logCleanerMinCleanRatio;
    private final boolean logCleanerEnable;
    private final long logCleanerDeleteRetentionMs;
    private final int logIndexSizeMaxBytes;
    private final int logIndexIntervalBytes;
    private final long logFlushIntervalMessages;
    private final long logDeleteDelayMs;
    private final long logFlushSchedulerIntervalMs;
    private final long logFlushIntervalMs;
    private final int logFlushOffsetCheckpointIntervalMs;
    private final boolean autoCreateTopicsEnable;
    private final int controllerSocketTimeoutMs;
    private final int controllerMessageQueueSize;
    private final int defaultReplicationFactor;
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaSocketTimeoutMs;
    private final int replicaSocketReceiveBufferBytes;
    private final int replicaFetchMaxBytes;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final int numReplicaFetchers;
    private final long replicaHighWatermarkCheckpointIntervalMs;
    private final int fetchPurgatoryPurgeIntervalRequests;
    private final int producerPurgatoryPurgeIntervalRequests;
    private final boolean autoLeaderRebalanceEnable;
    private final int leaderImbalancePerBrokerPercentage;
    private final int leaderImbalanceCheckIntervalSeconds;
    private final int controlledShutdownMaxRetries;
    private final int controlledShutdownRetryBackoffMs;
    private final boolean controlledShutdownEnable;
    private final int offsetMetadataMaxSize;

    public VerifiableProperties props() {
        return this.props;
    }

    private long getLogRetentionTimeMillis() {
        long millisInMinute = 60000L;
        long millisInHour = 60L * millisInMinute;
        return this.props().containsKey("log.retention.minutes") ? millisInMinute * (long)this.props().getIntInRange("log.retention.minutes", (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE)) : millisInHour * (long)this.props().getIntInRange("log.retention.hours", 168, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int numNetworkThreads() {
        return this.numNetworkThreads;
    }

    public int numIoThreads() {
        return this.numIoThreads;
    }

    public int backgroundThreads() {
        return this.backgroundThreads;
    }

    public int queuedMaxRequests() {
        return this.queuedMaxRequests;
    }

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public String advertisedHostName() {
        return this.advertisedHostName;
    }

    public int advertisedPort() {
        return this.advertisedPort;
    }

    public int socketSendBufferBytes() {
        return this.socketSendBufferBytes;
    }

    public int socketReceiveBufferBytes() {
        return this.socketReceiveBufferBytes;
    }

    public int socketRequestMaxBytes() {
        return this.socketRequestMaxBytes;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Seq<String> logDirs() {
        return this.logDirs;
    }

    public int logSegmentBytes() {
        return this.logSegmentBytes;
    }

    public int logRollHours() {
        return this.logRollHours;
    }

    public long logRetentionTimeMillis() {
        return this.logRetentionTimeMillis;
    }

    public long logRetentionBytes() {
        return this.logRetentionBytes;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public String logCleanupPolicy() {
        return this.logCleanupPolicy;
    }

    public int logCleanerThreads() {
        return this.logCleanerThreads;
    }

    public double logCleanerIoMaxBytesPerSecond() {
        return this.logCleanerIoMaxBytesPerSecond;
    }

    public long logCleanerDedupeBufferSize() {
        return this.logCleanerDedupeBufferSize;
    }

    public int logCleanerIoBufferSize() {
        return this.logCleanerIoBufferSize;
    }

    public double logCleanerDedupeBufferLoadFactor() {
        return this.logCleanerDedupeBufferLoadFactor;
    }

    public long logCleanerBackoffMs() {
        return this.logCleanerBackoffMs;
    }

    public double logCleanerMinCleanRatio() {
        return this.logCleanerMinCleanRatio;
    }

    public boolean logCleanerEnable() {
        return this.logCleanerEnable;
    }

    public long logCleanerDeleteRetentionMs() {
        return this.logCleanerDeleteRetentionMs;
    }

    public int logIndexSizeMaxBytes() {
        return this.logIndexSizeMaxBytes;
    }

    public int logIndexIntervalBytes() {
        return this.logIndexIntervalBytes;
    }

    public long logFlushIntervalMessages() {
        return this.logFlushIntervalMessages;
    }

    public long logDeleteDelayMs() {
        return this.logDeleteDelayMs;
    }

    public long logFlushSchedulerIntervalMs() {
        return this.logFlushSchedulerIntervalMs;
    }

    public long logFlushIntervalMs() {
        return this.logFlushIntervalMs;
    }

    public int logFlushOffsetCheckpointIntervalMs() {
        return this.logFlushOffsetCheckpointIntervalMs;
    }

    public boolean autoCreateTopicsEnable() {
        return this.autoCreateTopicsEnable;
    }

    public int controllerSocketTimeoutMs() {
        return this.controllerSocketTimeoutMs;
    }

    public int controllerMessageQueueSize() {
        return this.controllerMessageQueueSize;
    }

    public int defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaSocketTimeoutMs() {
        return this.replicaSocketTimeoutMs;
    }

    public int replicaSocketReceiveBufferBytes() {
        return this.replicaSocketReceiveBufferBytes;
    }

    public int replicaFetchMaxBytes() {
        return this.replicaFetchMaxBytes;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public long replicaHighWatermarkCheckpointIntervalMs() {
        return this.replicaHighWatermarkCheckpointIntervalMs;
    }

    public int fetchPurgatoryPurgeIntervalRequests() {
        return this.fetchPurgatoryPurgeIntervalRequests;
    }

    public int producerPurgatoryPurgeIntervalRequests() {
        return this.producerPurgatoryPurgeIntervalRequests;
    }

    public boolean autoLeaderRebalanceEnable() {
        return this.autoLeaderRebalanceEnable;
    }

    public int leaderImbalancePerBrokerPercentage() {
        return this.leaderImbalancePerBrokerPercentage;
    }

    public int leaderImbalanceCheckIntervalSeconds() {
        return this.leaderImbalanceCheckIntervalSeconds;
    }

    public int controlledShutdownMaxRetries() {
        return this.controlledShutdownMaxRetries;
    }

    public int controlledShutdownRetryBackoffMs() {
        return this.controlledShutdownRetryBackoffMs;
    }

    public boolean controlledShutdownEnable() {
        return this.controlledShutdownEnable;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    private KafkaConfig(VerifiableProperties props) {
        this.props = props;
        super(props);
        this.brokerId = props.getIntInRange("broker.id", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.messageMaxBytes = props.getIntInRange("message.max.bytes", 1000000 + MessageSet$.MODULE$.LogOverhead(), (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.numNetworkThreads = props.getIntInRange("num.network.threads", 3, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numIoThreads = props.getIntInRange("num.io.threads", 8, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.backgroundThreads = props.getIntInRange("background.threads", 4, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.queuedMaxRequests = props.getIntInRange("queued.max.requests", 500, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.port = props.getInt("port", 6667);
        this.hostName = props.getString("host.name", null);
        this.advertisedHostName = props.getString("advertised.host.name", this.hostName());
        this.advertisedPort = props.getInt("advertised.port", this.port());
        this.socketSendBufferBytes = props.getInt("socket.send.buffer.bytes", 102400);
        this.socketReceiveBufferBytes = props.getInt("socket.receive.buffer.bytes", 102400);
        this.socketRequestMaxBytes = props.getIntInRange("socket.request.max.bytes", 0x6400000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numPartitions = props.getIntInRange("num.partitions", 1, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logDirs = Utils$.MODULE$.parseCsvList(props.getString("log.dirs", props.getString("log.dir", "/tmp/kafka-logs")));
        Predef$.MODULE$.require(this.logDirs().size() > 0);
        this.logSegmentBytes = props.getIntInRange("log.segment.bytes", 0x40000000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(Message$.MODULE$.MinHeaderSize(), Integer.MAX_VALUE));
        this.logRollHours = props.getIntInRange("log.roll.hours", 168, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRetentionTimeMillis = this.getLogRetentionTimeMillis();
        this.logRetentionBytes = props.getLong("log.retention.bytes", -1L);
        this.logCleanupIntervalMs = props.getLongInRange("log.retention.check.interval.ms", 300000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(1L, Long.MAX_VALUE));
        this.logCleanupPolicy = props.getString("log.cleanup.policy", "delete");
        this.logCleanerThreads = props.getIntInRange("log.cleaner.threads", 1, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logCleanerIoMaxBytesPerSecond = props.getDouble("log.cleaner.io.max.bytes.per.second", Double.MAX_VALUE);
        this.logCleanerDedupeBufferSize = props.getLongInRange("log.cleaner.dedupe.buffer.size", 524288000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        Predef$.MODULE$.require(this.logCleanerDedupeBufferSize() / (long)this.logCleanerThreads() > 0x100000L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "log.cleaner.dedupe.buffer.size must be at least 1MB per cleaner thread.";
            }
        });
        this.logCleanerIoBufferSize = props.getIntInRange("log.cleaner.io.buffer.size", 524288, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logCleanerDedupeBufferLoadFactor = props.getDouble("log.cleaner.io.buffer.load.factor", 0.9);
        this.logCleanerBackoffMs = props.getLongInRange("log.cleaner.backoff.ms", 15000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        this.logCleanerMinCleanRatio = props.getDouble("log.cleaner.min.cleanable.ratio", 0.5);
        this.logCleanerEnable = props.getBoolean("log.cleaner.enable", false);
        this.logCleanerDeleteRetentionMs = props.getLong("log.cleaner.delete.retention.ms", 86400000L);
        this.logIndexSizeMaxBytes = props.getIntInRange("log.index.size.max.bytes", 0xA00000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(4, Integer.MAX_VALUE));
        this.logIndexIntervalBytes = props.getIntInRange("log.index.interval.bytes", 4096, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.logFlushIntervalMessages = props.getLongInRange("log.flush.interval.messages", Long.MAX_VALUE, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(1L, Long.MAX_VALUE));
        this.logDeleteDelayMs = props.getLongInRange("log.segment.delete.delay.ms", 60000L, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(0L, Long.MAX_VALUE));
        this.logFlushSchedulerIntervalMs = props.getLong("log.flush.scheduler.interval.ms", Long.MAX_VALUE);
        this.logFlushIntervalMs = props.getLong("log.flush.interval.ms", this.logFlushSchedulerIntervalMs());
        this.logFlushOffsetCheckpointIntervalMs = props.getIntInRange("log.flush.offset.checkpoint.interval.ms", 60000, (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.autoCreateTopicsEnable = props.getBoolean("auto.create.topics.enable", true);
        this.controllerSocketTimeoutMs = props.getInt("controller.socket.timeout.ms", 30000);
        this.controllerMessageQueueSize = props.getInt("controller.message.queue.size", 10);
        this.defaultReplicationFactor = props.getInt("default.replication.factor", 1);
        this.replicaLagTimeMaxMs = props.getLong("replica.lag.time.max.ms", 10000L);
        this.replicaLagMaxMessages = props.getLong("replica.lag.max.messages", 4000L);
        this.replicaSocketTimeoutMs = props.getInt("replica.socket.timeout.ms", ConsumerConfig$.MODULE$.SocketTimeout());
        this.replicaSocketReceiveBufferBytes = props.getInt("replica.socket.receive.buffer.bytes", ConsumerConfig$.MODULE$.SocketBufferSize());
        this.replicaFetchMaxBytes = props.getIntInRange("replica.fetch.max.bytes", ConsumerConfig$.MODULE$.FetchSize(), (Tuple2<Object, Object>)new Tuple2.mcII.sp(this.messageMaxBytes(), Integer.MAX_VALUE));
        this.replicaFetchWaitMaxMs = props.getInt("replica.fetch.wait.max.ms", 500);
        Predef$.MODULE$.require((long)this.replicaFetchWaitMaxMs() <= this.replicaLagTimeMaxMs(), (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "replica.fetch.wait.max.ms should always be at least replica.lag.time.max.ms to prevent frequent changes in ISR";
            }
        });
        this.replicaFetchMinBytes = props.getInt("replica.fetch.min.bytes", 1);
        this.numReplicaFetchers = props.getInt("num.replica.fetchers", 1);
        this.replicaHighWatermarkCheckpointIntervalMs = props.getLong("replica.high.watermark.checkpoint.interval.ms", 5000L);
        this.fetchPurgatoryPurgeIntervalRequests = props.getInt("fetch.purgatory.purge.interval.requests", 10000);
        this.producerPurgatoryPurgeIntervalRequests = props.getInt("producer.purgatory.purge.interval.requests", 10000);
        this.autoLeaderRebalanceEnable = props.getBoolean("auto.leader.rebalance.enable", false);
        this.leaderImbalancePerBrokerPercentage = props.getInt("leader.imbalance.per.broker.percentage", 10);
        this.leaderImbalanceCheckIntervalSeconds = props.getInt("leader.imbalance.check.interval.seconds", 300);
        this.controlledShutdownMaxRetries = props.getInt("controlled.shutdown.max.retries", 3);
        this.controlledShutdownRetryBackoffMs = props.getInt("controlled.shutdown.retry.backoff.ms", 5000);
        this.controlledShutdownEnable = props.getBoolean("controlled.shutdown.enable", false);
        this.offsetMetadataMaxSize = props.getInt("offset.metadata.max.bytes", 1024);
    }

    public KafkaConfig(Properties originalProps) {
        this(new VerifiableProperties(originalProps));
        this.props().verify();
    }
}

