/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.KafkaConfig;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rUs!B\u0001\u0003\u0011\u000b9\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148cA\u0005\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000e\n\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dq\u0012B1A\u0005\u0002}\t1#\u00168l]><h\u000eT8h\u000b:$wJ\u001a4tKR,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\t1{gn\u001a\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002)Us7N\\8x]2{w-\u00128e\u001f\u001a47/\u001a;!\u0011\u001d1\u0013B1A\u0005\u0002\u001d\nQ\u0003S5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f]\u0006lW-F\u0001)!\ti\u0011&\u0003\u0002+\u001d\t11\u000b\u001e:j]\u001eDa\u0001L\u0005!\u0002\u0013A\u0013A\u0006%jO\"<\u0016\r^3s[\u0006\u00148NR5mK:\fW.\u001a\u0011\u0007\t)\u0011\u0001AL\n\u0006[1yS\u0007\u0006\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\tQ!\u001e;jYNL!\u0001N\u0019\u0003\u000f1{wmZ5oOB\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\b[\u0016$(/[2t\u0013\tQtGA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001\u0002P\u0017\u0003\u0006\u0004%\t!P\u0001\u0007G>tg-[4\u0016\u0003y\u0002\"\u0001C \n\u0005\u0001\u0013!aC&bM.\f7i\u001c8gS\u001eD\u0001BQ\u0017\u0003\u0002\u0003\u0006IAP\u0001\bG>tg-[4!\u0011!!UF!A!\u0002\u0013)\u0015\u0001\u0002;j[\u0016\u0004\"\u0001\r$\n\u0005\u001d\u000b$\u0001\u0002+j[\u0016D\u0001\"S\u0017\u0003\u0006\u0004%\tAS\u0001\tu.\u001cE.[3oiV\t1\n\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006A!p[2mS\u0016tGO\u0003\u0002Q#\u00061\u0011\nM%uK\u000eT\u0011AU\u0001\u0004_J<\u0017B\u0001+N\u0005!Q6n\u00117jK:$\b\u0002\u0003,.\u0005\u0003\u0005\u000b\u0011B&\u0002\u0013i\\7\t\\5f]R\u0004\u0003\u0002\u0003-.\u0005\u0003\u0005\u000b\u0011B-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u0019[\u0013\tY\u0016GA\u0005TG\",G-\u001e7fe\"AQ,\fBC\u0002\u0013\u0005a,\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u0012\t1\u0001\\8h\u0013\t!\u0017M\u0001\u0006M_\u001el\u0015M\\1hKJD\u0001BZ\u0017\u0003\u0002\u0003\u0006IaX\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005i[\t\u0015\r\u0011\"\u0001j\u00039I7o\u00155viRLgn\u001a#po:,\u0012A\u001b\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\fa!\u0019;p[&\u001c'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003cB\tA!\u001e;jY&\u00111\u000f\u001c\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u0011Ul#\u0011!Q\u0001\n)\fq\"[:TQV$H/\u001b8h\t><h\u000e\t\u0005\u000675\"\ta\u001e\u000b\bqfT8\u0010`?\u007f!\tAQ\u0006C\u0003=m\u0002\u0007a\bC\u0003Em\u0002\u0007Q\tC\u0003Jm\u0002\u00071\nC\u0003Ym\u0002\u0007\u0011\fC\u0003^m\u0002\u0007q\fC\u0003im\u0002\u0007!\u000eC\u0005\u0002\u00025\u0002\r\u0011\"\u0001\u0002\u0004\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\u0006A\u0019Q#a\u0002\n\u0007\u0005%aCA\u0002J]RD\u0011\"!\u0004.\u0001\u0004%\t!a\u0004\u0002'\r|g\u000e\u001e:pY2,'/\u00129pG\"|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004+\u0005M\u0011bAA\u000b-\t!QK\\5u\u0011)\tI\"a\u0003\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0004\u0002CA\u000f[\u0001\u0006K!!\u0002\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003\u0006BA\u000e\u0003C\u00012!FA\u0012\u0013\r\t)C\u0006\u0002\tm>d\u0017\r^5mK\"I\u0011\u0011F\u0017C\u0002\u0013%\u00111A\u0001\u000eY>\u001c\u0017\r\u001c\"s_.,'/\u00133\t\u0011\u00055R\u0006)A\u0005\u0003\u000b\ta\u0002\\8dC2\u0014%o\\6fe&#\u0007\u0005C\u0005\u000225\u0012\r\u0011\"\u0003\u00024\u0005i\u0011\r\u001c7QCJ$\u0018\u000e^5p]N,\"!!\u000e\u0011\u000fA\n9$a\u000f\u0002N%\u0019\u0011\u0011H\u0019\u0003\tA{w\u000e\u001c\t\b+\u0005u\u0012\u0011IA\u0003\u0013\r\tyD\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\r\u0013\u0011\n\b\u0004+\u0005\u0015\u0013bAA$-\u00051\u0001K]3eK\u001aL1AKA&\u0015\r\t9E\u0006\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011qKA)\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\\5\u0002\u000b\u0011BA\u001b\u00039\tG\u000e\u001c)beRLG/[8og\u0002B\u0011\"a\u0018.\u0001\u0004%I!!\u0019\u0002!1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cXCAA2!\u0019\t)'a\u001c\u0002N5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0004nkR\f'\r\\3\u000b\u0007\u00055d#\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002h\t9\u0001*Y:i'\u0016$\b\"CA;[\u0001\u0007I\u0011BA<\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011\u0011CA=\u0011)\tI\"a\u001d\u0002\u0002\u0003\u0007\u00111\r\u0005\t\u0003{j\u0003\u0015)\u0003\u0002d\u0005\tB.Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0013\u0005\u0005UF1A\u0005\n\u0005\r\u0015\u0001\u00067fC\u0012,'\u000fU1si&$\u0018n\u001c8t\u0019>\u001c7.F\u0001\r\u0011\u001d\t9)\fQ\u0001\n1\tQ\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\:M_\u000e\\\u0007\u0005C\u0005\u0002\f6\u0012\r\u0011\"\u0003\u0002\u0004\u00061\"/\u001a9mS\u000e\f7\u000b^1uK\u000eC\u0017M\\4f\u0019>\u001c7\u000eC\u0004\u0002\u00106\u0002\u000b\u0011\u0002\u0007\u0002/I,\u0007\u000f\\5dCN#\u0018\r^3DQ\u0006tw-\u001a'pG.\u0004\u0003\"CAJ[\t\u0007I\u0011AAK\u0003U\u0011X\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ,\"!a&\u0011\u0007!\tI*C\u0002\u0002\u001c\n\u0011QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005\u0002 6\u0002\u000b\u0011BAL\u0003Y\u0011X\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ\u0004\u0003\u0002CAR[\t\u0007I\u0011B5\u0002I!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b)pS:$H\u000b\u001b:fC\u0012\u001cF/\u0019:uK\u0012Dq!a*.A\u0003%!.A\u0013iS\u001eDw+\u0019;fe6\f'o[\"iK\u000e\\\u0007k\\5oiRC'/Z1e'R\f'\u000f^3eA!I\u00111V\u0017C\u0002\u0013\u0005\u0011QV\u0001\u0019Q&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000e]8j]R\u001cXCAAX!!\t\t,a.\u0002B\u0005mVBAAZ\u0015\u0011\t),a\u001b\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA]\u0003g\u00131!T1q!\rA\u0011QX\u0005\u0004\u0003\u007f\u0013!\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011!\t\u0019-\fQ\u0001\n\u0005=\u0016!\u00075jO\"<\u0016\r^3s[\u0006\u00148n\u00115fG.\u0004x.\u001b8ug\u0002B\u0011\"a2.\u0001\u0004%I!!3\u0002'!<H\u000b\u001b:fC\u0012Le.\u001b;jC2L'0\u001a3\u0016\u0005\u0005-\u0007cA\u000b\u0002N&\u0019\u0011q\u001a\f\u0003\u000f\t{w\u000e\\3b]\"I\u00111[\u0017A\u0002\u0013%\u0011Q[\u0001\u0018Q^$\u0006N]3bI&s\u0017\u000e^5bY&TX\rZ0%KF$B!!\u0005\u0002X\"Q\u0011\u0011DAi\u0003\u0003\u0005\r!a3\t\u0011\u0005mW\u0006)Q\u0005\u0003\u0017\fA\u0003[<UQJ,\u0017\rZ%oSRL\u0017\r\\5{K\u0012\u0004\u0003\"CAp[\t\u0007I\u0011AAq\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0003G\u0004B!!:\u0002p6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/A\u0003m_\u001e$$NC\u0002\u0002nF\u000ba!\u00199bG\",\u0017\u0002BAy\u0003O\u0014a\u0001T8hO\u0016\u0014\b\u0002CA{[\u0001\u0006I!a9\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\t\u0005\n\u0003sl#\u0019!C\u0001\u0003w\fQ\"[:s\u000bb\u0004\u0018M\u001c3SCR,WCAA\u007f!\u0011\tyPa\u0004\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\tAaY8sK*\u0019\u0001Ha\u0002\u000b\t\t%!1B\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\t5\u0011aA2p[&!!\u0011\u0003B\u0001\u0005\u0015iU\r^3s\u0011!\u0011)\"\fQ\u0001\n\u0005u\u0018AD5te\u0016C\b/\u00198e%\u0006$X\r\t\u0005\n\u00053i#\u0019!C\u0001\u0003w\fQ\"[:s'\"\u0014\u0018N\\6SCR,\u0007\u0002\u0003B\u000f[\u0001\u0006I!!@\u0002\u001d%\u001c(o\u00155sS:\\'+\u0019;fA!9!\u0011E\u0017\u0005\u0002\t\r\u0012!H;oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0015\u0005\u0005\u0015\u0001b\u0002B\u0014[\u0011\u0005!\u0011F\u0001$gR\f'\u000f\u001e%jO\"<\u0016\r^3s\u001b\u0006\u00148n]\"iK\u000e\\\u0007k\\5oiRC'/Z1e)\t\t\t\u0002C\u0004\u0003.5\"\tAa\f\u0002A\u001d,GOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0007\u0003\u000b\u0011\tD!\u000e\t\u0011\tM\"1\u0006a\u0001\u0003\u0003\nQ\u0001^8qS\u000eD\u0001Ba\u000e\u0003,\u0001\u0007\u0011QA\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0003<5\"\tA!\u000b\u0002\u000fM$\u0018M\u001d;va\"9!qH\u0017\u0005\u0002\t\u0005\u0013aC:u_B\u0014V\r\u001d7jG\u0006$\u0002Ba\u0011\u0003J\t-#Q\n\t\u0004+\t\u0015\u0013b\u0001B$-\t)1\u000b[8si\"A!1\u0007B\u001f\u0001\u0004\t\t\u0005\u0003\u0005\u00038\tu\u0002\u0019AA\u0003\u0011!\u0011yE!\u0010A\u0002\u0005-\u0017a\u00043fY\u0016$X\rU1si&$\u0018n\u001c8\t\u000f\tMS\u0006\"\u0001\u0003V\u0005a1\u000f^8q%\u0016\u0004H.[2bgR!!q\u000bB5!\u001d)\u0012Q\bB-\u0005\u0007\u0002\u0002\"!\u001a\u0003\\\tu#1I\u0005\u0005\u0003s\u000b9\u0007\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019\u0007B\u0001\u0007G>lWn\u001c8\n\t\t\u001d$\u0011\r\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002\u0003B6\u0005#\u0002\rA!\u001c\u0002%M$x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e\t\u0005\u0005_\u0012)(\u0004\u0002\u0003r)\u0019!1\u000f\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003x\tE$AE*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRDqAa\u001f.\t\u0003\u0011i(\u0001\u000bhKR|%o\u0011:fCR,\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003\u001b\u0012yH!!\u0003\u0004\"A!1\u0007B=\u0001\u0004\t\t\u0005\u0003\u0005\u00038\te\u0004\u0019AA\u0003\u0011!\u0011)I!\u001fA\u0002\u0005\u0015\u0011!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"9!\u0011R\u0017\u0005\u0002\t-\u0015\u0001D4fiB\u000b'\u000f^5uS>tGC\u0002BG\u0005'\u0013)\nE\u0003\u0016\u0005\u001f\u000bi%C\u0002\u0003\u0012Z\u0011aa\u00149uS>t\u0007\u0002\u0003B\u001a\u0005\u000f\u0003\r!!\u0011\t\u0011\t]\"q\u0011a\u0001\u0003\u000bAqA!'.\t\u0003\u0011Y*A\u000bhKR\u0014V\r\u001d7jG\u0006|%/\u0012=dKB$\u0018n\u001c8\u0015\r\tu%1\u0015BS!\u0011\tyEa(\n\t\t\u0005\u0016\u0011\u000b\u0002\b%\u0016\u0004H.[2b\u0011!\u0011\u0019Da&A\u0002\u0005\u0005\u0003\u0002\u0003BT\u0005/\u0003\r!!\u0002\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002BV[\u0011\u0005!QV\u0001\u0018O\u0016$H*Z1eKJ\u0014V\r\u001d7jG\u0006Le\rT8dC2$bA!(\u00030\nE\u0006\u0002\u0003B\u001a\u0005S\u0003\r!!\u0011\t\u0011\t]\"\u0011\u0016a\u0001\u0003\u000bAqA!..\t\u0003\u00119,\u0001\u0006hKR\u0014V\r\u001d7jG\u0006$\u0002B!/\u0003<\nu&q\u0018\t\u0006+\t=%Q\u0014\u0005\t\u0005g\u0011\u0019\f1\u0001\u0002B!A!q\u0007BZ\u0001\u0004\t)\u0001\u0003\u0006\u0003B\nM\u0006\u0013!a\u0001\u0003\u000b\t\u0011B]3qY&\u001c\u0017-\u00133\t\u000f\t\u0015W\u0006\"\u0001\u0003H\u00061\"-Z2p[\u0016dU-\u00193fe>\u0013hi\u001c7m_^,'\u000f\u0006\u0003\u0003J\nE\u0007cB\u000b\u0002>\t-'1\t\t\t\u0005\u001b\u0014y-a\u000f\u0003D5\u0011\u00111N\u0005\u0005\u0003s\u000bY\u0007\u0003\u0005\u0003T\n\r\u0007\u0019\u0001Bk\u0003MaW-\u00193fe\u0006sG-S*S%\u0016\fX/Z:u!\u0011\u0011yGa6\n\t\te'\u0011\u000f\u0002\u0014\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u0005\b\u0005;lC\u0011\u0002Bp\u0003-i\u0017m[3MK\u0006$WM]:\u0015\u0019\u0005E!\u0011\u001dBs\u0005S\u0014)P!?\t\u0011\t\r(1\u001ca\u0001\u0003\u000b\tAbY8oiJ|G\u000e\\3s\u0013\u0012D\u0001Ba:\u0003\\\u0002\u0007\u0011QA\u0001\u0006KB|7\r\u001b\u0005\t\u0005W\u0014Y\u000e1\u0001\u0003n\u0006q\u0001/\u0019:uSRLwN\\*uCR,\u0007\u0003\u0003Bg\u0005\u001f\fiEa<\u0011\t\t=$\u0011_\u0005\u0005\u0005g\u0014\tH\u0001\nQCJ$\u0018\u000e^5p]N#\u0018\r^3J]\u001a|\u0007\u0002\u0003B|\u00057\u0004\r!!\u0002\u0002\u001b\r|'O]3mCRLwN\\%e\u0011!\u0011YPa7A\u0002\tu\u0018a\u0003:fgB|gn]3NCB\u0004\u0002\"!\u001a\u0003\\\u0005m\"1\t\u0005\b\u0007\u0003iC\u0011BB\u0002\u00035i\u0017m[3G_2dwn^3sgRq\u0011\u0011CB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u001c\ru\u0001\u0002\u0003Br\u0005\u007f\u0004\r!!\u0002\t\u0011\t\u001d(q a\u0001\u0003\u000bA\u0001Ba;\u0003\u0000\u0002\u0007!Q\u001e\u0005\t\u0007\u001b\u0011y\u00101\u0001\u0004\u0010\u00059A.Z1eKJ\u001c\bC\u0002Bg\u0007#\u0019)\"\u0003\u0003\u0004\u0014\u0005-$aA*fiB!\u0011qJB\f\u0013\u0011\u0019I\"!\u0015\u0003\r\t\u0013xn[3s\u0011!\u00119Pa@A\u0002\u0005\u0015\u0001\u0002\u0003B~\u0005\u007f\u0004\rA!@\t\u000f\r\u0005R\u0006\"\u0003\u0003*\u0005qQ.Y=cKNC'/\u001b8l\u0013N\u0014\bbBB\u0013[\u0011\u00051qE\u0001\u0017e\u0016\u001cwN\u001d3G_2dwn^3s!>\u001c\u0018\u000e^5p]RQ\u0011\u0011CB\u0015\u0007W\u0019ica\f\t\u0011\tM21\u0005a\u0001\u0003\u0003B\u0001Ba\u000e\u0004$\u0001\u0007\u0011Q\u0001\u0005\t\u0005\u0003\u001c\u0019\u00031\u0001\u0002\u0006!91\u0011GB\u0012\u0001\u0004\u0001\u0013AB8gMN,G\u000fC\u0004\u000465\"\tA!\u000b\u00021\rDWmY6q_&tG\u000fS5hQ^\u000bG/\u001a:nCJ\\7\u000fC\u0004\u0004:5\"\tA!\u000b\u0002\u0011MDW\u000f\u001e3po:D\u0011b!\u0010.#\u0003%\taa\u0010\u0002)\u001d,GOU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tE\u000b\u0003\u0002\u0006\r\r3FAB#!\u0011\u00199e!\u0015\u000e\u0005\r%#\u0002BB&\u0007\u001b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r=c#\u0001\u0006b]:|G/\u0019;j_:LAaa\u0015\u0004J\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final Scheduler scheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final Object replicaStateChangeLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final Logger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final String HighWatermarkFilename() {
        return ReplicaManager$.MODULE$.HighWatermarkFilename();
    }

    public static final long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    public final int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public final HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> hashSet) {
        this.kafka$server$ReplicaManager$$leaderPartitions = hashSet;
    }

    public final Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    private Object replicaStateChangeLock() {
        return this.replicaStateChangeLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean bl) {
        this.hwThreadInitialized = bl;
    }

    public Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public int underReplicatedPartitionCount() {
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            Integer n = BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$leaderPartitions().count((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Partition partition) {
                    return partition.isUnderReplicated();
                }
            }));
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public void startHighWaterMarksCheckPointThread() {
        if (this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true)) {
            String x$9 = "highwatermark-checkpoint";
            Serializable x$10 = new Serializable(this){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointHighWatermarks();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            long x$11 = this.config().replicaHighWatermarkCheckpointIntervalMs();
            TimeUnit x$12 = TimeUnit.MILLISECONDS;
            long x$13 = this.scheduler.schedule$default$3();
            this.scheduler.schedule("highwatermark-checkpoint", (Function0<BoxedUnit>)x$10, x$13, x$11, TimeUnit.MILLISECONDS);
        }
    }

    public int getReplicationFactorForPartition(String topic, int partitionId) {
        Option<Partition> option;
        block4: {
            int n;
            block3: {
                block2: {
                    Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
                    option = partitionOpt;
                    if (!(option instanceof Some)) break block2;
                    n = ((Partition)((Some)option).x()).replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                n = -1;
            }
            return n;
        }
        throw new MatchError(option);
    }

    public void startup() {
        String x$14 = "isr-expiration";
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        long x$16 = this.config().replicaLagTimeMaxMs();
        TimeUnit x$17 = TimeUnit.MILLISECONDS;
        long x$18 = this.scheduler.schedule$default$3();
        this.scheduler.schedule("isr-expiration", (Function0<BoxedUnit>)x$15, x$18, x$16, TimeUnit.MILLISECONDS);
    }

    /*
     * Loose catch block
     */
    public short stopReplica(String topic, int partitionId, boolean deletePartition) {
        Option<Partition> option;
        block11: {
            short errorCode;
            block10: {
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), ((Object)BoxesRunTime.boxToBoolean((boolean)deletePartition)).toString(), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
                errorCode = ErrorMapping$.MODULE$.NoError();
                option = this.getPartition(topic, partitionId);
                if (option instanceof Some) {
                    Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
                    synchronized (object) {
                        Partition removedPartition;
                        this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq(((Some)option).x());
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl10 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (deletePartition && (removedPartition = this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)))) != null) {
                            removedPartition.delete();
                        }
                        break block10;
                    }
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block11;
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d ignoring stop replica (delete=%s) for partition [%s,%d] as replica doesn't exist on broker").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)deletePartition), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
            }
            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d finished handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)deletePartition), topic, BoxesRunTime.boxToInteger((int)partitionId)})));
            return errorCode;
        }
        throw new MatchError(option);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest$1) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$1 = new HashMap();
            if (stopReplicaRequest$1.controllerEpoch() < this.controllerEpoch()) {
                this.stateChangeLogger().warn((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)stopReplicaRequest$1.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())).toString());
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                this.controllerEpoch_$eq(stopReplicaRequest$1.controllerEpoch());
                this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)stopReplicaRequest$1.partitions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(TopicAndPartition r) {
                        return new TopicAndPartition(r.topic(), r.partition());
                    }
                }, Set$.MODULE$.canBuildFrom())));
                stopReplicaRequest$1.partitions().foreach((Function1)new Serializable(this, stopReplicaRequest$1, responseMap$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;
                    private final HashMap responseMap$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<Object> apply(TopicAndPartition topicAndPartition) {
                        short errorCode = this.$outer.stopReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)errorCode));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest;
                        this.responseMap$1 = hashMap;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    public Partition getOrCreatePartition(String topic, int partitionId, int replicationFactor) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), new Partition(topic, partitionId, replicationFactor, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        }
        return partition;
    }

    public Option<Partition> getPartition(String topic, int partitionId) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String topic, int partition) {
        Option<Replica> replicaOpt = this.getReplica(topic, partition, this.getReplica$default$3());
        if (replicaOpt.isDefined()) {
            return (Replica)replicaOpt.get();
        }
        throw new ReplicaNotAvailableException(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), topic, BoxesRunTime.boxToInteger((int)partition)})));
    }

    public Replica getLeaderReplicaIfLocal(String topic, int partitionId) {
        Option<Partition> partitionOpt;
        Option<Partition> option = partitionOpt = this.getPartition(topic, partitionId);
        None$ none$ = None$.MODULE$;
        Option<Partition> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new UnknownTopicOrPartitionException(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.x();
            Partition partition2 = partition;
            Option<Replica> option3 = partition2.leaderReplicaIfLocal();
            if (option3 instanceof Some) {
                return (Replica)((Some)option3).x();
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option4 = option3;
            if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option3);
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(String topic, int partitionId, int replicaId) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> partitionOpt;
                    option = partitionOpt = this.getPartition(topic, partitionId);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                option2 = ((Partition)((Some)option).x()).getReplica(replicaId);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndISRRequest$1) {
        leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                if (tuple22 != null) {
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                    if (tuple23 != null) {
                        this.$outer.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request %s correlation id %d from controller %d epoch %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), partitionStateInfo, BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), tuple23._1(), tuple23._2()})));
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$2 = new HashMap();
            if (leaderAndISRRequest$1.controllerEpoch() < this.controllerEpoch()) {
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final LeaderAndIsrRequest leaderAndISRRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null && tuple22._1() != null) {
                            this.$outer.stateChangeLogger().warn((Object)Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.$outer.controllerEpoch())})));
                            return;
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                int controllerId$1 = leaderAndISRRequest$1.controllerId();
                int correlationId$1 = leaderAndISRRequest$1.correlationId();
                this.controllerEpoch_$eq(leaderAndISRRequest$1.controllerEpoch());
                HashMap partitionState$1 = new HashMap();
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1, responseMap$2, controllerId$1, correlationId$1, partitionState$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final LeaderAndIsrRequest leaderAndISRRequest$1;
                    private final HashMap responseMap$2;
                    private final int controllerId$1;
                    private final int correlationId$1;
                    private final HashMap partitionState$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23 = (Tuple2)tuple22._1();
                            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                            if (tuple23 != null) {
                                Option option;
                                PartitionStateInfo partitionStateInfo2;
                                int n;
                                int partitionId;
                                String string = (String)tuple23._1();
                                String topic = string;
                                Partition partition = this.$outer.getOrCreatePartition(topic, partitionId = (n = BoxesRunTime.unboxToInt((Object)tuple23._2())), (partitionStateInfo2 = partitionStateInfo).replicationFactor());
                                int partitionLeaderEpoch = partition.getLeaderEpoch();
                                if (partitionLeaderEpoch < partitionStateInfo2.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()) {
                                    if (partitionStateInfo2.allReplicas().contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()))) {
                                        option = this.partitionState$1.put((Object)partition, (Object)partitionStateInfo2);
                                    } else {
                                        this.$outer.stateChangeLogger().warn((Object)Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request with correlation id %d from controller %d epoch %d as broker is not in assigned replica list %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.correlationId$1), BoxesRunTime.boxToInteger((int)this.controllerId$1), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), partitionStateInfo2.allReplicas().mkString(","), topic, BoxesRunTime.boxToInteger((int)partition.partitionId())})));
                                        option = BoxedUnit.UNIT;
                                    }
                                } else {
                                    this.$outer.stateChangeLogger().warn((Object)Predef$.MODULE$.augmentString("Broker %d received invalid LeaderAndIsr request with correlation id %d from controller %d epoch %d with an older leader epoch %d for partition [%s,%d], current leader epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.correlationId$1), BoxesRunTime.boxToInteger((int)this.controllerId$1), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)partitionStateInfo2.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()), topic, BoxesRunTime.boxToInteger((int)partition.partitionId()), BoxesRunTime.boxToInteger((int)partitionLeaderEpoch)})));
                                    option = this.responseMap$2.put((Object)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleLeaderEpochCode()));
                                }
                                return option;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                        this.responseMap$2 = hashMap;
                        this.controllerId$1 = n;
                        this.correlationId$1 = n2;
                        this.partitionState$1 = hashMap2;
                    }
                });
                HashMap partitionsTobeLeader = (HashMap)partitionState$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<Partition, PartitionStateInfo> tuple2) {
                        Tuple2<Partition, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return ((PartitionStateInfo)tuple22._2()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == this.$outer.config().brokerId();
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                HashMap partitionsToBeFollower = (HashMap)partitionState$1.$minus$minus((GenTraversableOnce)partitionsTobeLeader.keys());
                if (!partitionsTobeLeader.isEmpty()) {
                    this.makeLeaders(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsTobeLeader, leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2);
                }
                if (!partitionsToBeFollower.isEmpty()) {
                    this.makeFollowers(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsToBeFollower, leaderAndISRRequest$1.leaders(), leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2);
                }
                if (!this.hwThreadInitialized()) {
                    this.startHighWaterMarksCheckPointThread();
                    this.hwThreadInitialized_$eq(true);
                }
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    /*
     * Exception decompiling
     */
    private void makeLeaders(int controllerId$2, int epoch$1, Map<Partition, PartitionStateInfo> partitionState, int correlationId$2, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void makeFollowers(int controllerId$3, int epoch$2, Map<Partition, PartitionStateInfo> partitionState, Set<Broker> leaders$1, int correlationId$3, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        List curLeaderPartitions = null;
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            curLeaderPartitions = this.kafka$server$ReplicaManager$$leaderPartitions().toList();
        }
        curLeaderPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Partition partition) {
                partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void recordFollowerPosition(String topic$1, int partitionId$1, int replicaId, long offset) {
        Option<Partition> partitionOpt = this.getPartition(topic$1, partitionId$1);
        if (partitionOpt.isDefined()) {
            ((Partition)partitionOpt.get()).updateLeaderHWAndMaybeExpandIsr(replicaId, offset);
        } else {
            this.warn((Function0<String>)new Serializable(this, topic$1, partitionId$1){
                public static final long serialVersionUID;
                private final String topic$1;
                private final int partitionId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                }
                {
                    this.topic$1 = string;
                    this.partitionId$1 = n;
                }
            });
        }
    }

    public void checkpointHighWatermarks() {
        Iterable replicas = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Replica> apply(Partition partition) {
                return partition.getReplica(this.$outer.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect(new PartialFunction(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public <A1 extends Option<Replica>, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                return PartialFunction.class.orElse((PartialFunction)this, that);
            }

            public <C> PartialFunction<Option<Replica>, C> andThen(Function1<Replica, C> k) {
                return PartialFunction.class.andThen((PartialFunction)this, k);
            }

            public Function1<Option<Replica>, Option<Replica>> lift() {
                return PartialFunction.class.lift((PartialFunction)this);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
            }

            public <A> Function1<A, Replica> compose(Function1<A, Option<Replica>> g) {
                return Function1.class.compose((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcID$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcII$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcID$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcII$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVJ$sp((Function1)this, g);
            }

            public String toString() {
                return Function1.class.toString((Function1)this);
            }

            public final Replica apply(Option<Replica> option) {
                Option<Replica> option2 = option;
                if (option2 instanceof Some) {
                    return (Replica)((Some)option2).x();
                }
                throw new MatchError(option2);
            }

            public final boolean isDefinedAt(Option<Replica> option) {
                Option<Replica> option2 = option;
                return option2 instanceof Some;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map replicasByDir = ((TraversableLike)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Replica replica) {
                return ((Log)replica.log().get()).dir().getParent();
            }
        });
        ((IterableLike)replicasByDir.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Iterable iterable;
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                Iterable reps = iterable = (Iterable)tuple22._2();
                scala.collection.immutable.Map hwms = ((TraversableOnce)reps.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Object> apply(Replica r) {
                        return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(r)).$minus$greater((Object)BoxesRunTime.boxToLong((long)r.highWatermark()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                try {
                    ((OffsetCheckpoint)this.$outer.highWatermarkCheckpoints().apply(tuple22._1())).write((Map<TopicAndPartition, Object>)hwms);
                    return;
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Error writing to highwatermark file: ";
                        }
                    }, (Function0<Throwable>)new Serializable(this, iOException){
                        public static final long serialVersionUID;
                        private final IOException e$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final IOException apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = iOException;
                        }
                    });
                    Runtime.getRuntime().halt(1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutted down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig config, Time time, ZkClient zkClient, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown) {
        this.config = config;
        this.time = time;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.logManager = logManager;
        this.isShuttingDown = isShuttingDown;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = config.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.init$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaStateChangeLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(config, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)config.logDirs().map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.underReplicatedPartitionCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("IsrShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

