/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.api.OffsetRequest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ReplayLogProducer;
import kafka.tools.ReplayLogProducer$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplayLogProducer$
implements Logging {
    public static final ReplayLogProducer$ MODULE$;
    private final String GroupId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReplayLogProducer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplayLogProducer$ replayLogProducer$ = this;
        synchronized (replayLogProducer$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private String GroupId() {
        return this.GroupId;
    }

    public void main(String[] args) {
        ReplayLogProducer.Config config$1 = new ReplayLogProducer.Config(args);
        ExecutorService executor = Executors.newFixedThreadPool(config$1.numThreads());
        CountDownLatch allDone = new CountDownLatch(config$1.numThreads());
        ZkUtils$.MODULE$.maybeDeletePath(config$1.zkConnect(), new StringBuilder().append((Object)"/consumers/").append((Object)this.GroupId()).toString());
        Thread.sleep(500L);
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", this.GroupId());
        consumerProps.put("zookeeper.connect", config$1.zkConnect());
        consumerProps.put("consumer.timeout.ms", "10000");
        consumerProps.put("auto.offset.reset", OffsetRequest$.MODULE$.SmallestTimeString());
        consumerProps.put("fetch.message.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        consumerProps.put("socket.receive.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x200000)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)config$1.inputTopic()).$minus$greater((Object)BoxesRunTime.boxToInteger((int)config$1.numThreads()))}))));
        ObjectRef threadList$1 = new ObjectRef((Object)Nil$.MODULE$);
        ((IterableLike)topicMessageStreams.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(config$1, threadList$1){
            public static final long serialVersionUID;
            public final ReplayLogProducer.Config config$1;
            public final ObjectRef threadList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    ((LinearSeqOptimized)tuple22._2()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final anonfun.main.2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(KafkaStream<byte[], byte[]> stream) {
                            this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon((Object)new ReplayLogProducer.ZKConsumerThread(this.$outer.config$1, stream));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.config$1 = config;
                this.threadList$1 = objectRef;
            }
        });
        ((List)threadList$1.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ReplayLogProducer.ZKConsumerThread thread) {
                thread.start();
            }
        });
        ((List)threadList$1.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ReplayLogProducer.ZKConsumerThread zKConsumerThread) {
                zKConsumerThread.shutdown();
            }
        });
        consumerConnector.shutdown();
    }

    private ReplayLogProducer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.GroupId = "replay-log-producer";
    }
}

