/*
 * Decompiled with CFR 0.152.
 */
package kafka.client;

import java.io.IOException;
import java.util.Properties;
import kafka.api.ConsumerMetadataRequest;
import kafka.api.ConsumerMetadataRequest$;
import kafka.api.ConsumerMetadataResponse;
import kafka.api.ConsumerMetadataResponse$;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping$;
import kafka.common.KafkaException;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.Receive;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool$;
import kafka.producer.SyncProducer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ClientUtils$
implements Logging {
    public static final ClientUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ClientUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ClientUtils$ clientUtils$ = this;
        synchronized (clientUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics$1, Seq<Broker> brokers, ProducerConfig producerConfig, int correlationId$1) {
        boolean fetchMetaDataSucceeded = false;
        IntRef i$1 = new IntRef(0);
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId$1, producerConfig.clientId(), (Seq<String>)topics$1.toSeq());
        TopicMetadataResponse topicMetadataResponse = null;
        Throwable t = null;
        Seq shuffledBrokers$1 = (Seq)Random$.MODULE$.shuffle(brokers, Seq$.MODULE$.canBuildFrom());
        while (i$1.elem < shuffledBrokers$1.size() && !fetchMetaDataSucceeded) {
            SyncProducer producer = ProducerPool$.MODULE$.createSyncProducer(producerConfig, (Broker)shuffledBrokers$1.apply(i$1.elem));
            this.info((Function0<String>)new Serializable(topics$1, correlationId$1, i$1, shuffledBrokers$1){
                public static final long serialVersionUID;
                private final Set topics$1;
                private final int correlationId$1;
                private final IntRef i$1;
                private final Seq shuffledBrokers$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Fetching metadata from broker %s with correlation id %d for %d topic(s) %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shuffledBrokers$1.apply(this.i$1.elem), BoxesRunTime.boxToInteger((int)this.correlationId$1), BoxesRunTime.boxToInteger((int)this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = set;
                    this.correlationId$1 = n;
                    this.i$1 = intRef;
                    this.shuffledBrokers$1 = seq;
                }
            });
            {
                topicMetadataResponse = producer.send(topicMetadataRequest);
                fetchMetaDataSucceeded = true;
                ++i$1.elem;
                producer.close();
            }
        }
        if (fetchMetaDataSucceeded) {
            this.debug((Function0<String>)new Serializable(topics$1){
                public static final long serialVersionUID;
                private final Set topics$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Successfully fetched metadata for %d topic(s) %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = set;
                }
            });
            return topicMetadataResponse;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("fetching topic metadata for topics [%s] from broker [%s] failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics$1, shuffledBrokers$1})), t);
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<Broker> brokers, String clientId, int timeoutMs, int correlationId) {
        Properties props = new Properties();
        props.put("metadata.broker.list", ((TraversableOnce)brokers.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Broker broker) {
                return broker.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        props.put("client.id", clientId);
        props.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)timeoutMs)).toString());
        ProducerConfig producerConfig = new ProducerConfig(props);
        return this.fetchTopicMetadata(topics, brokers, producerConfig, correlationId);
    }

    public int fetchTopicMetadata$default$5() {
        return 0;
    }

    public Seq<Broker> parseBrokerList(String brokerListStr) {
        Seq<String> brokersStr = Utils$.MODULE$.parseCsvList(brokerListStr);
        return (Seq)((TraversableLike)brokersStr.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Broker apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string;
                    String address = string = (String)tuple22._1();
                    return new Broker(BoxesRunTime.unboxToInt((Object)tuple22._2()), Utils.getHost((String)address), Predef$.MODULE$.Integer2int(Utils.getPort((String)address)));
                }
                throw new MatchError(tuple22);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BlockingChannel channelToAnyBroker(ZkClient zkClient, int socketTimeoutMs$1) {
        ObjectRef channel$1 = new ObjectRef(null);
        boolean connected = false;
        while (!connected) {
            Seq<Broker> allBrokers = ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient);
            ((IterableLike)Random$.MODULE$.shuffle(allBrokers, Seq$.MODULE$.canBuildFrom())).find((Function1)new Serializable(socketTimeoutMs$1, channel$1){
                public static final long serialVersionUID;
                private final int socketTimeoutMs$1;
                public final ObjectRef channel$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                public final boolean apply(Broker broker$1) {
                    void var2_2;
                    ClientUtils$.MODULE$.trace((Function0<String>)new Serializable(this, broker$1){
                        public static final long serialVersionUID;
                        private final Broker broker$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Connecting to broker %s:%d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.broker$1.host(), BoxesRunTime.boxToInteger((int)this.broker$1.port())}));
                        }
                        {
                            this.broker$1 = broker;
                        }
                    });
                    boolean exceptionResult1 = false;
                    try {
                        this.channel$1.elem = new BlockingChannel(broker$1.host(), broker$1.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), this.socketTimeoutMs$1);
                        ((BlockingChannel)this.channel$1.elem).connect();
                        ClientUtils$.MODULE$.debug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID;
                            private final anonfun.channelToAnyBroker.1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Created channel to broker %s:%d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)this.$outer.channel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)this.$outer.channel$1.elem).port())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        exceptionResult1 = true;
                    }
                    catch (Exception exception) {
                        if ((BlockingChannel)this.channel$1.elem != null) {
                            ((BlockingChannel)this.channel$1.elem).disconnect();
                        }
                        this.channel$1.elem = null;
                        ClientUtils$.MODULE$.info((Function0<String>)new Serializable(this, broker$1){
                            public static final long serialVersionUID;
                            private final Broker broker$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Error while creating channel to %s:%d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.broker$1.host(), BoxesRunTime.boxToInteger((int)this.broker$1.port())}));
                            }
                            {
                                this.broker$1 = broker;
                            }
                        });
                        exceptionResult1 = false;
                    }
                    return (boolean)var2_2;
                }
                {
                    this.socketTimeoutMs$1 = n;
                    this.channel$1 = objectRef;
                }
            });
            connected = (BlockingChannel)channel$1.elem != null;
        }
        return (BlockingChannel)channel$1.elem;
    }

    public int channelToAnyBroker$default$2() {
        return 3000;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlockingChannel channelToOffsetManager(String group$1, ZkClient zkClient, int socketTimeoutMs, int retryBackOffMs$1) {
        ObjectRef queryChannel$1 = new ObjectRef((Object)this.channelToAnyBroker(zkClient, this.channelToAnyBroker$default$2()));
        None$ offsetManagerChannelOpt = None$.MODULE$;
        block4: while (!offsetManagerChannelOpt.isDefined()) {
            Option<Broker> coordinatorOpt = None$.MODULE$;
            while (true) {
                if (coordinatorOpt.isDefined()) {
                    Broker coordinator = (Broker)coordinatorOpt.get();
                    String string = coordinator.host();
                    String string2 = ((BlockingChannel)queryChannel$1.elem).host();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && coordinator.port() == ((BlockingChannel)queryChannel$1.elem).port()) {
                        offsetManagerChannelOpt = new Some((Object)((BlockingChannel)queryChannel$1.elem));
                        continue block4;
                    }
                    String connectString$1 = Predef$.MODULE$.augmentString("%s:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{coordinator.host(), BoxesRunTime.boxToInteger((int)coordinator.port())}));
                    BlockingChannel offsetManagerChannel = null;
                    {
                        this.debug((Function0<String>)new Serializable(connectString$1){
                            public static final long serialVersionUID;
                            private final String connectString$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Connecting to offset manager %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectString$1}));
                            }
                            {
                                this.connectString$1 = string;
                            }
                        });
                        offsetManagerChannel = new BlockingChannel(coordinator.host(), coordinator.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), socketTimeoutMs);
                        offsetManagerChannel.connect();
                        offsetManagerChannelOpt = new Some((Object)offsetManagerChannel);
                        ((BlockingChannel)queryChannel$1.elem).disconnect();
                        continue block4;
                    }
                }
                try {
                    if (!((BlockingChannel)queryChannel$1.elem).isConnected()) {
                        queryChannel$1.elem = this.channelToAnyBroker(zkClient, this.channelToAnyBroker$default$2());
                    }
                    this.debug((Function0<String>)new Serializable(group$1, queryChannel$1){
                        public static final long serialVersionUID;
                        private final String group$1;
                        private final ObjectRef queryChannel$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Querying %s:%d to locate offset manager for %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)this.queryChannel$1.elem).port()), this.group$1}));
                        }
                        {
                            this.group$1 = string;
                            this.queryChannel$1 = objectRef;
                        }
                    });
                    ((BlockingChannel)queryChannel$1.elem).send(new ConsumerMetadataRequest(group$1, ConsumerMetadataRequest$.MODULE$.apply$default$2(), ConsumerMetadataRequest$.MODULE$.apply$default$3(), ConsumerMetadataRequest$.MODULE$.apply$default$4()));
                    Receive response = ((BlockingChannel)queryChannel$1.elem).receive();
                    ConsumerMetadataResponse consumerMetadataResponse$1 = ConsumerMetadataResponse$.MODULE$.readFrom(response.buffer());
                    this.debug((Function0<String>)new Serializable(consumerMetadataResponse$1){
                        public static final long serialVersionUID;
                        private final ConsumerMetadataResponse consumerMetadataResponse$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Consumer metadata response: ").append((Object)this.consumerMetadataResponse$1.toString()).toString();
                        }
                        {
                            this.consumerMetadataResponse$1 = consumerMetadataResponse;
                        }
                    });
                    if (consumerMetadataResponse$1.errorCode() == ErrorMapping$.MODULE$.NoError()) {
                        coordinatorOpt = consumerMetadataResponse$1.coordinatorOpt();
                        continue;
                    }
                    this.debug((Function0<String>)new Serializable(group$1, retryBackOffMs$1, queryChannel$1){
                        public static final long serialVersionUID;
                        private final String group$1;
                        private final int retryBackOffMs$1;
                        private final ObjectRef queryChannel$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Query to %s:%d to locate offset manager for %s failed - will retry in %d milliseconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)this.queryChannel$1.elem).port()), this.group$1, BoxesRunTime.boxToInteger((int)this.retryBackOffMs$1)}));
                        }
                        {
                            this.group$1 = string;
                            this.retryBackOffMs$1 = n;
                            this.queryChannel$1 = objectRef;
                        }
                    });
                    Thread.sleep(retryBackOffMs$1);
                    continue;
                }
                catch (IOException iOException) {
                    this.info((Function0<String>)new Serializable(queryChannel$1){
                        public static final long serialVersionUID;
                        private final ObjectRef queryChannel$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Failed to fetch consumer metadata from %s:%d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)this.queryChannel$1.elem).port())}));
                        }
                        {
                            this.queryChannel$1 = objectRef;
                        }
                    });
                    ((BlockingChannel)queryChannel$1.elem).disconnect();
                    continue;
                }
                break;
            }
            break;
        }
        return (BlockingChannel)offsetManagerChannelOpt.get();
    }

    public int channelToOffsetManager$default$4() {
        return 1000;
    }

    public int channelToOffsetManager$default$3() {
        return 3000;
    }

    private ClientUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

