/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005A!M]8lKJLE-F\u0001 !\t9\u0002%\u0003\u0002\"1\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\tI!A\u000b\u0002\u0003\u0013A\u000b'\u000f^5uS>t\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003\u0011!\u0018.\\3\u0011\u0005E\u0001\u0014BA\u0019\u0013\u0005\u0011!\u0016.\\3\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011q#N\u0005\u0003ma\u0011A\u0001T8oO\"A\u0001\b\u0001BC\u0002\u0013\u0005\u0011(A\u0002m_\u001e,\u0012A\u000f\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005\u0019y\u0005\u000f^5p]B\u0011a\bQ\u0007\u0002\u007f)\u0011\u0001\bB\u0005\u0003\u0003~\u00121\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u0013Q\u0014\u0001\u00027pO\u0002BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u0002)\u0001!)Q\u0004\u0012a\u0001?!)Q\u0005\u0012a\u0001O!9a\u0006\u0012I\u0001\u0002\u0004y\u0003bB\u001aE!\u0003\u0005\r\u0001\u000e\u0005\bq\u0011\u0003\n\u00111\u0001;\u0011\u0019q\u0005\u0001)Q\u0005\u001f\u0006)\u0002.[4i/\u0006$XM]7be.lU\r^1eCR\f\u0007C\u0001)T\u001b\u0005\t&B\u0001*\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011A+\u0015\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007FA'W!\t9r+\u0003\u0002Y1\tAao\u001c7bi&dW\r\u0003\u0004[\u0001\u0001\u0006KaT\u0001\u0015Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1)\u0005e3\u0006BB/\u0001A\u0003%a,A\u000fm_\u001e,e\u000eZ(gMN,G/\u00169eCR,G+[7f\u001bN4\u0016\r\\;f!\tyf-D\u0001a\u0015\t\t'-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003G\u0012\f!bY8oGV\u0014(/\u001a8u\u0015\t)G\"\u0001\u0003vi&d\u0017BA4a\u0005)\tEo\\7jG2{gn\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0003\u0015!x\u000e]5d+\u0005Y\u0007C\u00017p\u001d\t9R.\u0003\u0002o1\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tq\u0007\u0004\u0003\u0004t\u0001\u0001\u0006Ia[\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000fU\u0004!\u0019!C\u0001=\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u00199\b\u0001)A\u0005?\u0005a\u0001/\u0019:uSRLwN\\%eA!)\u0011\u0010\u0001C\u0001u\u00069\u0011n\u001d'pG\u0006dW#A>\u0011\u0005]a\u0018BA?\u0019\u0005\u001d\u0011un\u001c7fC:Daa \u0001\u0005\u0002\u0005\u0005\u0011\u0001\u00057pO\u0016sGm\u00144gg\u0016$x\fJ3r)\u0011\t\u0019!!\u0003\u0011\u0007]\t)!C\u0002\u0002\ba\u0011A!\u00168ji\"1\u00111\u0002@A\u0002=\u000bqB\\3x\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u001f\u0001A\u0011AA\t\u00031awnZ#oI>3gm]3u+\u0005y\u0005bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0019Y><WI\u001c3PM\u001a\u001cX\r^+qI\u0006$X\rV5nK6\u001bX#\u0001\u001b\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005\t\u0002.[4i/\u0006$XM]7be.|F%Z9\u0015\t\u0005\r\u0011q\u0004\u0005\b\u0003C\tI\u00021\u0001P\u0003AqWm\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eC\u0004\u0002&\u0001!\t!!\u0005\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\tadY8om\u0016\u0014H\u000fS,U_2{7-\u00197PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0005\u0005\r\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\f\u0019\u0004\u0003\u0005\u00026\u00055\u0002\u0019AA\u001c\u0003\u0011!\b.\u0019;\u0011\u0007]\tI$C\u0002\u0002<a\u00111!\u00118z\u0011\u001d\ty\u0004\u0001C!\u0003\u0003\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002?!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003-<\u0011\"a\u0013\u0003\u0003\u0003E)!!\u0014\u0002\u000fI+\u0007\u000f\\5dCB\u0019\u0001&a\u0014\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0003#\u001aB!a\u0014\t-!9Q)a\u0014\u0005\u0002\u0005UCCAA'\u0011)\tI&a\u0014\u0012\u0002\u0013\u0005\u00111L\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiFK\u00020\u0003?Z#!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WB\u0012AC1o]>$\u0018\r^5p]&!\u0011qNA3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003g\ny%%A\u0005\u0002\u0005U\u0014AD5oSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oR3\u0001NA0\u0011)\tY(a\u0014\u0012\u0002\u0013\u0005\u0011QP\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tyHK\u0002;\u0003?\u0002")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private final AtomicLong logEndOffsetUpdateTimeMsValue;
    private final String topic;
    private final int partitionId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Option init$default$5() {
        return Replica$.MODULE$.init$default$5();
    }

    public static final long init$default$4() {
        return Replica$.MODULE$.init$default$4();
    }

    public static final Time init$default$3() {
        return Replica$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Replica replica = this;
        synchronized (replica) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isLocal() {
        Option<Log> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.log();
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Should not set log end offset on partition [%s,%d]'s local replica %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.logEndOffsetUpdateTimeMsValue.set(this.time.milliseconds());
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final Replica $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public long logEndOffsetUpdateTimeMs() {
        return this.logEndOffsetUpdateTimeMsValue.get();
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark$1) {
        if (this.isLocal()) {
            this.highWatermarkMetadata = newHighWatermark$1;
            this.trace((Function0<String>)new Serializable(this, newHighWatermark$1){
                public static final long serialVersionUID;
                private final Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Setting high watermark for replica %d partition [%s,%d] on broker %d to [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = logOffsetMetadata;
                }
            });
            return;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Should not set high watermark on partition [%s,%d]'s non-local replica %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
            return;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Should not construct complete high watermark on partition [%s,%d]'s non-local replica %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica other = (Replica)that;
            return this.topic().equals(other.topic()) && this.brokerId() == other.brokerId() && this.partition().equals(other.partition());
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partition().partitionId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLocal())).toString());
        Object object = this.isLocal() ? replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append((Object)this.highWatermark()).toString()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.time = time;
        this.log = log;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.init$default$2(), LogOffsetMetadata$.MODULE$.init$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.logEndOffsetUpdateTimeMsValue = new AtomicLong(time.milliseconds());
        this.topic = partition.topic();
        this.partitionId = partition.partitionId();
    }
}

