/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.KafkaException;
import kafka.common.MessageSizeTooLargeException;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t/\u0011\u001aB\u0001A\u0005'SA\u0019!\"D\b\u000e\u0003-Q!\u0001\u0004\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00059Y!\u0001E%uKJ\fGo\u001c:UK6\u0004H.\u0019;f!\u0011\u00012#F\u0012\u000e\u0003EQ!A\u0005\u0003\u0002\u000f5,7o]1hK&\u0011A#\u0005\u0002\u0013\u001b\u0016\u001c8/Y4f\u0003:$W*\u001a;bI\u0006$\u0018\r\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!A&\u0012\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"a\u0002(pi\"Lgn\u001a\t\u00037\u0005J!A\t\u000f\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u0017I\u0011)Q\u0005\u0001b\u00013\t\ta\u000b\u0005\u0002\u000bO%\u0011\u0001f\u0003\u0002\b\u0019><w-\u001b8h!\tY\"&\u0003\u0002,9\tY1kY1mC>\u0013'.Z2u\u0011!i\u0003A!b\u0001\n\u0013q\u0013aB2iC:tW\r\\\u000b\u0002_A\u0019\u0001gN\u001d\u000e\u0003ER!AM\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u0019\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\tQ4(D\u0001\u0003\u0013\ta$A\u0001\tGKR\u001c\u0007.\u001a3ECR\f7\t[;oW\"Aa\b\u0001B\u0001B\u0003%q&\u0001\u0005dQ\u0006tg.\u001a7!\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0015!E2p]N,X.\u001a:US6,w.\u001e;NgB\u00111DQ\u0005\u0003\u0007r\u00111!\u00138u\u0011!)\u0005A!b\u0001\n\u00131\u0015AC6fs\u0012+7m\u001c3feV\tq\tE\u0002I\u0017Vi\u0011!\u0013\u0006\u0003\u0015\u0012\t!b]3sS\u0006d\u0017N_3s\u0013\ta\u0015JA\u0004EK\u000e|G-\u001a:\t\u00119\u0003!\u0011!Q\u0001\n\u001d\u000b1b[3z\t\u0016\u001cw\u000eZ3sA!A\u0001\u000b\u0001BC\u0002\u0013%\u0011+\u0001\u0007wC2,X\rR3d_\u0012,'/F\u0001S!\rA5j\t\u0005\t)\u0002\u0011\t\u0011)A\u0005%\u0006ia/\u00197vK\u0012+7m\u001c3fe\u0002B\u0001B\u0016\u0001\u0003\u0006\u0004%\taV\u0001\tG2LWM\u001c;JIV\t\u0001\f\u0005\u0002Z9:\u00111DW\u0005\u00037r\ta\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\b\u0005\tA\u0002\u0011\t\u0011)A\u00051\u0006I1\r\\5f]RLE\r\t\u0005\u0006E\u0002!\taY\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0011,gm\u001a5j!\u0011Q\u0004!F\u0012\t\u000b5\n\u0007\u0019A\u0018\t\u000b\u0001\u000b\u0007\u0019A!\t\u000b\u0015\u000b\u0007\u0019A$\t\u000bA\u000b\u0007\u0019\u0001*\t\u000bY\u000b\u0007\u0019\u0001-\t\u000f-\u0004\u0001\u0019!C\u0005Y\u000691-\u001e:sK:$X#A7\u0011\u00079\f8/D\u0001p\u0015\t\u0001\u0018'\u0001\u0004bi>l\u0017nY\u0005\u0003e>\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0004ir|hBA;{\u001d\t1\u00180D\u0001x\u0015\tAh!\u0001\u0004=e>|GOP\u0005\u0002;%\u00111\u0010H\u0001\ba\u0006\u001c7.Y4f\u0013\tihP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tYH\u0004E\u0002\u0011\u0003\u0003I1!a\u0001\u0012\u0005AiUm]:bO\u0016\fe\u000eZ(gMN,G\u000fC\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n\u0005Y1-\u001e:sK:$x\fJ3r)\u0011\tY!!\u0005\u0011\u0007m\ti!C\u0002\u0002\u0010q\u0011A!\u00168ji\"I\u00111CA\u0003\u0003\u0003\u0005\r!\\\u0001\u0004q\u0012\n\u0004bBA\f\u0001\u0001\u0006K!\\\u0001\tGV\u0014(/\u001a8uA!I\u00111\u0004\u0001A\u0002\u0013%\u0011QD\u0001\u0011GV\u0014(/\u001a8u)>\u0004\u0018nY%oM>,\"!a\b\u0011\u0007i\n\t#C\u0002\u0002$\t\u0011!\u0003U1si&$\u0018n\u001c8U_BL7-\u00138g_\"I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011F\u0001\u0015GV\u0014(/\u001a8u)>\u0004\u0018nY%oM>|F%Z9\u0015\t\u0005-\u00111\u0006\u0005\u000b\u0003'\t)#!AA\u0002\u0005}\u0001\u0002CA\u0018\u0001\u0001\u0006K!a\b\u0002#\r,(O]3oiR{\u0007/[2J]\u001a|\u0007\u0005C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026\u0005q1m\u001c8tk6,Gm\u00144gg\u0016$XCAA\u001c!\rY\u0012\u0011H\u0005\u0004\u0003wa\"\u0001\u0002'p]\u001eD\u0011\"a\u0010\u0001\u0001\u0004%I!!\u0011\u0002%\r|gn];nK\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003\u0017\t\u0019\u0005\u0003\u0006\u0002\u0014\u0005u\u0012\u0011!a\u0001\u0003oA\u0001\"a\u0012\u0001A\u0003&\u0011qG\u0001\u0010G>t7/^7fI>3gm]3uA!I\u00111\n\u0001C\u0002\u0013%\u0011QJ\u0001\u0013G>t7/^7feR{\u0007/[2Ti\u0006$8/\u0006\u0002\u0002PA\u0019!(!\u0015\n\u0007\u0005M#A\u0001\nD_:\u001cX/\\3s)>\u0004\u0018nY*uCR\u001c\b\u0002CA,\u0001\u0001\u0006I!a\u0014\u0002'\r|gn];nKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005!a.\u001a=u)\u0005y\u0001bBA1\u0001\u0011E\u0011QL\u0001\t[\u0006\\WMT3yi\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014!E2mK\u0006\u00148)\u001e:sK:$8\t[;oWR\u0011\u00111\u0002")
public class ConsumerIterator<K, V>
extends IteratorTemplate<MessageAndMetadata<K, V>>
implements Logging,
ScalaObject {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final String clientId;
    private AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    private Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public String clientId() {
        return this.clientId;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private void current_$eq(AtomicReference<Iterator<MessageAndOffset>> atomicReference) {
        this.current = atomicReference;
    }

    public final PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo partitionTopicInfo) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = partitionTopicInfo;
    }

    public final long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long l) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = l;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<K, V> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)new Serializable(this, topic$1){
            public static final long serialVersionUID;
            private final ConsumerIterator $outer;
            private final String topic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Setting %s consumed offset to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$ConsumerIterator$$consumedOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = consumerIterator;
            }
        });
        this.consumerTopicStats().getConsumerTopicStats(topic$1).messageRate().mark();
        this.consumerTopicStats().getConsumerAllTopicStats().messageRate().mark();
        return var1_1;
    }

    @Override
    public MessageAndMetadata<K, V> makeNext() {
        FetchedDataChunk currentDataChunk = null;
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk = this.channel().take();
            } else {
                currentDataChunk = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if (currentDataChunk == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if (currentDataChunk == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Received the shutdown command";
                    }
                });
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(currentDataChunk.topicInfo());
            long cdcFetchOffset$1 = currentDataChunk.fetchOffset();
            long ctiConsumeOffset$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset();
            if (ctiConsumeOffset$1 < cdcFetchOffset$1) {
                this.error((Function0<String>)new Serializable(this, cdcFetchOffset$1, ctiConsumeOffset$1){
                    public static final long serialVersionUID;
                    private final ConsumerIterator $outer;
                    private final long cdcFetchOffset$1;
                    private final long ctiConsumeOffset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.ctiConsumeOffset$1), BoxesRunTime.boxToLong((long)this.cdcFetchOffset$1), this.$outer.kafka$consumer$ConsumerIterator$$currentTopicInfo()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cdcFetchOffset$1 = l;
                        this.ctiConsumeOffset$1 = l2;
                    }
                });
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(cdcFetchOffset$1);
            }
            localCurrent = currentDataChunk.messages().iterator();
            this.current().set(localCurrent);
            if (currentDataChunk.messages().validBytes() == 0) {
                throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"Found a message larger than the maximum fetch size of this consumer on topic ").append((Object)Predef$.MODULE$.augmentString("%s partition %d at fetch offset %d. Increase the fetch size, or decrease the maximum message size the broker will allow.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentDataChunk.topicInfo().topic(), BoxesRunTime.boxToInteger((int)currentDataChunk.topicInfo().partitionId()), BoxesRunTime.boxToLong((long)currentDataChunk.fetchOffset())}))).toString());
            }
        }
        MessageAndOffset item = (MessageAndOffset)localCurrent.next();
        while (item.offset() < this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() && localCurrent.hasNext()) {
            item = (MessageAndOffset)localCurrent.next();
        }
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.nextOffset());
        item.message().ensureValid();
        return new MessageAndMetadata<K, V>(this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic(), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().partitionId(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder());
    }

    public void clearCurrentChunk() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Clearing the current data chunk for this consumer iterator";
            }
        });
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<K> keyDecoder, Decoder<V> valueDecoder, String clientId) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

