/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t!Y\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tQ!\u001e;jYNL!!\u0006\n\u0003\u000f1{wmZ5oOB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011!\u0019\u0001A!A!\u0002\u0013i\u0002C\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u00021%t\u0017\u000e^5bYR{\u0007/[2t)>\u0014U\rR3mKR,G\rE\u0002%O%j\u0011!\n\u0006\u0003Ma\t!bY8mY\u0016\u001cG/[8o\u0013\tASEA\u0002TKR\u0004\"AK\u0017\u000f\u0005]Y\u0013B\u0001\u0017\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051B\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002E%t\u0017\u000e^5bYR{\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q!QGN\u001c9!\tq\u0002\u0001C\u0003\u0004e\u0001\u0007Q\u0004C\u0004#eA\u0005\t\u0019A\u0012\t\u000fE\u0012\u0004\u0013!a\u0001G!9!\b\u0001b\u0001\n\u0003Y\u0014!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\tA\b\u0005\u0002\u001f{%\u0011aH\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bB\u0002!\u0001A\u0003%A(\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003b\u0002\"\u0001\u0005\u0004%\taQ\u0001\u0016a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\u0005!\u0005C\u0001\u0010F\u0013\t1%AA\u000bQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\t\r!\u0003\u0001\u0015!\u0003E\u0003Y\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\u0003b\u0002&\u0001\u0005\u0004%\taS\u0001\u0014e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.Z\u000b\u0002\u0019B\u0011a$T\u0005\u0003\u001d\n\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016Da\u0001\u0015\u0001!\u0002\u0013a\u0015\u0001\u0006:fa2L7-Y*uCR,W*Y2iS:,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002#Q|\u0007/[2t)>\u0014U\rR3mKR,G-F\u0001U!\r)\u0006,K\u0007\u0002-*\u0011q+J\u0001\b[V$\u0018M\u00197f\u0013\tAc\u000b\u0003\u0004[\u0001\u0001\u0006I\u0001V\u0001\u0013i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0004]\u0001\t\u0007I\u0011A/\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIV\ta\fE\u0002V1~\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0003\u0002\r\r|W.\\8o\u0013\t!\u0017MA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DaA\u001a\u0001!\u0002\u0013q\u0016A\u00069beRLG/[8ogR{')\u001a#fY\u0016$X\r\u001a\u0011\t\u000f!\u0004!\u0019!C\u0001S\u0006QA-\u001a7fi\u0016dunY6\u0016\u0003)\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u000b1|7m[:\u000b\u0005=\u0004\u0018AC2p]\u000e,(O]3oi*\u0011\u0011\u000fD\u0001\u0005kRLG.\u0003\u0002tY\ni!+Z3oiJ\fg\u000e\u001e'pG.Da!\u001e\u0001!\u0002\u0013Q\u0017a\u00033fY\u0016$X\rT8dW\u0002Bqa\u001e\u0001C\u0002\u0013\u00051+A\u000eu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0007s\u0002\u0001\u000b\u0011\u0002+\u00029Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8oA!91\u0010\u0001b\u0001\n\u0003a\u0018\u0001\u00053fY\u0016$X\rV8qS\u000e\u001c8i\u001c8e+\u0005i\bCA6\u007f\u0013\tyHNA\u0005D_:$\u0017\u000e^5p]\"9\u00111\u0001\u0001!\u0002\u0013i\u0018!\u00053fY\u0016$X\rV8qS\u000e\u001c8i\u001c8eA!I\u0011q\u0001\u0001C\u0002\u0013\u0005\u0011\u0011B\u0001\u0018I\u0016dW\r^3U_BL7m\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005o\u0003\u0019\tGo\\7jG&!\u0011QCA\b\u00055\tEo\\7jG\n{w\u000e\\3b]\"A\u0011\u0011\u0004\u0001!\u0002\u0013\tY!\u0001\reK2,G/\u001a+pa&\u001c7\u000b^1uK\u000eC\u0017M\\4fI\u0002B\u0011\"!\b\u0001\u0001\u0004%\t!a\b\u0002%\u0011,G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\rZ\u000b\u0003\u0003C\u0001B!a\t\u0002&5\t\u0001A\u0002\u0004\u0002(\u0001\u0001\u0011\u0011\u0006\u0002\u0013\t\u0016dW\r^3U_BL7m\u001d+ie\u0016\fGmE\u0003\u0002&\u0005-b\u0003E\u0002\u0012\u0003[I1!a\f\u0013\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u000fM\n)\u0003\"\u0001\u00024Q\u0011\u0011\u0011\u0005\u0005\u000b\u0003o\t)C1A\u0005\u0002\u0005e\u0012\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0017j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\tu.\u001cG.[3oi*!\u0011QIA$\u0003\u0019I\u0005'\u0013;fG*\u0011\u0011\u0011J\u0001\u0004_J<\u0017\u0002BA'\u0003\u007f\u0011\u0001BW6DY&,g\u000e\u001e\u0005\n\u0003#\n)\u0003)A\u0005\u0003w\t\u0011B_6DY&,g\u000e\u001e\u0011\t\u0011\u0005U\u0013Q\u0005C!\u0003/\na\u0001Z8X_J\\GCAA-!\r9\u00121L\u0005\u0004\u0003;B\"\u0001B+oSRD\u0011\"!\u0019\u0001\u0001\u0004%\t!a\u0019\u0002-\u0011,G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\rZ0%KF$B!!\u0017\u0002f!Q\u0011qMA0\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002l\u0001\u0001\u000b\u0015BA\u0011\u0003M!W\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193!\u0011%\ty\u0007\u0001b\u0001\n\u0003\t\t(\u0001\u000bjg\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\rZ\u000b\u0003\u0003g\u00022aFA;\u0013\r\t9\b\u0007\u0002\b\u0005>|G.Z1o\u0011!\tY\b\u0001Q\u0001\n\u0005M\u0014!F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G\r\t\u0005\b\u0003\u007f\u0002A\u0011AA,\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t\u0019\t\u0001C\u0001\u0003/\n\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003a)g.];fk\u0016$v\u000e]5dg\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u00033\nY\tC\u0004\u0002\u000e\u0006\u0015\u0005\u0019A\u0012\u0002\rQ|\u0007/[2t\u0011\u001d\t\t\n\u0001C\u0001\u0003'\u000bqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\t\u0005e\u0013Q\u0013\u0005\n\u0003\u001b\u000by\t%AA\u0002\rBq!!'\u0001\t\u0003\tY*A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000e\u0006\u0003\u0002Z\u0005u\u0005\u0002CAP\u0003/\u0003\r!!)\u0002\u0011I,\u0007\u000f\\5dCN\u0004B\u0001J\u0014\u0002$B\u0019a$!*\n\u0007\u0005\u001d&AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0004\u0002,\u0002!\t!!,\u0002=5\f'o\u001b+pa&\u001c\u0017J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BA-\u0003_Cq!!$\u0002*\u0002\u00071\u0005C\u0004\u00024\u0002!\t!!.\u00029%\u001cHk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R!\u00111OA\\\u0011\u001d\tI,!-A\u0002%\nQ\u0001^8qS\u000eDq!!0\u0001\t\u0003\ty,A\rjgR{\u0007/[2EK2,G/[8o\u0013:\u0004&o\\4sKN\u001cH\u0003BA:\u0003\u0003Dq!!/\u0002<\u0002\u0007\u0011\u0006C\u0004\u0002F\u0002!\t!a2\u0002-%\u001c\b+\u0019:uSRLwN\u001c+p\u0005\u0016$U\r\\3uK\u0012$B!a\u001d\u0002J\"9\u00111ZAb\u0001\u0004y\u0016!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0017AG5t)>\u0004\u0018nY)vKV,G-\u00169G_J$U\r\\3uS>tG\u0003BA:\u0003'Dq!!/\u0002N\u0002\u0007\u0011\u0006C\u0004\u0002X\u0002!I!a\u0016\u0002=\u0005<\u0018-\u001b;U_BL7\rR3mKRLwN\u001c(pi&4\u0017nY1uS>t\u0007bBAn\u0001\u0011%\u0011qK\u0001\u001ae\u0016\u001cX/\\3U_BL7\rR3mKRLwN\u001c+ie\u0016\fG\rC\u0004\u0002`\u0002!I!!9\u0002/\r|W\u000e\u001d7fi\u0016\u0014V\r\u001d7jG\u0006$U\r\\3uS>tG\u0003BA-\u0003GD\u0001\"a(\u0002^\u0002\u0007\u0011\u0011\u0015\u0005\b\u0003O\u0004A\u0011BAu\u0003iI7\u000fV8qS\u000e,E.[4jE2,gi\u001c:EK2,G/[8o)\u0011\t\u0019(a;\t\u000f\u0005e\u0016Q\u001da\u0001S!9\u0011q\u001e\u0001\u0005\n\u0005E\u0018!G7be.$v\u000e]5d\r>\u0014H)\u001a7fi&|gNU3uef$B!!\u0017\u0002t\"9\u0011\u0011XAw\u0001\u0004I\u0003bBA|\u0001\u0011%\u0011\u0011`\u0001\u0014G>l\u0007\u000f\\3uK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0005\u00033\nY\u0010C\u0004\u0002:\u0006U\b\u0019A\u0015\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u0005yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000e\u0006\u0003\u0002Z\t\r\u0001bBAG\u0003{\u0004\ra\t\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0003Q\u0019H/\u0019:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]R!\u0011\u0011\fB\u0006\u0011!\u0011iA!\u0002A\u0002\u0005\u0005\u0016\u0001\b:fa2L7-Y:G_J$v\u000e]5dgR{')\u001a#fY\u0016$X\r\u001a\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0003Myg\u000eU1si&$\u0018n\u001c8EK2,G/[8o)\u0011\tIF!\u0006\t\u000fq\u0013y\u00011\u0001\u0003\u0018A\u0019AeJ0\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e\u0005qB-\u001a7fi\u0016$v\u000e]5d'R|\u0007OU3qY&\u001c\u0017mQ1mY\n\f7m\u001b\u000b\u0007\u00033\u0012yBa\f\t\u0011\t\u0005\"\u0011\u0004a\u0001\u0005G\tac\u001d;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016|%M\u001b\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()\u0019!\u0011\u0006\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003.\t\u001d\"!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\"A!\u0011\u0007B\r\u0001\u0004\u0011\u0019$A\u0005sKBd\u0017nY1JIB\u0019qC!\u000e\n\u0007\t]\u0002DA\u0002J]RD\u0011Ba\u000f\u0001#\u0003%\tA!\u0010\u0002CI,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t}\"fA\u0012\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GMC\u0002\u0003Na\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u0003V\t\t\t\u0011#\u0002\u0003X\u0005!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u00042A\bB-\r!\t!!!A\t\u0006\tm3\u0003\u0002B-\u0011YAqa\rB-\t\u0003\u0011y\u0006\u0006\u0002\u0003X!Q!1\rB-#\u0003%\tA!\u0010\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%e!Q!q\rB-#\u0003%\tA!\u0010\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final ReentrantLock deleteLock;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final boolean isDeleteTopicEnabled;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Set init$default$3() {
        return TopicDeletionManager$.MODULE$.init$default$3();
    }

    public static final Set init$default$2() {
        return TopicDeletionManager$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread deleteTopicsThread) {
        this.deleteTopicsThread = deleteTopicsThread;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void start() {
        if (this.isDeleteTopicEnabled()) {
            this.deleteTopicsThread_$eq(new DeleteTopicsThread(this));
            if (this.topicsToBeDeleted().size() > 0) {
                this.deleteTopicStateChanged().set(true);
            }
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        if (this.isDeleteTopicEnabled() && this.deleteTopicsThread().initiateShutdown()) {
            this.resumeTopicDeletionThread();
            this.deleteTopicsThread().awaitShutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final TopicDeletionManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Set<TopicAndPartition> apply(String string) {
                    return this.$outer.controllerContext().partitionsForTopic(string);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete$1;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete$1 = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).size() > 0) {
            Set topics$1 = (Set)replicasThatFailedToDelete$1.map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(PartitionAndReplica partitionAndReplica) {
                    return partitionAndReplica.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete$1, topics$1){
                public static final long serialVersionUID;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = set;
                    this.topics$1 = set2;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete$1, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics$1);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion$1 = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion$1);
            if (newTopicsToHaltDeletion$1.size() > 0) {
                this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion$1){
                    public static final long serialVersionUID;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Halted deletion of topics %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = set;
                    }
                });
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return this.isDeleteTopicEnabled() ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public final void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        Utils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.$outer.deleteTopicsThread().isRunning().get() && !this.$outer.deleteTopicStateChanged().compareAndSet(true, false)) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Waiting for signal to start or continue topic deletion";
                        }
                    });
                    this.$outer.deleteTopicsCond().await();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        Utils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.deleteTopicsCond().signal();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas$1 = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas$1){
            public static final long serialVersionUID;
            private final Set successfullyDeletedReplicas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = set;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas$1, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public final boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public final void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic$1) {
        Set<PartitionAndReplica> failedReplicas$1 = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$1, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic$1, failedReplicas$1){
            public static final long serialVersionUID;
            private final String topic$1;
            private final Set failedReplicas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = string;
                this.failedReplicas$1 = set;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas$1, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public final void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic$2) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic$2);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$2, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic$2);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic$2);
        this.partitionsToBeDeleted().retain((Function1)new Serializable(this, topic$2){
            public static final long serialVersionUID;
            private final String topic$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(TopicAndPartition topicAndPartition) {
                String string = topicAndPartition.topic();
                String string2 = this.topic$2;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.topic$2 = string;
            }
        });
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic$2));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicConfigPath(topic$2));
        this.controllerContext().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic$2));
        this.controllerContext().removeTopic(topic$2);
    }

    public final void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics$2) {
        this.info((Function0<String>)new Serializable(this, topics$2){
            public static final long serialVersionUID;
            private final Set topics$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Topic deletion callback for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = set;
            }
        });
        Set partitions = (Set)topics$2.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Set<TopicAndPartition> apply(String string) {
                return this.$outer.controllerContext().partitionsForTopic(string);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic$1 = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return ((TopicAndPartition)p._1()).topic();
            }
        });
        topics$2.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicAndPartition>)((TraversableOnce)((TraversableLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return (TopicAndPartition)tuple2._1();
                    }
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = map;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted$1) {
        replicasForTopicsToBeDeleted$1.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(PartitionAndReplica partitionAndReplica) {
                return partitionAndReplica.topic();
            }
        }).foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Set<PartitionAndReplica>> tuple2) {
                Tuple2<String, Set<PartitionAndReplica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string;
                    String topic$3 = string = (String)tuple22._1();
                    Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic$3){
                        public static final long serialVersionUID;
                        private final String topic$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(PartitionAndReplica p) {
                            return p.topic().equals(this.topic$3);
                        }
                        {
                            this.topic$3 = string;
                        }
                    });
                    Set deadReplicasForTopic$1 = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$3, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry$1 = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic$1, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry$1, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry$1){
                        public static final long serialVersionUID;
                        private final Set replicasForDeletionRetry$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Deletion started for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                        }
                        {
                            this.replicasForDeletionRetry$1 = set;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry$1, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<RequestOrResponse, Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$startReplicaDeletion$2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(RequestOrResponse requestOrResponse, int n) {
                            this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(requestOrResponse, n);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).build());
                    if (deadReplicasForTopic$1.size() > 0) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topic$3, deadReplicasForTopic$1){
                            public static final long serialVersionUID;
                            private final String topic$3;
                            private final Set deadReplicasForTopic$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                            }
                            {
                                this.topic$3 = string;
                                this.deadReplicasForTopic$1 = set;
                            }
                        });
                        this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$3}))));
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }

            public TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = set;
            }
        });
    }

    public final void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted$1) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted$1){
            public static final long serialVersionUID;
            private final Set partitionsToBeDeleted$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Partition deletion callback for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = set;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted$1);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public final void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(RequestOrResponse stopReplicaResponseObj, int replicaId$1) {
        StopReplicaResponse stopReplicaResponse$1 = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)new Serializable(this, stopReplicaResponse$1){
            public static final long serialVersionUID;
            private final StopReplicaResponse stopReplicaResponse$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Delete topic callback invoked for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse;
            }
        });
        scala.collection.immutable.Set partitionsInError$1 = stopReplicaResponse$1.errorCode() != ErrorMapping$.MODULE$.NoError() ? stopReplicaResponse$1.responseMap().keySet() : ((TraversableOnce)((TraversableLike)stopReplicaResponse$1.responseMap().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Object> p) {
                return BoxesRunTime.unboxToShort((Object)p._2()) != ErrorMapping$.MODULE$.NoError();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> tuple2) {
                return (TopicAndPartition)tuple2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set replicasInError$1 = (scala.collection.immutable.Set)partitionsInError$1.map((Function1)new Serializable(this, replicaId$1){
            public static final long serialVersionUID;
            private final int replicaId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final PartitionAndReplica apply(TopicAndPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = n;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId$1, stopReplicaResponse$1, partitionsInError$1, replicasInError$1){
            public static final long serialVersionUID;
            private final TopicDeletionManager $outer;
            public final int replicaId$1;
            private final StopReplicaResponse stopReplicaResponse$1;
            private final scala.collection.immutable.Set partitionsInError$1;
            private final scala.collection.immutable.Set replicasInError$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion((Set<PartitionAndReplica>)this.replicasInError$1);
                if (this.replicasInError$1.size() != this.stopReplicaResponse$1.responseMap().size()) {
                    scala.collection.immutable.Set deletedReplicas = (scala.collection.immutable.Set)this.stopReplicaResponse$1.responseMap().keySet().$minus$minus((GenTraversableOnce)this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final PartitionAndReplica apply(TopicAndPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = n;
                this.stopReplicaResponse$1 = stopReplicaResponse;
                this.partitionsInError$1 = set;
                this.replicasInError$1 = set2;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Topic Deletion Manager ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"], ").toString());
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.partitionsToBeDeleted = (scala.collection.mutable.Set)this.topicsToBeDeleted().flatMap((Function1)new $anonfun$1(this), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        this.deleteLock = new ReentrantLock();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
    }

    public class DeleteTopicsThread
    extends ShutdownableThread
    implements ScalaObject {
        private final ZkClient zkClient;
        public final TopicDeletionManager $outer;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            if (this.isRunning().get()) {
                Utils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final DeleteTopicsThread $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Set topicsQueuedForDeletion$1 = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                        if (!topicsQueuedForDeletion$1.isEmpty()) {
                            this.$outer.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion$1){
                                public static final long serialVersionUID;
                                private final Set topicsQueuedForDeletion$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                                }
                                {
                                    this.topicsQueuedForDeletion$1 = set;
                                }
                            });
                        }
                        topicsQueuedForDeletion$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final DeleteTopicsThread$$anonfun$doWork$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(String topic$4) {
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic$4)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic$4);
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$4){
                                        public static final long serialVersionUID;
                                        private final String topic$4;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = string;
                                        }
                                    });
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic$4)) {
                                    Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic$4, ReplicaDeletionStarted$.MODULE$);
                                    Set replicaIds$1 = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(PartitionAndReplica partitionAndReplica) {
                                            return partitionAndReplica.replica();
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    Set partitions$1 = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final TopicAndPartition apply(PartitionAndReplica r) {
                                            return new TopicAndPartition(r.topic(), r.partition());
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$4, replicaIds$1, partitions$1){
                                        public static final long serialVersionUID;
                                        private final String topic$4;
                                        private final Set replicaIds$1;
                                        private final Set partitions$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = string;
                                            this.replicaIds$1 = set;
                                            this.partitions$1 = set2;
                                        }
                                    });
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic$4, ReplicaDeletionIneligible$.MODULE$)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic$4);
                                }
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic$4)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$4){
                                        public static final long serialVersionUID;
                                        private final String topic$4;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Deletion of topic %s (re)started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = string;
                                        }
                                    });
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$4}))));
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic$4)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic$4){
                                        public static final long serialVersionUID;
                                        private final String topic$4;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = string;
                                        }
                                    });
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
        }

        public TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return this.$outer;
        }

        public DeleteTopicsThread(TopicDeletionManager $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder().append((Object)"delete-topics-thread-").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$TopicDeletionManager$$controller.config().brokerId())).toString(), false);
            this.zkClient = $outer.controllerContext().zkClient();
        }
    }
}

