/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%g!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0003\u0002\u0001\b\u001fU\u0001\"\u0001C\u0007\u000e\u0003%Q!AC\u0006\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0005!!.\u0019<b\u0013\tq\u0011B\u0001\u0004PE*,7\r\u001e\t\u0003!Mi\u0011!\u0005\u0006\u0003%\u0011\tQ!\u001e;jYNL!\u0001F\t\u0003\u000f1{wmZ5oOB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\tY1kY1mC>\u0013'.Z2u\u0011!a\u0002A!b\u0001\n\u0003q\u0012AA5e\u0007\u0001)\u0012a\b\t\u0003-\u0001J!!I\f\u0003\u0007%sG\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u0003\rIG\r\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005IqN\u001a4tKRl\u0015\r]\u000b\u0002OA\u0011\u0001&K\u0007\u0002\u0005%\u0011!F\u0001\u0002\n\u001f\u001a47/\u001a;NCBD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u000b_\u001a47/\u001a;NCB\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0019%|')\u001e4gKJ\u001c\u0016N_3\t\u0011A\u0002!\u0011!Q\u0001\n}\tq\"\\1y\u0013>\u0014UO\u001a4feNK'0\u001a\u0005\te\u0001\u0011\t\u0011)A\u0005g\u0005\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011a\u0003N\u0005\u0003k]\u0011a\u0001R8vE2,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0013QD'o\u001c;uY\u0016\u0014\bC\u0001\t:\u0013\tQ\u0014CA\u0005UQJ|G\u000f\u001e7fe\"AA\b\u0001B\u0001B\u0003%Q(\u0001\u0003uS6,\u0007C\u0001\t?\u0013\ty\u0014C\u0001\u0003US6,\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u0013\rDWmY6E_:,\u0007\u0003\u0002\fD\u000b.K!\u0001R\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001$J\u001b\u00059%B\u0001%\u0005\u0003\u0019\u0019w.\\7p]&\u0011!j\u0012\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fM\u0013\tiuC\u0001\u0003V]&$\b\"B(\u0001\t\u0003\u0001\u0016A\u0002\u001fj]&$h\bF\u0005R%N#VKV,Y3B\u0011\u0001\u0006\u0001\u0005\u000699\u0003\ra\b\u0005\u0006K9\u0003\ra\n\u0005\u0006]9\u0003\ra\b\u0005\u0006a9\u0003\ra\b\u0005\u0006e9\u0003\ra\r\u0005\u0006o9\u0003\r\u0001\u000f\u0005\u0006y9\u0003\r!\u0010\u0005\u0006\u0003:\u0003\rA\u0011\u0005\b7\u0002\u0011\r\u0011\"\u0011]\u0003)awnZ4fe:\u000bW.Z\u000b\u0002;B\u0011\u0001BX\u0005\u0003?&\u0011aa\u0015;sS:<\u0007BB1\u0001A\u0003%Q,A\u0006m_\u001e<WM\u001d(b[\u0016\u0004\u0003bB2\u0001\u0005\u0004%\t\u0001Z\u0001\u0010gR\fGo]+oI\u0016\u0014H._5oOV\tQ\r\u0005\u0003\u0017M\"D\u0017BA4\u0018\u0005\u0019!V\u000f\u001d7feA\u0011\u0001&[\u0005\u0003U\n\u0011Ab\u00117fC:,'o\u0015;biNDa\u0001\u001c\u0001!\u0002\u0013)\u0017\u0001E:uCR\u001cXK\u001c3fe2L\u0018N\\4!\u0011\u0015q\u0007\u0001\"\u0001p\u0003\u0015\u0019H/\u0019;t+\u0005A\u0007bB9\u0001\u0001\u0004%IA]\u0001\u000be\u0016\fGMQ;gM\u0016\u0014X#A:\u0011\u0005Q<X\"A;\u000b\u0005Y\\\u0011a\u00018j_&\u0011\u00010\u001e\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bb\u0002>\u0001\u0001\u0004%Ia_\u0001\u000fe\u0016\fGMQ;gM\u0016\u0014x\fJ3r)\tYE\u0010C\u0004~s\u0006\u0005\t\u0019A:\u0002\u0007a$\u0013\u0007\u0003\u0004\u0000\u0001\u0001\u0006Ka]\u0001\fe\u0016\fGMQ;gM\u0016\u0014\b\u0005\u0003\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003s\u0003-9(/\u001b;f\u0005V4g-\u001a:\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0011aD<sSR,')\u001e4gKJ|F%Z9\u0015\u0007-\u000bY\u0001\u0003\u0005~\u0003\u000b\t\t\u00111\u0001t\u0011\u001d\ty\u0001\u0001Q!\nM\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002B\u0001\"a\u0005\u0001\t\u0003\u0011\u0011QC\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003/\ti\u0002E\u0002\u0017\u00033I1!a\u0007\u0018\u0005\u0011auN\\4\t\u0011\u0005}\u0011\u0011\u0003a\u0001\u0003C\t\u0011b\u00197fC:\f'\r\\3\u0011\u0007!\n\u0019#C\u0002\u0002&\t\u0011!\u0002T8h)>\u001cE.Z1o\u0011!\tI\u0003\u0001C\u0001\u0005\u0005-\u0012!D2mK\u0006t7+Z4nK:$8\u000fF\u0005L\u0003[\t)$a\u0013\u0002P!91!a\nA\u0002\u0005=\u0002c\u0001\u0015\u00022%\u0019\u00111\u0007\u0002\u0003\u00071{w\r\u0003\u0005\u00028\u0005\u001d\u0002\u0019AA\u001d\u0003!\u0019XmZ7f]R\u001c\bCBA\u001e\u0003\u0003\n)%\u0004\u0002\u0002>)\u0019\u0011qH\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002D\u0005u\"aA*fcB\u0019\u0001&a\u0012\n\u0007\u0005%#A\u0001\u0006M_\u001e\u001cVmZ7f]RDq!!\u0014\u0002(\u0001\u0007q%A\u0002nCBD\u0001\"!\u0015\u0002(\u0001\u0007\u0011qC\u0001\u0010I\u0016dW\r^3I_JL'p\u001c8Ng\"A\u0011Q\u000b\u0001\u0005\u0002\t\t9&A\u0005dY\u0016\fg.\u00138u_RY1*!\u0017\u0002^\u0005\u0005\u0014QMA4\u0011\u001d\tY&a\u0015A\u0002\u0015\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\ty&a\u0015A\u0002\u0005\u0015\u0013AB:pkJ\u001cW\r\u0003\u0005\u0002d\u0005M\u0003\u0019AA#\u0003\u0011!Wm\u001d;\t\u000f\u00055\u00131\u000ba\u0001O!A\u0011\u0011NA*\u0001\u0004\tY'A\u0007sKR\f\u0017N\u001c#fY\u0016$Xm\u001d\t\u0004-\u00055\u0014bAA8/\t9!i\\8mK\u0006t\u0007bBA:\u0001\u0011\u0005\u0011QO\u0001\fOJ|wOQ;gM\u0016\u00148\u000fF\u0001L\u0011\u001d\tI\b\u0001C\u0001\u0003k\naB]3ti>\u0014XMQ;gM\u0016\u00148\u000f\u0003\u0005\u0002~\u0001!\tAAA@\u0003M9'o\\;q'\u0016<W.\u001a8ug\nK8+\u001b>f)!\t\t)!'\u0002\"\u0006\u0015\u0006CBAB\u0003'\u000bID\u0004\u0003\u0002\u0006\u0006=e\u0002BAD\u0003\u001bk!!!#\u000b\u0007\u0005-U$\u0001\u0004=e>|GOP\u0005\u00021%\u0019\u0011\u0011S\f\u0002\u000fA\f7m[1hK&!\u0011QSAL\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005Eu\u0003\u0003\u0005\u00028\u0005m\u0004\u0019AAN!\u0019\tY$!(\u0002F%!\u0011qTA\u001f\u0005!IE/\u001a:bE2,\u0007bBAR\u0003w\u0002\raH\u0001\b[\u0006D8+\u001b>f\u0011\u001d\t9+a\u001fA\u0002}\tA\"\\1y\u0013:$W\r_*ju\u0016D\u0001\"a+\u0001\t\u0003\u0011\u0011QV\u0001\u000fEVLG\u000eZ(gMN,G/T1q))\t9\"a,\u00022\u0006U\u0016\u0011\u0018\u0005\b\u0007\u0005%\u0006\u0019AA\u0018\u0011!\t\u0019,!+A\u0002\u0005]\u0011!B:uCJ$\b\u0002CA\\\u0003S\u0003\r!a\u0006\u0002\u0007\u0015tG\rC\u0004\u0002N\u0005%\u0006\u0019A\u0014\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u0006A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015\u0011\u0005]\u0011\u0011YAb\u0003\u000fDq!a\u0017\u0002<\u0002\u0007Q\t\u0003\u0005\u0002F\u0006m\u0006\u0019AA#\u0003\u001d\u0019XmZ7f]RDq!!\u0014\u0002<\u0002\u0007q\u0005")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return (CleanerStats)this.statsUnderlying()._1();
    }

    public final ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$readBuffer = byteBuffer;
    }

    public final ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$writeBuffer = byteBuffer;
    }

    public long clean(LogToClean cleanable$1) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log$2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new Serializable(this, cleanable$1){
                        public static final long serialVersionUID;
                        private final LogToClean cleanable$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Beginning cleaning of log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = logToClean;
                        }
                    });
                    log$2 = cleanable$1.log();
                    this.info((Function0<String>)new Serializable(this, cleanable$1){
                        public static final long serialVersionUID;
                        private final LogToClean cleanable$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Building offset map for %s...").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = logToClean;
                        }
                    });
                    long upperBoundOffset = log$2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log$2, cleanable$1.firstDirtyOffset(), upperBoundOffset, this.offsetMap()) + 1L;
                    this.stats().indexDone();
                    option = log$2.logSegments(0L, cleanable$1.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((LogSegment)((Some)option).x()).lastModified() - log$2.config().deleteRetentionMs();
            }
            long deleteHorizonMs$1 = l;
            this.info((Function0<String>)new Serializable(this, log$2, deleteHorizonMs$1){
                public static final long serialVersionUID;
                private final Log log$2;
                private final long deleteHorizonMs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$2 = log;
                    this.deleteHorizonMs$1 = l;
                }
            });
            this.groupSegmentsBySize(log$2.logSegments(0L, endOffset), log$2.config().segmentSize(), log$2.config().maxIndexSize()).foreach((Function1)new Serializable(this, log$2, deleteHorizonMs$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                private final Log log$2;
                private final long deleteHorizonMs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$2, group, this.$outer.offsetMap(), this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$2 = log;
                    this.deleteHorizonMs$1 = l;
                }
            });
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log$4, Seq<LogSegment> segments$1, OffsetMap map$2, long deleteHorizonMs$2) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).index().maxIndexSize());
        LogSegment cleaned$1 = new LogSegment(messages, index, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).indexIntervalBytes(), log$4.config().randomSegmentJitter(), this.time);
        try {
            segments$1.foreach((Function1)new Serializable(this, log$4, map$2, deleteHorizonMs$2, cleaned$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                public final Log log$4;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment old$1) {
                    boolean retainDeletes$1 = old$1.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)new Serializable(this, old$1, retainDeletes$1){
                        public static final long serialVersionUID;
                        private final $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.old$1.baseOffset()), this.$outer.log$4.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong((long)this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = logSegment;
                            this.retainDeletes$1 = bl;
                        }
                    });
                    this.$outer.cleanInto(this.log$4.topicAndPartition(), old$1, this.cleaned$1, this.map$2, retainDeletes$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$4 = log;
                    this.map$2 = offsetMap;
                    this.deleteHorizonMs$2 = l;
                    this.cleaned$1 = logSegment;
                }
            });
            index.trimToValidSize();
            cleaned$1.flush();
            long modified = ((LogSegment)segments$1.last()).lastModified();
            cleaned$1.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log$4, segments$1, cleaned$1){
                public static final long serialVersionUID;
                private final Log log$4;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply(LogSegment logSegment) {
                            return logSegment.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$4.name()}));
                }
                {
                    this.log$4 = log;
                    this.segments$1 = seq;
                    this.cleaned$1 = logSegment;
                }
            });
            log$4.replaceSegments(cleaned$1, segments$1);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned$1.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source$1, LogSegment dest, OffsetMap map$3, boolean retainDeletes$2) {
        IntRef position$1 = new IntRef(0);
        while (position$1.elem < source$1.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source$1.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$1.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead$1 = new IntRef(0);
            messages.foreach((Function1)new Serializable(this, source$1, map$3, retainDeletes$2, position$1, messagesRead$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                public final LogSegment source$1;
                private final OffsetMap map$3;
                private final boolean retainDeletes$2;
                private final IntRef position$1;
                private final IntRef messagesRead$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndOffset entry2) {
                    boolean obsoleteDelete;
                    ++this.messagesRead$1.elem;
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.position$1.elem += size2;
                    this.$outer.stats().readMessage(size2);
                    ByteBuffer key = entry2.message().key();
                    Predef$.MODULE$.require(key != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$cleanInto$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Found null key in log segment %s which is marked as dedupe.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.source$1.log().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    long foundOffset = this.map$3.get(key);
                    boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
                    boolean bl = obsoleteDelete = !this.retainDeletes$2 && entry2.message().isNull();
                    if (!redundant && !obsoleteDelete) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                        this.$outer.stats().recopyMessage(size2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = logSegment;
                    this.map$3 = offsetMap;
                    this.retainDeletes$2 = bl;
                    this.position$1 = intRef;
                    this.messagesRead$1 = intRef2;
                }
            });
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead$1.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIoBufferSize)})));
        }
        int newSize$1 = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize$1){
            public static final long serialVersionUID;
            private final Cleaner $outer;
            private final int newSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append((Object)BoxesRunTime.boxToInteger((int)this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = n;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize$1));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize$1));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            segs = (List)segs.tail();
            while (!segs.isEmpty() && logSize + ((LogSegment)segs.head()).size() < (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public long buildOffsetMap(Log log$3, long start$1, long end$1, OffsetMap map$1) {
        map$1.clear();
        Seq dirty$1 = log$3.logSegments(start$1, end$1).toSeq();
        this.info((Function0<String>)new Serializable(this, log$3, start$1, end$1, dirty$1){
            public static final long serialVersionUID;
            private final Log log$3;
            private final long start$1;
            private final long end$1;
            private final Seq dirty$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$3 = log;
                this.start$1 = l;
                this.end$1 = l2;
                this.dirty$1 = seq;
            }
        });
        LongRef offset$1 = new LongRef(((LogSegment)dirty$1.head()).baseOffset());
        Predef$.MODULE$.require(offset$1.elem == start$1, (Function0)new Serializable(this, log$3, start$1, offset$1){
            public static final long serialVersionUID;
            private final Log log$3;
            private final long start$1;
            private final LongRef offset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.offset$1.elem), this.log$3.name()}));
            }
            {
                this.log$3 = log;
                this.start$1 = l;
                this.offset$1 = longRef;
            }
        });
        long minStopOffset$1 = (long)((double)start$1 + (double)map$1.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty$1.foreach((Function1)new Serializable(this, log$3, map$1, offset$1, minStopOffset$1){
            public static final long serialVersionUID;
            private final Cleaner $outer;
            private final Log log$3;
            private final OffsetMap map$1;
            private final LongRef offset$1;
            private final long minStopOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$3.topicAndPartition());
                if (segment.baseOffset() <= this.minStopOffset$1 || this.map$1.utilization() < this.$outer.kafka$log$Cleaner$$dupBufferLoadFactor) {
                    this.offset$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$3.topicAndPartition(), segment, this.map$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$3 = log;
                this.map$1 = offsetMap;
                this.offset$1 = longRef;
                this.minStopOffset$1 = l;
            }
        });
        this.info((Function0<String>)new Serializable(this, log$3){
            public static final long serialVersionUID;
            private final Log log$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Offset map for log %s complete.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name()}));
            }
            {
                this.log$3 = log;
            }
        });
        return offset$1.elem;
    }

    public final long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map$4) {
        IntRef position$2 = new IntRef(0);
        LongRef offset$2 = new LongRef(segment.baseOffset());
        while (position$2.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$2.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position$2.elem;
            messages.foreach((Function1)new Serializable(this, map$4, position$2, offset$2){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                private final OffsetMap map$4;
                private final IntRef position$2;
                private final LongRef offset$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndOffset entry2) {
                    Message message = entry2.message();
                    Predef$.MODULE$.require(message.hasKey());
                    int size2 = MessageSet$.MODULE$.entrySize(message);
                    this.position$2.elem += size2;
                    this.map$4.put(message.key(), entry2.offset());
                    this.offset$2.elem = entry2.offset();
                    this.$outer.stats().indexMessage(size2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.map$4 = offsetMap;
                    this.position$2 = intRef;
                    this.offset$2 = longRef;
                }
            });
            if (position$2.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset$2.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2((Object)new CleanerStats(time), (Object)new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

