/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ProducerPerformance;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ProducerPerformance$
implements Logging {
    public static final ProducerPerformance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ProducerPerformance$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ProducerPerformance$ producerPerformance$ = this;
        synchronized (producerPerformance$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        ProducerPerformance.ProducerPerfConfig config$1 = new ProducerPerformance.ProducerPerfConfig(args);
        if (!config$1.isFixedSize()) {
            logger.info((Object)"WARN: Throughput will be slower due to changing message size per request");
        }
        AtomicLong totalBytesSent$1 = new AtomicLong(0L);
        AtomicLong totalMessagesSent$1 = new AtomicLong(0L);
        ExecutorService executor$1 = Executors.newFixedThreadPool(config$1.numThreads());
        CountDownLatch allDone$1 = new CountDownLatch(config$1.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand$1 = new Random();
        if (!config$1.hideHeader()) {
            Predef$.MODULE$.println((Object)"start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
        }
        Predef$.MODULE$.intWrapper(0).until(config$1.numThreads()).foreach$mVc$sp((Function1)new Serializable(config$1, totalBytesSent$1, totalMessagesSent$1, executor$1, allDone$1, rand$1){
            public static final long serialVersionUID;
            private final ProducerPerformance.ProducerPerfConfig config$1;
            private final AtomicLong totalBytesSent$1;
            private final AtomicLong totalMessagesSent$1;
            private final ExecutorService executor$1;
            private final CountDownLatch allDone$1;
            private final Random rand$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.executor$1.execute(new ProducerPerformance.ProducerThread(v1, this.config$1, this.totalBytesSent$1, this.totalMessagesSent$1, this.allDone$1, this.rand$1));
            }
            {
                this.config$1 = producerPerfConfig;
                this.totalBytesSent$1 = atomicLong;
                this.totalMessagesSent$1 = atomicLong2;
                this.executor$1 = executorService;
                this.allDone$1 = countDownLatch;
                this.rand$1 = random;
            }
        });
        allDone$1.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        double totalMBSent = (double)totalBytesSent$1.get() * 1.0 / (double)0x100000;
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config$1.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config$1.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config$1.compressionCodec().codec()), BoxesRunTime.boxToInteger((int)config$1.messageSize()), BoxesRunTime.boxToInteger((int)config$1.batchSize()), BoxesRunTime.boxToDouble((double)totalMBSent), BoxesRunTime.boxToDouble((double)(totalMBSent / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesSent$1.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesSent$1.get() / elapsedSecs))})));
        System.exit(0);
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

