/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.model.Content;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="conditional", propOrder={"condition", "config", "configfile", "feature", "bundle"})
public class Conditional
extends Content
implements org.apache.karaf.features.Conditional {
    @XmlElement(name="condition", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<String> condition;
    @XmlTransient
    protected Feature owner;

    public Feature getOwner() {
        return this.owner;
    }

    public void setOwner(Feature owner) {
        this.owner = owner;
    }

    @Override
    public List<String> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<String>();
        }
        return this.condition;
    }

    @Override
    public Feature asFeature() {
        if (this.owner == null) {
            throw new IllegalStateException("No owner set for conditional");
        }
        String name = this.owner.getName();
        String version = this.owner.getVersion();
        String conditionName = name + "-condition-" + this.getConditionId().replaceAll("[^A-Za-z0-9 ]", "_");
        org.apache.karaf.features.internal.model.Feature f = new org.apache.karaf.features.internal.model.Feature(conditionName, version);
        f.getBundle().addAll(this.getBundle());
        f.getConfig().addAll(this.getConfig());
        f.getConfigfile().addAll(this.getConfigfile());
        f.getFeature().addAll(this.getFeature());
        return f;
    }

    private String getConditionId() {
        StringBuffer sb = new StringBuffer();
        for (String cond : this.getCondition()) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(cond);
        }
        return sb.toString();
    }
}

