/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blacklist {
    public static final String BLACKLIST_URL = "url";
    public static final String BLACKLIST_RANGE = "range";
    public static final String BLACKLIST_TYPE = "type";
    public static final String TYPE_FEATURE = "feature";
    public static final String TYPE_BUNDLE = "bundle";
    public static final String TYPE_REPOSITORY = "repository";
    private static final Logger LOGGER = LoggerFactory.getLogger(Blacklist.class);
    private Clause[] clauses;

    public Blacklist() {
        this(Collections.emptyList());
    }

    public Blacklist(List<String> blacklist) {
        this.clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]));
    }

    public Blacklist(String blacklistUrl) {
        HashSet blacklist = new HashSet();
        if (blacklistUrl != null) {
            try (InputStream is = new URL(blacklistUrl).openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(blacklist::add);
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Unable to load blacklist bundles list", (Object)e.toString());
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load blacklist bundles list", (Throwable)e);
            }
        }
        this.clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]));
    }

    public void blacklist(Features features) {
        features.getFeature().removeIf(this::blacklist);
    }

    public boolean blacklist(Feature feature) {
        for (Clause clause : this.clauses) {
            if (clause.getName().equals(feature.getName())) {
                String type;
                VersionRange range = VersionRange.ANY_VERSION;
                String vr = clause.getAttribute(BLACKLIST_RANGE);
                if (vr != null) {
                    range = new VersionRange(vr, true);
                }
                if (range.contains(VersionTable.getVersion(feature.getVersion())) && ((type = clause.getAttribute(BLACKLIST_TYPE)) == null || TYPE_FEATURE.equals(type))) {
                    return true;
                }
            }
            this.blacklist(feature.getBundle());
            for (Conditional cond : feature.getConditional()) {
                this.blacklist(cond.getBundle());
            }
        }
        return false;
    }

    private void blacklist(List<Bundle> bundles) {
        Iterator<Bundle> iterator = bundles.iterator();
        block0: while (iterator.hasNext()) {
            Bundle info = iterator.next();
            for (Clause clause : this.clauses) {
                String type;
                String url = clause.getName();
                if (clause.getAttribute(BLACKLIST_URL) != null) {
                    url = clause.getAttribute(BLACKLIST_URL);
                }
                if (!info.getLocation().equals(url) || (type = clause.getAttribute(BLACKLIST_TYPE)) != null && !TYPE_BUNDLE.equals(type)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public boolean isFeatureBlacklisted(String name, String version) {
        for (Clause clause : this.clauses) {
            String type;
            if (!clause.getName().equals(name)) continue;
            VersionRange range = VersionRange.ANY_VERSION;
            String vr = clause.getAttribute(BLACKLIST_RANGE);
            if (vr != null) {
                range = new VersionRange(vr, true);
            }
            if (!range.contains(VersionTable.getVersion(version)) || (type = clause.getAttribute(BLACKLIST_TYPE)) != null && !TYPE_FEATURE.equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isBundleBlacklisted(String uri) {
        return this.isBlacklisted(uri, TYPE_BUNDLE);
    }

    public boolean isBlacklisted(String uri, String btype) {
        for (Clause clause : this.clauses) {
            String type;
            String url = clause.getName();
            if (clause.getAttribute(BLACKLIST_URL) != null) {
                url = clause.getAttribute(BLACKLIST_URL);
            }
            if (!uri.equals(url) || (type = clause.getAttribute(BLACKLIST_TYPE)) != null && !btype.equals(type)) continue;
            return true;
        }
        return false;
    }
}

