/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.util.MapUtils;
import org.osgi.framework.Version;

public class FeatureReq {
    public static final String VERSION_SEPARATOR = "/";
    private static final String FEATURE_OSGI_REQUIREMENT_PREFIX = "feature:";
    private String name;
    private VersionRange versionRange;

    public static FeatureReq parseRequirement(String featureReq) {
        if (!featureReq.startsWith(FEATURE_OSGI_REQUIREMENT_PREFIX)) {
            return null;
        }
        String featureReq1 = featureReq.substring(FEATURE_OSGI_REQUIREMENT_PREFIX.length());
        return FeatureReq.parseNameAndRange(featureReq1);
    }

    public static FeatureReq parseNameAndRange(String nameAndRange) {
        return new FeatureReq(nameAndRange);
    }

    public FeatureReq(String nameAndRange) {
        String[] parts = nameAndRange.trim().split(VERSION_SEPARATOR);
        this.name = parts[0];
        this.versionRange = parts.length == 1 ? VersionRange.ANY_VERSION : FeatureReq.range(parts[1]);
    }

    public FeatureReq(String name, String versionRange) {
        this.name = name;
        this.versionRange = FeatureReq.range(versionRange);
    }

    public FeatureReq(String name, VersionRange versionRange) {
        this.name = name;
        this.versionRange = versionRange;
    }

    public FeatureReq(Feature feature) {
        this(feature.getName(), FeatureReq.exactVersion(feature.getVersion()));
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public Set<FeatureReq> getMatchingRequirements(Set<FeatureReq> reqs) {
        Pattern pattern = Pattern.compile(this.name);
        return MapUtils.filter(reqs, fr -> pattern.matcher(fr.getName()).matches() && this.versionRange.intersect(fr.getVersionRange()) != null);
    }

    public Stream<Feature> getMatchingFeatures(Map<String, Map<String, Feature>> allFeatures) {
        Pattern pattern = Pattern.compile(this.name);
        Function<String, Optional> func = featureName -> {
            Feature matchingFeature = null;
            if (pattern.matcher((CharSequence)featureName).matches()) {
                Map versions = (Map)allFeatures.get(featureName);
                matchingFeature = FeatureReq.getLatestFeature(versions, this.versionRange);
            }
            return Optional.ofNullable(matchingFeature);
        };
        return allFeatures.keySet().stream().map(func).filter(Optional::isPresent).map(Optional::get);
    }

    private static Feature getLatestFeature(Map<String, Feature> versions, VersionRange versionRange) {
        Feature feature = null;
        if (versions != null && !versions.isEmpty()) {
            Version latest = Version.emptyVersion;
            for (String available : versions.keySet()) {
                Version availableVersion = VersionTable.getVersion(available);
                if (availableVersion.compareTo(latest) < 0 || !versionRange.contains(availableVersion)) continue;
                feature = versions.get(available);
                latest = availableVersion;
            }
        }
        return feature;
    }

    public String toString() {
        return this.name + VERSION_SEPARATOR + this.getVersionRange().toString();
    }

    public String toRequirement() {
        return FEATURE_OSGI_REQUIREMENT_PREFIX + this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureReq that = (FeatureReq)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.versionRange, that.versionRange);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.versionRange);
    }

    private static VersionRange range(String versionRange) {
        if (versionRange == null) {
            return VersionRange.ANY_VERSION;
        }
        if ("0.0.0".equals(versionRange = versionRange.trim())) {
            return VersionRange.ANY_VERSION;
        }
        if (versionRange.contains(",")) {
            return new VersionRange(versionRange, false, true);
        }
        return FeatureReq.exactVersion(versionRange);
    }

    private static VersionRange exactVersion(String versionRange) {
        return new VersionRange(versionRange, true, true);
    }
}

