/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.service.Blacklist;
import org.apache.karaf.features.internal.service.RepositoryImpl;

public class RepositoryCache {
    private final Map<String, Repository> repositoryCache = new HashMap<String, Repository>();
    private final Blacklist blacklist;

    public RepositoryCache(Blacklist blacklist) {
        this.blacklist = blacklist;
    }

    public Repository create(URI uri, boolean validate) throws Exception {
        return new RepositoryImpl(uri, this.blacklist, validate);
    }

    public void addRepository(Repository repository) throws Exception {
        String repoUriSt = repository.getURI().toString();
        this.repositoryCache.put(repoUriSt, repository);
    }

    public void removeRepository(URI repositoryUri) throws Exception {
        ArrayList<String> toRemove = new ArrayList<String>();
        toRemove.add(repositoryUri.toString());
        while (!toRemove.isEmpty()) {
            Repository rep = this.repositoryCache.remove(toRemove.remove(0));
            if (rep == null) continue;
            for (URI u : rep.getRepositories()) {
                toRemove.add(u.toString());
            }
        }
    }

    public Repository[] listRepositories() {
        return this.repositoryCache.values().toArray(new Repository[this.repositoryCache.size()]);
    }

    public Repository[] listMatchingRepositories(Set<String> uris) throws Exception {
        return (Repository[])this.repositoryCache.values().stream().filter(r -> uris.contains(r.getURI().toString())).toArray(Repository[]::new);
    }

    public Repository getRepositoryByName(String name) throws Exception {
        for (Repository repo : this.repositoryCache.values()) {
            if (!name.equals(repo.getName())) continue;
            return repo;
        }
        return null;
    }

    public Repository getRepository(String uri) {
        return this.repositoryCache.get(uri);
    }

    public Set<Repository> getRepositoryClosure(Repository repo) throws Exception {
        HashSet<Repository> closure = new HashSet<Repository>();
        ArrayDeque<Repository> remaining = new ArrayDeque<Repository>(Collections.singleton(repo));
        while (!remaining.isEmpty()) {
            Repository rep = (Repository)remaining.removeFirst();
            if (!closure.add(rep)) continue;
            for (URI uri : rep.getRepositories()) {
                remaining.add(this.getRepository(uri.toString()));
            }
        }
        return closure;
    }
}

