/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.features.extension.BundleWires;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

class StoredWiringResolver
implements ResolverHook {
    private final Map<Long, BundleWires> wiring = new HashMap<Long, BundleWires>();
    private Path path;

    StoredWiringResolver(Path path) {
        this.path = path;
        this.load();
    }

    void load() {
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
            Files.list(this.path).forEach(p -> {
                String name = p.getFileName().toString();
                if (name.matches("[0-9]+")) {
                    long id = Long.parseLong(name);
                    try (BufferedReader reader = Files.newBufferedReader(p);){
                        this.wiring.put(id, new BundleWires(id, reader));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        long sourceId = this.getBundleId(requirement);
        this.wiring.get(sourceId).filterMatches(requirement, candidates);
    }

    public void end() {
    }

    private long getBundleId(BundleRequirement requirement) {
        long sourceId = requirement.getRevision().getBundle().getBundleId();
        if (StoredWiringResolver.isFragment((Resource)requirement.getRevision()) && !requirement.getNamespace().equals("osgi.wiring.host")) {
            sourceId = this.wiring.get(sourceId).getFragmentHost();
        }
        return sourceId;
    }

    private static boolean isFragment(Resource resource) {
        for (Capability cap : resource.getCapabilities(null)) {
            if (!"osgi.identity".equals(cap.getNamespace())) continue;
            return "osgi.fragment".equals(cap.getAttributes().get("type"));
        }
        return false;
    }

    synchronized void update(Bundle bundle) {
        BundleWires bw = new BundleWires(bundle);
        bw.save(this.path);
        this.wiring.put(bundle.getBundleId(), bw);
    }

    synchronized void delete(Bundle bundle) {
        if (this.wiring.get(bundle.getBundleId()) != null) {
            this.wiring.get(bundle.getBundleId()).delete(this.path);
        }
    }
}

