/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.scp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class ScpCommand
extends AbstractLoggingBean
implements Command,
Runnable,
FileSystemAware,
SessionAware,
SessionHolder<Session>,
ServerSessionHolder {
    protected final String name;
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected final ScpFileOpener opener;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected FileSystem fileSystem;
    protected String path;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;
    protected ExecutorService executors;
    protected boolean shutdownExecutor;
    protected Future<?> pendingFuture;
    protected ScpTransferEventListener listener;
    protected ServerSession serverSession;

    public ScpCommand(String command, ExecutorService executorService, boolean shutdownOnExit, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        this.name = command;
        if (executorService == null) {
            String poolName = command.replace(' ', '_').replace('/', ':');
            this.executors = ThreadUtils.newSingleThreadExecutor(poolName);
            this.shutdownExecutor = true;
        } else {
            this.executors = executorService;
            this.shutdownExecutor = shutdownOnExit;
        }
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size " + "(" + sendSize + ") below minimum required " + "(" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size " + "(" + sendSize + ") below minimum required " + "(" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        ScpTransferEventListener scpTransferEventListener = this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing command {}", (Object)command);
        }
        String[] args = GenericUtils.split(command, ' ');
        int numArgs = GenericUtils.length(args);
        for (int i = 1; i < numArgs; ++i) {
            char endDelim;
            String argVal = args[i];
            if (argVal.charAt(0) == '-') {
                block8: for (int j = 1; j < argVal.length(); ++j) {
                    char option = argVal.charAt(j);
                    switch (option) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block8;
                        }
                        default: {
                            if (!this.log.isDebugEnabled()) continue block8;
                            this.log.debug("Unknown flag ('{}') in command={}", (Object)Character.valueOf(option), (Object)command);
                        }
                    }
                }
                continue;
            }
            String prevArg = args[i - 1];
            this.path = command.substring(command.indexOf(prevArg) + prevArg.length() + 1);
            int pathLen = this.path.length();
            char startDelim = this.path.charAt(0);
            char c = endDelim = pathLen > 2 ? this.path.charAt(pathLen - 1) : (char)'\u0000';
            if (pathLen <= 2 || startDelim != endDelim || startDelim != '\'' && startDelim != '\"') break;
            this.path = this.path.substring(1, pathLen - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    @Override
    public Session getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void setSession(ServerSession session) {
        this.serverSession = session;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setFileSystem(FileSystem fs) {
        this.fileSystem = fs;
    }

    @Override
    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.pendingFuture = this.executors.submit(this);
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command=" + this.name + ": " + e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
            boolean result = this.pendingFuture.cancel(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("destroy() - cancel pending future=" + result);
            }
        }
        this.pendingFuture = null;
        if (this.executors != null && !this.executors.isShutdown() && this.shutdownExecutor) {
            List<Runnable> runners = this.executors.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("destroy() - shutdown executor service - runners count=" + runners.size());
            }
        }
        this.executors = null;
        try {
            this.fileSystem.close();
        }
        catch (UnsupportedOperationException runners) {
        }
        catch (IOException e) {
            this.log.debug("Error closing FileSystem", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        ScpHelper helper = new ScpHelper(this.getServerSession(), this.in, this.out, this.fileSystem, this.opener, this.listener);
        try {
            if (this.optT) {
                helper.receive(helper.resolveLocalPath(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
            } else if (this.optF) {
                helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
            } else {
                throw new IOException("Unsupported mode");
            }
            if (this.callback != null) {
                this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
            }
        }
        catch (IOException e) {
            try {
                ServerSession session;
                block19: {
                    session = this.getServerSession();
                    try {
                        Integer statusCode = null;
                        if (e instanceof ScpException) {
                            statusCode = ((ScpException)e).getExitStatus();
                        }
                        int n = exitValue = statusCode == null ? 2 : statusCode;
                        if (exitValue == 0 || exitValue == 1) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("run({})[{}] normalize status code={}", new Object[]{session, this.name, exitValue});
                            }
                            exitValue = 2;
                        }
                        exitMessage = GenericUtils.trimToEmpty(e.getMessage());
                        this.writeCommandResponseMessage(this.name, exitValue, exitMessage);
                    }
                    catch (IOException e2) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("run({})[{}] Failed ({}) to send error response: {}", new Object[]{session, this.name, e.getClass().getSimpleName(), e.getMessage()});
                        }
                        if (!this.log.isTraceEnabled()) break block19;
                        this.log.trace("run(" + session + ")[" + this.name + "] error response failure details", (Throwable)e2);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("run({})[{}] Failed ({}) to run command: {}", new Object[]{session, this.name, e.getClass().getSimpleName(), e.getMessage()});
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("run(" + session + ")[" + this.name + "] command execution failure details", (Throwable)e);
                }
                if (this.callback != null) {
                    this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                }
            }
            catch (Throwable throwable) {
                if (this.callback != null) {
                    this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                }
                throw throwable;
            }
        }
    }

    protected void writeCommandResponseMessage(String command, int exitValue, String exitMessage) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeCommandResponseMessage({}) command='{}', exit-status={}: {}", new Object[]{this.getServerSession(), command, exitValue, exitMessage});
        }
        ScpHelper.sendResponseMessage(this.out, exitValue, exitMessage);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getSession() + ") " + this.name;
    }
}

