/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.internal.LogServiceInternal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LogServiceLog4j2XmlImpl
implements LogServiceInternal {
    private static final String ELEMENT_LOGGERS = "Loggers";
    private static final String ELEMENT_ROOT = "Root";
    private static final String ELEMENT_LOGGER = "Logger";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_LEVEL = "level";
    private static final String ELEMENT_CONFIGURATION = "Configuration";
    private final Path path;

    LogServiceLog4j2XmlImpl(String file) {
        this.path = Paths.get(file, new String[0]);
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        try {
            Document doc = LogServiceLog4j2XmlImpl.loadConfig(this.path);
            Map<String, Element> loggers = this.getLoggers(doc);
            TreeMap<String, String> levels = new TreeMap<String, String>();
            for (Map.Entry<String, Element> e : loggers.entrySet()) {
                String level = e.getValue().getAttribute(ATTRIBUTE_LEVEL);
                if (level == null || level.isEmpty()) continue;
                levels.put(e.getKey(), level);
            }
            if ("ALL".equals(logger)) {
                return levels;
            }
            String l = logger;
            while (true) {
                String val;
                if ((val = (String)levels.get(l != null ? l : "ROOT")) != null || l == null) {
                    return Collections.singletonMap(logger, val);
                }
                int idx = l.lastIndexOf(46);
                if (idx < 0) {
                    l = null;
                    continue;
                }
                l = l.substring(0, idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve level for logger", e);
        }
    }

    @Override
    public void setLevel(String logger, String level) {
        try {
            Document doc = LogServiceLog4j2XmlImpl.loadConfig(this.path);
            Map<String, Element> loggers = this.getLoggers(doc);
            Element element = loggers.get(logger);
            if (element != null) {
                if (Level.isDefault(level)) {
                    element.removeAttribute(ATTRIBUTE_LEVEL);
                } else {
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                }
            } else if (!Level.isDefault(level)) {
                Element docE = doc.getDocumentElement();
                Element docLoggers = (Element)docE.getElementsByTagName(ELEMENT_LOGGERS).item(0);
                boolean root = "ROOT".equals(logger);
                if (root) {
                    element = doc.createElement(ELEMENT_ROOT);
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                } else {
                    element = doc.createElement(ELEMENT_LOGGER);
                    element.setAttribute(ATTRIBUTE_NAME, logger);
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                }
                LogServiceLog4j2XmlImpl.insertIndented(docLoggers, element, root);
            } else {
                return;
            }
            try (OutputStream os = Files.newOutputStream(this.path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(os));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set level for logger", e);
        }
    }

    static void insertIndented(Element loggers, Element element, boolean atBeginning) {
        NodeList loggerElements = loggers.getElementsByTagName("*");
        if (atBeginning && loggerElements.getLength() > 0) {
            Node insertBefore = loggers.getFirstChild();
            if (insertBefore != null) {
                if (insertBefore.getNodeType() == 3) {
                    String indent = loggers.getFirstChild().getTextContent();
                    Text node = loggers.getOwnerDocument().createTextNode(indent);
                    loggers.insertBefore(node, insertBefore);
                }
                loggers.insertBefore(element, insertBefore);
            } else {
                loggers.appendChild(element);
            }
        } else {
            Node insertAfter;
            Node node = insertAfter = loggerElements.getLength() > 0 ? loggerElements.item(loggerElements.getLength() - 1) : null;
            if (insertAfter != null) {
                if (insertAfter.getPreviousSibling() != null && insertAfter.getPreviousSibling().getNodeType() == 3) {
                    String indent = insertAfter.getPreviousSibling().getTextContent();
                    Text node2 = loggers.getOwnerDocument().createTextNode(indent);
                    if (insertAfter.getNextSibling() != null) {
                        loggers.insertBefore(node2, insertAfter.getNextSibling());
                        insertAfter = node2;
                    } else {
                        loggers.appendChild(node2);
                    }
                }
                if (insertAfter.getNextSibling() != null) {
                    loggers.insertBefore(element, insertAfter.getNextSibling());
                } else {
                    loggers.appendChild(element);
                }
            } else if (loggers.getPreviousSibling() != null && loggers.getPreviousSibling().getNodeType() == 3) {
                int nl;
                String indent;
                String prev = indent = loggers.getPreviousSibling().getTextContent();
                indent = indent.endsWith("\t") ? indent + "\t" : ((nl = indent.lastIndexOf(10)) >= 0 ? indent + indent.substring(nl + 1) : indent + "\t");
                if (loggers.getFirstChild() != null && loggers.getPreviousSibling().getNodeType() == 3) {
                    loggers.removeChild(loggers.getFirstChild());
                }
                loggers.appendChild(loggers.getOwnerDocument().createTextNode(indent));
                loggers.appendChild(element);
                loggers.appendChild(loggers.getOwnerDocument().createTextNode(prev));
            } else {
                loggers.appendChild(element);
            }
        }
    }

    static Document loadConfig(Path path) throws Exception {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            Document document = LogServiceLog4j2XmlImpl.loadConfig(path.toString(), is);
            return document;
        }
    }

    static Document loadConfig(String id, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        InputSource source = new InputSource(is);
        source.setPublicId(id);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        LogServiceLog4j2XmlImpl.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        LogServiceLog4j2XmlImpl.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        LogServiceLog4j2XmlImpl.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        LogServiceLog4j2XmlImpl.setFeature(factory, "http://apache.org/xml/features/xinclude/fixup-base-uris", true);
        LogServiceLog4j2XmlImpl.setFeature(factory, "http://apache.org/xml/features/xinclude/fixup-language", true);
        LogServiceLog4j2XmlImpl.tryCall(() -> factory.setXIncludeAware(true));
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(source);
    }

    private static void setFeature(DocumentBuilderFactory factory, String name, boolean b) {
        LogServiceLog4j2XmlImpl.tryCall(() -> factory.setFeature(name, b));
    }

    private static void tryCall(RunnableWithException c) {
        try {
            c.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Element> getLoggers(Document doc) {
        TreeMap<String, Element> loggers = new TreeMap<String, Element>();
        Element docE = doc.getDocumentElement();
        if (!ELEMENT_CONFIGURATION.equals(docE.getLocalName())) {
            throw new IllegalArgumentException("Xml root document should be Configuration");
        }
        NodeList children = docE.getElementsByTagName(ELEMENT_LOGGERS);
        if (children.getLength() != 1) {
            return Collections.emptyMap();
        }
        NodeList loggersList = children.item(0).getChildNodes();
        for (int i = 0; i < loggersList.getLength(); ++i) {
            String name;
            Node n = loggersList.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (ELEMENT_ROOT.equals(e.getLocalName())) {
                loggers.put("ROOT", e);
                continue;
            }
            if (!ELEMENT_LOGGER.equals(e.getLocalName()) || (name = e.getAttribute(ATTRIBUTE_NAME)) == null) continue;
            loggers.put(name, e);
        }
        return loggers;
    }

    static interface RunnableWithException {
        public void run() throws Exception;
    }
}

