/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.CoordinatorUtil;
import org.apache.felix.cm.impl.DynamicBindings;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.SimpleFilter;
import org.apache.felix.cm.impl.UpdateThread;
import org.apache.felix.cm.impl.helper.BaseTracker;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.ManagedServiceFactoryTracker;
import org.apache.felix.cm.impl.helper.ManagedServiceTracker;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.apache.felix.cm.impl.persistence.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManager
implements BundleListener {
    private static Random numberGenerator;
    private final BundleContext bundleContext;
    private volatile ServiceRegistration<ConfigurationAdmin> configurationAdminRegistration;
    private ServiceTracker<ConfigurationListener, ConfigurationListener> configurationListenerTracker;
    private ServiceTracker<SynchronousConfigurationListener, SynchronousConfigurationListener> syncConfigurationListenerTracker;
    private ManagedServiceTracker managedServiceTracker;
    private ManagedServiceFactoryTracker managedServiceFactoryTracker;
    private UpdateThread updateThread;
    private UpdateThread eventThread;
    private final ExtPersistenceManager persistenceManager;
    private final HashMap<String, ConfigurationImpl> configurations = new HashMap();
    private final DynamicBindings dynamicBindings;
    private volatile boolean handleBundleEvents;
    private volatile boolean isActive;
    private volatile Object coordinator;

    public ConfigurationManager(ExtPersistenceManager persistenceManager, BundleContext bundleContext) throws IOException {
        this.bundleContext = bundleContext;
        this.dynamicBindings = new DynamicBindings(bundleContext, persistenceManager.getDelegatee());
        this.persistenceManager = persistenceManager;
    }

    public ServiceReference<ConfigurationAdmin> start() {
        this.configurationListenerTracker = new ServiceTracker(this.bundleContext, ConfigurationListener.class, null);
        this.configurationListenerTracker.open();
        this.syncConfigurationListenerTracker = new ServiceTracker(this.bundleContext, SynchronousConfigurationListener.class, null);
        this.syncConfigurationListenerTracker.open();
        ThreadGroup tg = new ThreadGroup("Configuration Admin Service");
        tg.setDaemon(true);
        this.updateThread = new UpdateThread(tg, "CM Configuration Updater");
        this.eventThread = new UpdateThread(tg, "CM Event Dispatcher");
        this.handleBundleEvents = true;
        this.bundleContext.addBundleListener((BundleListener)this);
        this.isActive = true;
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        ((Dictionary)props).put("service.description", "Configuration Admin Service Specification 1.6 Implementation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.configurationAdminRegistration = this.bundleContext.registerService(ConfigurationAdmin.class, (ServiceFactory)caf, props);
        this.managedServiceTracker = new ManagedServiceTracker(this);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this);
        this.updateThread.start();
        this.eventThread.start();
        return this.configurationAdminRegistration.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.handleBundleEvents = false;
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        if (this.updateThread != null) {
            this.updateThread.terminate();
        }
        if (this.eventThread != null) {
            this.eventThread.terminate();
        }
        ServiceRegistration<ConfigurationAdmin> caReg = this.configurationAdminRegistration;
        this.configurationAdminRegistration = null;
        if (caReg != null) {
            caReg.unregister();
        }
        this.isActive = false;
        this.bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.syncConfigurationListenerTracker != null) {
            this.syncConfigurationListenerTracker.close();
        }
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            this.configurations.clear();
        }
    }

    boolean isActive() {
        return this.isActive;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl[] getCachedConfigurations() {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            return this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            String pid = configuration.getPidString();
            ConfigurationImpl existing = this.configurations.get(pid);
            if (existing != null) {
                return existing;
            }
            this.configurations.put(pid, configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        HashMap<String, ConfigurationImpl> hashMap = this.configurations;
        synchronized (hashMap) {
            this.configurations.remove(configuration.getPidString());
        }
    }

    void setDynamicBundleLocation(String pid, String location) {
        if (this.dynamicBindings != null) {
            try {
                this.dynamicBindings.putLocation(pid, location);
            }
            catch (IOException ioe) {
                Log.logger.log(1, "Failed storing dynamic configuration binding for {0} to {1}", new Object[]{pid, location, ioe});
            }
        }
    }

    String getDynamicBundleLocation(String pid) {
        if (this.dynamicBindings != null) {
            return this.dynamicBindings.getLocation(pid);
        }
        return null;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        return this.cacheConfiguration(this.internalCreateConfiguration(ConfigurationManager.createPid(factoryPid), factoryPid, location));
    }

    ConfigurationImpl createFactoryConfiguration(String pid, String factoryPid, String location) throws IOException {
        return this.cacheConfiguration(this.internalCreateConfiguration(pid, factoryPid, location));
    }

    ConfigurationImpl getTargetedConfiguration(String rawPid, ServiceReference target) throws IOException {
        Bundle serviceBundle = target.getBundle();
        if (serviceBundle != null) {
            StringBuilder targetedPid = new StringBuilder(rawPid);
            int i = 3;
            String[] names = new String[4];
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(serviceBundle.getSymbolicName());
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(serviceBundle.getVersion().toString());
            names[i--] = targetedPid.toString();
            targetedPid.append('|').append(serviceBundle.getLocation());
            names[i--] = targetedPid.toString();
            for (String candidate : names) {
                ConfigurationImpl config = this.getConfiguration(candidate);
                if (config == null || config.isDeleted()) continue;
                if (this.canReceive(serviceBundle, config.getBundleLocation())) {
                    config.tryBindLocation(serviceBundle.getLocation());
                    return config;
                }
                Log.logger.log(4, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}; calling with null", new Object[]{config.getPid(), target, config.getBundleLocation()});
            }
        } else {
            Log.logger.log(3, "Service for PID {0} seems to already have been unregistered, not updating with configuration", new Object[]{rawPid});
        }
        return null;
    }

    ConfigurationImpl getConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            Log.logger.log(4, "Found cached configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            config.ensureFactoryConfigPersisted();
            return config;
        }
        if (this.persistenceManager.exists(pid)) {
            Dictionary props = this.persistenceManager.load(pid);
            config = new ConfigurationImpl(this, this.persistenceManager, props);
            Log.logger.log(4, "Found existing configuration {0} bound to {1}", new Object[]{pid, config.getBundleLocation()});
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl createConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getConfiguration(pid);
        if (config != null) {
            return config;
        }
        config = this.internalCreateConfiguration(pid, null, bundleLocation);
        return this.cacheConfiguration(config);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        SimpleFilter filter = null;
        if (filterString != null) {
            filter = SimpleFilter.parse(filterString);
        }
        Log.logger.log(4, "Listing configurations matching {0}", new Object[]{filterString});
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        Collection<Dictionary> configs = this.persistenceManager.getDictionaries(filter);
        for (Dictionary config : configs) {
            String pid = (String)config.get("service.pid");
            if (pid == null) continue;
            if (!configurationAdmin.hasPermission(this, (String)config.get("service.bundleLocation"))) {
                Log.logger.log(4, "Omitting configuration {0}: No permission for bundle {1} on configuration bound to {2}", new Object[]{pid, configurationAdmin.getBundle().getLocation(), config.get("service.bundleLocation")});
                continue;
            }
            ConfigurationImpl cfg = null;
            if (this.persistenceManager instanceof CachingPersistenceManagerProxy) {
                cfg = this.getCachedConfiguration(pid);
                if (cfg == null) {
                    cfg = new ConfigurationImpl(this, this.persistenceManager, config);
                    this.cacheConfiguration(cfg);
                }
            } else {
                cfg = new ConfigurationImpl(this, this.persistenceManager, config);
            }
            if (!cfg.isNew()) {
                Log.logger.log(4, "Adding configuration {0}", new Object[]{pid});
                configList.add(cfg);
                continue;
            }
            Log.logger.log(4, "Omitting configuration {0}: Is new", new Object[]{pid});
        }
        if (configList.size() == 0) {
            return null;
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.fireConfigurationEvent(2, config.getPidString(), config.getFactoryPidString());
        DeleteConfiguration task = new DeleteConfiguration(config);
        if (this.coordinator == null || !CoordinatorUtil.addToCoordination(this.coordinator, this.updateThread, task)) {
            this.updateThread.schedule(task);
        }
        Log.logger.log(4, "DeleteConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void updated(ConfigurationImpl config, boolean fireEvent) {
        if (fireEvent) {
            this.fireConfigurationEvent(1, config.getPidString(), config.getFactoryPidString());
        }
        UpdateConfiguration task = new UpdateConfiguration(config);
        if (this.coordinator == null || !CoordinatorUtil.addToCoordination(this.coordinator, this.updateThread, task)) {
            this.updateThread.schedule(task);
        }
        Log.logger.log(4, "UpdateConfiguration({0}) scheduled", new Object[]{config.getPid()});
    }

    void locationChanged(ConfigurationImpl config, String oldLocation) {
        this.fireConfigurationEvent(3, config.getPidString(), config.getFactoryPidString());
        if (oldLocation != null && !config.isNew()) {
            LocationChanged task = new LocationChanged(config, oldLocation);
            if (this.coordinator == null || !CoordinatorUtil.addToCoordination(this.coordinator, this.updateThread, task)) {
                this.updateThread.schedule(task);
            }
            Log.logger.log(4, "LocationChanged({0}, {1}=>{2}) scheduled", new Object[]{config.getPid(), oldLocation, config.getBundleLocation()});
        } else {
            Log.logger.log(4, "LocationChanged not scheduled for {0} (old location is null or configuration is new)", new Object[]{config.getPid()});
        }
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        FireConfigurationEvent asyncSender = new FireConfigurationEvent(this.configurationListenerTracker, type, pid, factoryPid);
        FireConfigurationEvent syncSender = new FireConfigurationEvent(this.syncConfigurationListenerTracker, type, pid, factoryPid);
        if (syncSender.hasConfigurationEventListeners()) {
            syncSender.run();
        } else {
            Log.logger.log(4, "No SynchronousConfigurationListeners to send {0} event to.", new Object[]{syncSender.getTypeName()});
        }
        if (asyncSender.hasConfigurationEventListeners()) {
            if (this.coordinator == null || !CoordinatorUtil.addToCoordination(this.coordinator, this.eventThread, asyncSender)) {
                this.eventThread.schedule(asyncSender);
            }
        } else {
            Log.logger.log(4, "No ConfigurationListeners to send {0} event to.", new Object[]{asyncSender.getTypeName()});
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 && this.handleBundleEvents) {
            String location = event.getBundle().getLocation();
            ConfigurationImpl[] configs = this.getCachedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationImpl cfg = configs[i];
                if (!location.equals(cfg.getDynamicBundleLocation())) continue;
                cfg.setDynamicBundleLocation(null, true);
            }
        }
    }

    private ServiceReference<ConfigurationAdmin> getServiceReference() {
        ServiceRegistration<ConfigurationAdmin> reg = this.configurationAdminRegistration;
        if (reg != null) {
            return reg.getReference();
        }
        BundleContext context = this.bundleContext;
        if (context != null) {
            try {
                Collection refs = context.getServiceReferences(ConfigurationAdmin.class, null);
                if (refs != null && !refs.isEmpty()) {
                    for (ServiceReference ref : refs) {
                        if (ref.getBundle().getBundleId() != context.getBundle().getBundleId()) continue;
                        return ref;
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public void configure(String[] pid, ServiceReference sr, boolean factory, ConfigurationMap<?> configs) {
        if (Log.logger.isLogEnabled(4)) {
            Log.logger.log(4, "configure(ManagedService {0})", new Object[]{sr});
        }
        Runnable r = factory ? new ManagedServiceFactoryUpdate(pid, (ServiceReference<ManagedServiceFactory>)sr, configs) : new ManagedServiceUpdate(pid, (ServiceReference<ManagedService>)sr, configs);
        if (this.coordinator == null || !CoordinatorUtil.addToCoordination(this.coordinator, this.updateThread, r)) {
            this.updateThread.schedule(r);
        }
        Log.logger.log(4, "[{0}] scheduled", new Object[]{r});
    }

    private ConfigurationImpl internalCreateConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        Log.logger.log(4, "createConfiguration({0}, {1}, {2})", new Object[]{pid, factoryPid, bundleLocation});
        return new ConfigurationImpl(this, this.persistenceManager, pid, factoryPid, bundleLocation);
    }

    List<String> getTargetedFactories(String rawFactoryPid, ServiceReference target) throws IOException {
        LinkedList<String> factories = new LinkedList<String>();
        Bundle serviceBundle = target.getBundle();
        if (serviceBundle != null) {
            StringBuilder targetedPid = new StringBuilder(rawFactoryPid);
            factories.add(targetedPid.toString());
            targetedPid.append('|').append(serviceBundle.getSymbolicName());
            factories.add(0, targetedPid.toString());
            targetedPid.append('|').append(serviceBundle.getVersion().toString());
            factories.add(0, targetedPid.toString());
            targetedPid.append('|').append(serviceBundle.getLocation());
            factories.add(0, targetedPid.toString());
        }
        return factories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callPlugins(Dictionary<String, Object> props, ServiceReference<?> sr, String configPid, String factoryPid) {
        ServiceReference[] plugins = null;
        try {
            String targetPid = factoryPid == null ? configPid : factoryPid;
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = this.bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException targetPid) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        if (plugins.length > 1) {
            Arrays.sort(plugins, RankingComparator.CM_RANKING);
        }
        for (int i = 0; i < plugins.length; ++i) {
            void pluginRef = plugins[i];
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService((ServiceReference)pluginRef);
            if (plugin == null) continue;
            boolean ignore = false;
            Object rankObj = pluginRef.getProperty("service.cmRanking");
            if (rankObj instanceof Integer) {
                int ranking = (Integer)rankObj;
                ignore = ranking < 0 || ranking > 1000;
            }
            try {
                plugin.modifyConfiguration(sr, ignore ? CaseInsensitiveDictionary.unmodifiable(props) : props);
            }
            catch (Throwable t) {
                Log.logger.log(1, "Unexpected problem calling configuration plugin {0}", new Object[]{pluginRef, t});
            }
            finally {
                this.bundleContext.ungetService((ServiceReference)pluginRef);
            }
            ConfigurationImpl.setAutoProperties(props, configPid, factoryPid);
        }
    }

    private static String createPid(String factoryPid) {
        Random ng = numberGenerator;
        if (ng == null) {
            try {
                ng = new SecureRandom();
            }
            catch (Throwable t) {
                ng = new Random();
            }
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuilder buf = new StringBuilder(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    boolean canReceive(Bundle bundle, String location) {
        if (location == null) {
            Log.logger.log(4, "canReceive=true; bundle={0}; configuration=(unbound)", new Object[]{bundle.getLocation()});
            return true;
        }
        if (location.startsWith("?")) {
            if (System.getSecurityManager() != null) {
                boolean hasPermission = bundle.hasPermission((Object)new ConfigurationPermission(location, "target"));
                Log.logger.log(4, "canReceive={0}: bundle={1}; configuration={2} (SecurityManager check)", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
                return hasPermission;
            }
            Log.logger.log(4, "canReceive=true; bundle={0}; configuration={1} (no SecurityManager)", new Object[]{bundle.getLocation(), location});
            return true;
        }
        boolean hasPermission = location.equals(bundle.getLocation());
        Log.logger.log(4, "canReceive={0}: bundle={1}; configuration={2}", new Object[]{new Boolean(hasPermission), bundle.getLocation(), location});
        return hasPermission;
    }

    public void setCoordinator(Object service) {
        this.coordinator = service;
    }

    private class FireConfigurationEvent
    implements Runnable {
        private final int type;
        private final String pid;
        private final String factoryPid;
        private final ServiceReference[] listenerReferences;
        private final ConfigurationListener[] listeners;
        private final Bundle[] listenerProvider;
        private ConfigurationEvent event;

        private FireConfigurationEvent(ServiceTracker listenerTracker, int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
            ServiceReference[] srs = listenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                this.listenerReferences = null;
                this.listeners = null;
                this.listenerProvider = null;
            } else {
                this.listenerReferences = srs;
                this.listeners = new ConfigurationListener[srs.length];
                this.listenerProvider = new Bundle[srs.length];
                for (int i = 0; i < srs.length; ++i) {
                    this.listeners[i] = (ConfigurationListener)listenerTracker.getService(srs[i]);
                    this.listenerProvider[i] = srs[i].getBundle();
                }
            }
        }

        boolean hasConfigurationEventListeners() {
            return this.listenerReferences != null;
        }

        String getTypeName() {
            switch (this.type) {
                case 2: {
                    return "CM_DELETED";
                }
                case 1: {
                    return "CM_UPDATED";
                }
                case 3: {
                    return "CM_LOCATION_CHANGED";
                }
            }
            return "<UNKNOWN(" + this.type + ")>";
        }

        @Override
        public void run() {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.sendEvent(i);
            }
        }

        public String toString() {
            return "Fire ConfigurationEvent: pid=" + this.pid;
        }

        private ConfigurationEvent getConfigurationEvent() {
            if (this.event == null) {
                this.event = new ConfigurationEvent((ServiceReference<ConfigurationAdmin>)ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            }
            return this.event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendEvent(int serviceIndex) {
            if ((this.listenerProvider[serviceIndex].getState() & 0x28) > 0 && this.listeners[serviceIndex] != null) {
                Log.logger.log(4, "Sending {0} event for {1} to {2}", new Object[]{this.getTypeName(), this.pid, this.listenerReferences[serviceIndex]});
                try {
                    this.listeners[serviceIndex].configurationEvent(this.getConfigurationEvent());
                }
                catch (Throwable t) {
                    Log.logger.log(1, "Unexpected problem delivering configuration event to {0}", new Object[]{this.listenerReferences[serviceIndex], t});
                }
                finally {
                    this.listeners[serviceIndex] = null;
                }
            }
        }
    }

    private class LocationChanged
    extends ConfigurationProvider {
        private final String oldLocation;

        LocationChanged(ConfigurationImpl config, String oldLocation) {
            super(config);
            this.oldLocation = oldLocation;
        }

        @Override
        public void run() {
            List srList = this.getHelper().getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                for (ServiceReference sr : srList) {
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        Log.logger.log(4, "Service {0} seems to be unregistered concurrently (not processing)", new Object[]{sr});
                        continue;
                    }
                    boolean wasVisible = ConfigurationManager.this.canReceive(srBundle, this.oldLocation);
                    boolean isVisible = ConfigurationManager.this.canReceive(srBundle, this.config.getBundleLocation());
                    if (isVisible) {
                        this.config.tryBindLocation(srBundle.getLocation());
                    }
                    if (wasVisible && !isVisible) {
                        if (this.provideReplacement(sr)) continue;
                        this.getHelper().removeConfiguration(sr, this.config.getPid(), this.config.getFactoryPid());
                        Log.logger.log(4, "Configuration {0} revoked from {1} (no more visibility)", new Object[]{this.config.getPid(), sr});
                        continue;
                    }
                    if (!wasVisible && isVisible) {
                        this.getHelper().provideConfiguration(sr, this.config.getPid(), this.config.getFactoryPid(), this.properties, this.revision, null);
                        Log.logger.log(4, "Configuration {0} provided to {1} (new visibility)", new Object[]{this.config.getPid(), sr});
                        continue;
                    }
                    Log.logger.log(4, "Unmodified visibility to configuration {0} for {1}", new Object[]{this.config.getPid(), sr});
                }
            }
        }

        public String toString() {
            return "Location Changed (pid=" + this.config.getPid() + "): " + this.oldLocation + " ==> " + this.config.getBundleLocation();
        }
    }

    private class DeleteConfiguration
    extends ConfigurationProvider {
        private final String configLocation;

        DeleteConfiguration(ConfigurationImpl config) {
            super(config);
            this.configLocation = config.getBundleLocation();
        }

        @Override
        public void run() {
            List srList = this.getHelper().getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                for (ServiceReference sr : srList) {
                    Bundle srBundle = sr.getBundle();
                    if (srBundle == null) {
                        Log.logger.log(4, "Service {0} seems to be unregistered concurrently (not removing configuration)", new Object[]{sr});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(srBundle, this.configLocation)) {
                        if (this.provideReplacement(sr)) continue;
                        this.getHelper().removeConfiguration(sr, this.config.getPid(), this.config.getFactoryPid());
                        continue;
                    }
                    Log.logger.log(1, "Cannot remove configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), sr, this.configLocation});
                }
            }
        }

        public String toString() {
            return "Delete: pid=" + this.config.getPid();
        }
    }

    private class UpdateConfiguration
    extends ConfigurationProvider {
        UpdateConfiguration(ConfigurationImpl config) {
            super(config);
        }

        @Override
        public void run() {
            Log.logger.log(4, "Updating configuration {0} to revision #{1}", new Object[]{this.config.getPid(), new Long(this.revision)});
            List srList = this.getHelper().getServices(this.getTargetedServicePid());
            if (!srList.isEmpty()) {
                Bundle bundle = srList.get(0).getBundle();
                if (bundle == null) {
                    Log.logger.log(4, "Service {0} seems to be unregistered concurrently (not providing configuration)", new Object[]{srList.get(0)});
                    return;
                }
                this.config.tryBindLocation(bundle.getLocation());
                String configBundleLocation = this.config.getBundleLocation();
                for (ServiceReference ref : srList) {
                    Bundle refBundle = ref.getBundle();
                    if (refBundle == null) {
                        Log.logger.log(4, "Service {0} seems to be unregistered concurrently (not providing configuration)", new Object[]{ref});
                        continue;
                    }
                    if (ConfigurationManager.this.canReceive(refBundle, configBundleLocation)) {
                        this.getHelper().provideConfiguration(ref, this.config.getPid(), this.config.getFactoryPid(), this.properties, this.revision, null);
                        continue;
                    }
                    Log.logger.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{this.config.getPid(), ref, configBundleLocation});
                }
            } else if (Log.logger.isLogEnabled(4)) {
                Log.logger.log(4, "No ManagedService[Factory] registered for updates to configuration {0}", new Object[]{this.config.getPid()});
            }
        }

        public String toString() {
            return "Update: pid=" + this.config.getPid();
        }
    }

    private abstract class ConfigurationProvider<T>
    implements Runnable {
        protected final ConfigurationImpl config;
        protected final long revision;
        protected final Dictionary<String, ?> properties;
        private BaseTracker<T> helper;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ConfigurationProvider(ConfigurationImpl config) {
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                this.config = config;
                this.revision = config.getRevision();
                this.properties = config.getProperties(true);
            }
        }

        protected TargetedPID getTargetedServicePid() {
            TargetedPID factoryPid = this.config.getFactoryPid();
            if (factoryPid != null) {
                return factoryPid;
            }
            return this.config.getPid();
        }

        protected BaseTracker<T> getHelper() {
            if (this.helper == null) {
                this.helper = this.config.getFactoryPid() == null ? ConfigurationManager.this.managedServiceTracker : ConfigurationManager.this.managedServiceFactoryTracker;
            }
            return this.helper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean provideReplacement(ServiceReference<T> sr) {
            block8: {
                if (this.config.getFactoryPid() == null) {
                    try {
                        long revision;
                        Dictionary<String, Object> properties;
                        TargetedPID configPid;
                        String configPidString = this.getHelper().getServicePid(sr, this.config.getPid());
                        if (configPidString == null) {
                            return false;
                        }
                        ConfigurationImpl rc = ConfigurationManager.this.getTargetedConfiguration(configPidString, sr);
                        if (rc == null) break block8;
                        ConfigurationImpl configurationImpl = rc;
                        synchronized (configurationImpl) {
                            configPid = rc.getPid();
                            properties = rc.getProperties(true);
                            revision = rc.getRevision();
                        }
                        this.getHelper().provideConfiguration(sr, configPid, null, properties, -revision, null);
                        return true;
                    }
                    catch (IOException ioe) {
                        Log.logger.log(1, "Error loading configuration for {0}", new Object[]{this.config.getPid(), ioe});
                    }
                    catch (Exception e) {
                        Log.logger.log(1, "Unexpected problem providing configuration {0} to service {1}", new Object[]{this.config.getPid(), sr, e});
                    }
                }
            }
            return false;
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private final String[] factoryPids;
        private final ServiceReference<ManagedServiceFactory> sr;
        private final ConfigurationMap<?> configs;

        ManagedServiceFactoryUpdate(String[] factoryPids, ServiceReference<ManagedServiceFactory> sr, ConfigurationMap<?> configs) {
            this.factoryPids = factoryPids;
            this.sr = sr;
            this.configs = configs;
        }

        @Override
        public void run() {
            for (String factoryPid : this.factoryPids) {
                try {
                    List<String> targetedFactoryPids = ConfigurationManager.this.getTargetedFactories(factoryPid, this.sr);
                    Set<String> pids = ConfigurationManager.this.persistenceManager.getFactoryConfigurationPids(targetedFactoryPids);
                    for (String pid : pids) {
                        ConfigurationImpl cfg;
                        try {
                            cfg = ConfigurationManager.this.getConfiguration(pid);
                        }
                        catch (IOException ioe) {
                            Log.logger.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                            continue;
                        }
                        if (cfg == null) {
                            Log.logger.log(1, "Configuration {0} referred to by factory {1} does not exist", new Object[]{pid, factoryPid});
                            continue;
                        }
                        if (cfg.isNew()) {
                            Log.logger.log(1, "Ignoring new configuration pid={0}", new Object[]{pid});
                            continue;
                        }
                        this.provide(factoryPid, cfg);
                    }
                }
                catch (IOException ioe) {
                    Log.logger.log(1, "Cannot get factory mapping for factory PID {0}", new Object[]{factoryPid, ioe});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provide(String factoryPid, ConfigurationImpl config) {
            long revision;
            Dictionary<String, Object> rawProperties;
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                rawProperties = config.getProperties(true);
                revision = config.getRevision();
            }
            Log.logger.log(4, "Updating service {0} with configuration {1}/{2}@{3}", new Object[]{factoryPid, config.getFactoryPid(), config.getPid(), new Long(revision)});
            Bundle serviceBundle = this.sr.getBundle();
            if (serviceBundle == null) {
                Log.logger.log(3, "ManagedServiceFactory for factory PID {0} seems to already have been unregistered, not updating with factory", new Object[]{factoryPid});
                return;
            }
            if (!ConfigurationManager.this.canReceive(serviceBundle, config.getBundleLocation())) {
                Log.logger.log(1, "Cannot use configuration {0} for {1}: No visibility to configuration bound to {2}", new Object[]{config.getPid(), this.sr, config.getBundleLocation()});
                return;
            }
            config.tryBindLocation(serviceBundle.getLocation());
            if (rawProperties != null) {
                Log.logger.log(4, "{0}: Updating configuration pid={1}", new Object[]{this.sr, config.getPid()});
                ConfigurationManager.this.managedServiceFactoryTracker.provideConfiguration(this.sr, config.getPid(), config.getFactoryPid(), (Dictionary<String, ?>)rawProperties, revision, this.configs);
            }
        }

        public String toString() {
            return "ManagedServiceFactory Update: factoryPid=" + Arrays.asList(this.factoryPids);
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private final String[] pids;
        private final ServiceReference<ManagedService> sr;
        private final ConfigurationMap<?> configs;

        ManagedServiceUpdate(String[] pids, ServiceReference<ManagedService> sr, ConfigurationMap<?> configs) {
            this.pids = pids;
            this.sr = sr;
            this.configs = configs;
        }

        @Override
        public void run() {
            for (String pid : this.pids) {
                try {
                    ConfigurationImpl config = ConfigurationManager.this.getTargetedConfiguration(pid, this.sr);
                    this.provide(pid, config);
                }
                catch (IOException ioe) {
                    Log.logger.log(1, "Error loading configuration for {0}", new Object[]{pid, ioe});
                }
                catch (Exception e) {
                    Log.logger.log(1, "Unexpected problem providing configuration {0} to service {1}", new Object[]{pid, this.sr, e});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provide(String servicePid, ConfigurationImpl config) {
            long revision;
            Dictionary<String, Object> properties;
            TargetedPID configPid;
            if (config != null) {
                ConfigurationImpl configurationImpl = config;
                synchronized (configurationImpl) {
                    configPid = config.getPid();
                    properties = config.getProperties(true);
                    revision = config.getRevision();
                }
            } else {
                configPid = new TargetedPID(servicePid);
                properties = null;
                revision = -1L;
            }
            Log.logger.log(4, "Updating service {0} with configuration {1}@{2}", new Object[]{servicePid, configPid, new Long(revision)});
            ConfigurationManager.this.managedServiceTracker.provideConfiguration(this.sr, configPid, (TargetedPID)null, (Dictionary<String, ?>)properties, revision, this.configs);
        }

        public String toString() {
            return "ManagedService Update: pid=" + Arrays.asList(this.pids);
        }
    }
}

