/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features;

import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.DeploymentListener;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.Repository;

public interface FeaturesService {
    public static final String ROOT_REGION = "root";
    public static final SnapshotUpdateBehavior DEFAULT_UPDATE_SNAPSHOTS = SnapshotUpdateBehavior.Crc;
    public static final String DEFAULT_FEATURE_RESOLUTION_RANGE = "${range;[====,====]}";
    public static final String DEFAULT_BUNDLE_UPDATE_RANGE = "${range;[==,=+)}";
    public static final String UPDATEABLE_URIS = "mvn:.*SNAPSHOT|(?!mvn:).*";
    public static final int DEFAULT_DOWNLOAD_THREADS = 8;
    public static final long DEFAULT_SCHEDULE_DELAY = 250L;
    public static final int DEFAULT_SCHEDULE_MAX_RUN = 9;
    public static final long DEFAULT_REPOSITORY_EXPIRATION = 60000L;
    public static final boolean DEFAULT_CONFIG_CFG_STORE = true;
    public static final boolean DEFAULT_DIGRAPH_MBEAN = true;

    public void validateRepository(URI var1) throws Exception;

    public boolean isRepositoryUriBlacklisted(URI var1);

    public void addRepository(URI var1) throws Exception;

    public void addRepository(URI var1, boolean var2) throws Exception;

    public void removeRepository(URI var1) throws Exception;

    public void removeRepository(URI var1, boolean var2) throws Exception;

    public void restoreRepository(URI var1) throws Exception;

    public Repository[] listRequiredRepositories() throws Exception;

    public Repository[] listRepositories() throws Exception;

    public Repository getRepository(String var1) throws Exception;

    public Repository getRepository(URI var1) throws Exception;

    public String getRepositoryName(URI var1) throws Exception;

    public void setResolutionOutputFile(String var1);

    public void installFeature(String var1) throws Exception;

    public void installFeature(String var1, EnumSet<Option> var2) throws Exception;

    public void installFeature(String var1, String var2) throws Exception;

    public void installFeature(String var1, String var2, EnumSet<Option> var3) throws Exception;

    public void installFeature(Feature var1, EnumSet<Option> var2) throws Exception;

    public void installFeatures(Set<String> var1, EnumSet<Option> var2) throws Exception;

    public void installFeatures(Set<String> var1, String var2, EnumSet<Option> var3) throws Exception;

    public void addRequirements(Map<String, Set<String>> var1, EnumSet<Option> var2) throws Exception;

    public void uninstallFeature(String var1, EnumSet<Option> var2) throws Exception;

    public void uninstallFeature(String var1) throws Exception;

    public void uninstallFeature(String var1, String var2, EnumSet<Option> var3) throws Exception;

    public void uninstallFeature(String var1, String var2) throws Exception;

    public void uninstallFeatures(Set<String> var1, EnumSet<Option> var2) throws Exception;

    public void uninstallFeatures(Set<String> var1, String var2, EnumSet<Option> var3) throws Exception;

    public void removeRequirements(Map<String, Set<String>> var1, EnumSet<Option> var2) throws Exception;

    public void updateFeaturesState(Map<String, Map<String, FeatureState>> var1, EnumSet<Option> var2) throws Exception;

    public void updateReposAndRequirements(Set<URI> var1, Map<String, Set<String>> var2, EnumSet<Option> var3) throws Exception;

    public Repository createRepository(URI var1) throws Exception;

    public Feature[] listFeatures() throws Exception;

    public Feature[] listRequiredFeatures() throws Exception;

    public Feature[] listInstalledFeatures() throws Exception;

    public Map<String, Set<String>> listRequirements();

    public boolean isRequired(Feature var1);

    public boolean isInstalled(Feature var1);

    public Feature getFeature(String var1, String var2) throws Exception;

    public Feature getFeature(String var1) throws Exception;

    public Feature[] getFeatures(String var1, String var2) throws Exception;

    public Feature[] getFeatures(String var1) throws Exception;

    public void refreshRepositories(Set<URI> var1) throws Exception;

    public void refreshRepository(URI var1) throws Exception;

    public URI getRepositoryUriFor(String var1, String var2);

    public String[] getRepositoryNames();

    public void registerListener(FeaturesListener var1);

    public void unregisterListener(FeaturesListener var1);

    public void registerListener(DeploymentListener var1);

    public void unregisterListener(DeploymentListener var1);

    public FeatureState getState(String var1);

    public String getFeatureXml(Feature var1);

    public void refreshFeatures(EnumSet<Option> var1) throws Exception;

    public static enum SnapshotUpdateBehavior {
        None("none"),
        Crc("crc"),
        Always("always");

        private String value;

        private SnapshotUpdateBehavior(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotUpdateBehavior fromString(String updateSnapshots) {
            return Arrays.stream(SnapshotUpdateBehavior.values()).filter(sub -> sub.value.equals(updateSnapshots)).findFirst().orElse(Crc);
        }
    }

    public static enum ServiceRequirementsBehavior {
        Disable("disable"),
        Default("default"),
        Enforce("enforce");

        private String value;

        private ServiceRequirementsBehavior(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ServiceRequirementsBehavior fromString(String serviceRequirements) {
            return Arrays.stream(ServiceRequirementsBehavior.values()).filter(sub -> sub.value.equalsIgnoreCase(serviceRequirements)).findFirst().orElse(Default);
        }
    }

    public static enum Option {
        NoFailOnFeatureNotFound,
        NoAutoRefreshManagedBundles,
        NoAutoRefreshUnmanagedBundles,
        NoAutoRefreshBundles,
        NoAutoStartBundles,
        NoAutoManageBundles,
        Simulate,
        Verbose,
        Upgrade,
        DisplayFeaturesWiring,
        DisplayAllWiring;

    }
}

