/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;

public class FileHandle
extends Handle {
    private final int access;
    private final SeekableByteChannel fileChannel;
    private final List<FileLock> locks = new ArrayList<FileLock>();
    private final Set<StandardOpenOption> openOptions;
    private final Collection<FileAttribute<?>> fileAttributes;

    public FileHandle(SftpSubsystem subsystem, Path file, String handle, int flags, int access, Map<String, Object> attrs) throws IOException {
        super(subsystem, file, handle);
        SeekableByteChannel channel;
        this.access = access;
        this.openOptions = Collections.unmodifiableSet(FileHandle.getOpenOptions(flags, access));
        this.fileAttributes = Collections.unmodifiableCollection(FileHandle.toFileAttributes(attrs));
        this.signalHandleOpening();
        FileAttribute[] fileAttrs = GenericUtils.isEmpty(this.fileAttributes) ? IoUtils.EMPTY_FILE_ATTRIBUTES : this.fileAttributes.toArray(new FileAttribute[this.fileAttributes.size()]);
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        ServerSession session = subsystem.getServerSession();
        try {
            channel = accessor.openFile(session, subsystem, this, file, handle, this.openOptions, fileAttrs);
        }
        catch (UnsupportedOperationException e) {
            channel = accessor.openFile(session, subsystem, this, file, handle, this.openOptions, IoUtils.EMPTY_FILE_ATTRIBUTES);
            subsystem.doSetAttributes(file, attrs, false);
        }
        this.fileChannel = channel;
        try {
            this.signalHandleOpen();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public final Set<StandardOpenOption> getOpenOptions() {
        return this.openOptions;
    }

    public final Collection<FileAttribute<?>> getFileAttributes() {
        return this.fileAttributes;
    }

    public SeekableByteChannel getFileChannel() {
        return this.fileChannel;
    }

    public int getAccessMask() {
        return this.access;
    }

    public boolean isOpenAppend() {
        return 4 == (this.getAccessMask() & 4);
    }

    public int read(byte[] data, long offset) throws IOException {
        return this.read(data, 0, data.length, offset);
    }

    public int read(byte[] data, int doff, int length, long offset) throws IOException {
        SeekableByteChannel channel = this.getFileChannel();
        channel = channel.position(offset);
        return channel.read(ByteBuffer.wrap(data, doff, length));
    }

    public void append(byte[] data) throws IOException {
        this.append(data, 0, data.length);
    }

    public void append(byte[] data, int doff, int length) throws IOException {
        SeekableByteChannel channel = this.getFileChannel();
        this.write(data, doff, length, channel.size());
    }

    public void write(byte[] data, long offset) throws IOException {
        this.write(data, 0, data.length, offset);
    }

    public void write(byte[] data, int doff, int length, long offset) throws IOException {
        SeekableByteChannel channel = this.getFileChannel();
        channel = channel.position(offset);
        channel.write(ByteBuffer.wrap(data, doff, length));
    }

    @Override
    public void close() throws IOException {
        super.close();
        SftpSubsystem subsystem = this.getSubsystem();
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        ServerSession session = subsystem.getServerSession();
        accessor.closeFile(session, subsystem, this, this.getFile(), this.getFileHandle(), this.getFileChannel(), this.getOpenOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(long offset, long length, int mask) throws IOException {
        ServerSession session;
        SeekableByteChannel channel = this.getFileChannel();
        long size = length == 0L ? channel.size() - offset : length;
        SftpSubsystem subsystem = this.getSubsystem();
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        FileLock lock = accessor.tryLock(session = subsystem.getServerSession(), subsystem, this, this.getFile(), this.getFileHandle(), channel, offset, size, false);
        if (lock == null) {
            throw new SftpException(26, "Overlapping lock held by another program on range [" + offset + "-" + (offset + length));
        }
        List<FileLock> list = this.locks;
        synchronized (list) {
            this.locks.add(lock);
        }
    }

    public void unlock(long offset, long length) throws IOException {
        SeekableByteChannel channel = this.getFileChannel();
        long size = length == 0L ? channel.size() - offset : length;
        FileLock lock = null;
        Iterator<FileLock> iterator = this.locks.iterator();
        while (iterator.hasNext()) {
            FileLock l = iterator.next();
            if (l.position() != offset || l.size() != size) continue;
            iterator.remove();
            lock = l;
            break;
        }
        if (lock == null) {
            throw new SftpException(31, "No matching lock found on range [" + offset + "-" + (offset + length));
        }
        lock.release();
    }

    public static Collection<FileAttribute<?>> toFileAttributes(Map<String, ?> attrs) {
        if (GenericUtils.isEmpty(attrs)) {
            return Collections.emptyList();
        }
        LinkedList attributes = null;
        for (Map.Entry<String, ?> attr : attrs.entrySet()) {
            FileAttribute<?> fileAttr = FileHandle.toFileAttribute(attr.getKey(), attr.getValue());
            if (fileAttr == null) continue;
            if (attributes == null) {
                attributes = new LinkedList();
            }
            attributes.add(fileAttr);
        }
        return attributes == null ? Collections.emptyList() : attributes;
    }

    public static FileAttribute<?> toFileAttribute(final String key, final Object val) {
        if ("isOther".equals(key)) {
            if (((Boolean)val).booleanValue()) {
                throw new IllegalArgumentException("Not allowed to use " + key + "=" + val);
            }
            return null;
        }
        if ("isRegular".equals(key)) {
            if (!((Boolean)val).booleanValue()) {
                throw new IllegalArgumentException("Not allowed to use " + key + "=" + val);
            }
            return null;
        }
        return new FileAttribute<Object>(){
            private final String s;
            {
                this.s = key + "=" + val;
            }

            @Override
            public String name() {
                return key;
            }

            @Override
            public Object value() {
                return val;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static Set<StandardOpenOption> getOpenOptions(int flags, int access) {
        EnumSet<StandardOpenOption> options = EnumSet.noneOf(StandardOpenOption.class);
        if ((access & 1) != 0 || (access & 0x80) != 0) {
            options.add(StandardOpenOption.READ);
        }
        if ((access & 2) != 0 || (access & 0x100) != 0) {
            options.add(StandardOpenOption.WRITE);
        }
        int accessDisposition = flags & 7;
        switch (accessDisposition) {
            case 0: {
                options.add(StandardOpenOption.CREATE_NEW);
                break;
            }
            case 1: {
                options.add(StandardOpenOption.CREATE);
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                options.add(StandardOpenOption.CREATE);
                break;
            }
            case 4: {
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
        }
        if ((flags & 8) != 0) {
            options.add(StandardOpenOption.APPEND);
        }
        return options;
    }
}

