/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.karaf.shell.api.action.lifecycle.Manager;
import org.apache.karaf.shell.api.console.CommandLoggingFilter;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.ssh.KarafAgentFactory;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.ShellCommand;
import org.apache.karaf.shell.ssh.ShellFactoryImpl;
import org.apache.karaf.shell.ssh.SshAction;
import org.apache.karaf.shell.ssh.SshUtils;
import org.apache.karaf.shell.ssh.UserAuthFactoriesFactory;
import org.apache.karaf.shell.ssh.keygenerator.OpenSSHKeyPairProvider;
import org.apache.karaf.shell.support.RegexCommandLoggingFilter;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=SessionFactory.class)})
@Managed(value="org.apache.karaf.shell")
public class Activator
extends BaseActivator
implements ManagedService {
    static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    ServiceTracker<Session, Session> sessionTracker;
    SessionFactory sessionFactory;
    SshServer server;

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        this.sessionTracker = new ServiceTracker<Session, Session>(this.bundleContext, Session.class, null){

            public Session addingService(ServiceReference<Session> reference) {
                Session session = (Session)super.addingService(reference);
                KarafAgentFactory.getInstance().registerSession(session);
                return session;
            }

            public void removedService(ServiceReference<Session> reference, Session session) {
                KarafAgentFactory.getInstance().unregisterSession(session);
                super.removedService(reference, (Object)session);
            }
        };
        this.sessionTracker.open();
    }

    @Override
    protected void doClose() {
        this.sessionTracker.close();
        super.doClose();
    }

    @Override
    protected void doStart() throws Exception {
        SessionFactory sf = this.getTrackedService(SessionFactory.class);
        if (sf == null) {
            return;
        }
        RegexCommandLoggingFilter filter = new RegexCommandLoggingFilter();
        filter.setPattern("ssh (.*?)-P +([^ ]+)");
        filter.setGroup(2);
        this.register(CommandLoggingFilter.class, filter);
        filter = new RegexCommandLoggingFilter();
        filter.setPattern("ssh (.*?)--password +([^ ]+)");
        filter.setGroup(2);
        this.register(CommandLoggingFilter.class, filter);
        this.sessionFactory = sf;
        ((Manager)this.sessionFactory.getRegistry().getService(Manager.class)).register(SshAction.class);
        if (Boolean.parseBoolean(this.bundleContext.getProperty("karaf.startRemoteShell"))) {
            this.createAndRunSshServer();
        }
    }

    private void createAndRunSshServer() {
        this.server = this.createSshServer(this.sessionFactory);
        this.bundleContext.registerService(SshServer.class, (Object)this.server, null);
        if (this.server == null) {
            return;
        }
        try {
            this.server.start();
        }
        catch (IOException e) {
            LOGGER.warn("Exception caught while starting SSH server", (Throwable)e);
        }
    }

    @Override
    protected void doStop() {
        if (this.sessionFactory != null) {
            ((Manager)this.sessionFactory.getRegistry().getService(Manager.class)).unregister(SshAction.class);
            this.sessionFactory = null;
        }
        if (this.server != null) {
            try {
                this.server.stop(true);
            }
            catch (IOException e) {
                LOGGER.warn("Exception caught while stopping SSH server", (Throwable)e);
            }
            this.server = null;
        }
        super.doStop();
    }

    protected SshServer createSshServer(SessionFactory sessionFactory) {
        int sshPort = this.getInt("sshPort", 8101);
        String sshHost = this.getString("sshHost", "0.0.0.0");
        long sshIdleTimeout = this.getLong("sshIdleTimeout", 1800000L);
        int nioWorkers = this.getInt("nio-workers", 2);
        int maxConcurrentSessions = this.getInt("max-concurrent-sessions", -1);
        String sshRealm = this.getString("sshRealm", "karaf");
        Class<?>[] roleClasses = this.getClassesArray("sshRoleTypes", "org.apache.karaf.jaas.boot.principal.RolePrincipal");
        String sshRole = this.getString("sshRole", null);
        String hostKey = this.getString("hostKey", System.getProperty("karaf.etc") + "/host.key");
        String[] authMethods = this.getStringArray("authMethods", "keyboard-interactive,password,publickey");
        int keySize = this.getInt("keySize", 2048);
        String algorithm = this.getString("algorithm", "RSA");
        String[] macs = this.getStringArray("macs", "hmac-sha2-512,hmac-sha2-256,hmac-sha1");
        String[] ciphers = this.getStringArray("ciphers", "aes128-ctr,arcfour128,aes128-cbc,3des-cbc,blowfish-cbc");
        String[] kexAlgorithms = this.getStringArray("kexAlgorithms", "diffie-hellman-group-exchange-sha256,ecdh-sha2-nistp521,ecdh-sha2-nistp384,ecdh-sha2-nistp256,diffie-hellman-group-exchange-sha1,diffie-hellman-group1-sha1");
        String welcomeBanner = this.getString("welcomeBanner", null);
        String moduliUrl = this.getString("moduli-url", null);
        boolean sftpEnabled = this.getBoolean("sftpEnabled", true);
        Path serverKeyPath = Paths.get(hostKey, new String[0]);
        OpenSSHKeyPairProvider keyPairProvider = new OpenSSHKeyPairProvider(serverKeyPath.toFile(), algorithm, keySize);
        KarafJaasAuthenticator authenticator = new KarafJaasAuthenticator(sshRealm, sshRole, roleClasses);
        UserAuthFactoriesFactory authFactoriesFactory = new UserAuthFactoriesFactory();
        authFactoriesFactory.setAuthMethods(authMethods);
        SshServer server = SshServer.setUpDefaultServer();
        server.setPort(sshPort);
        server.setHost(sshHost);
        server.setMacFactories(SshUtils.buildMacs(macs));
        server.setCipherFactories(SshUtils.buildCiphers(ciphers));
        server.setKeyExchangeFactories(SshUtils.buildKexAlgorithms(kexAlgorithms));
        server.setShellFactory((Factory)new ShellFactoryImpl(sessionFactory));
        if (sftpEnabled) {
            server.setCommandFactory((CommandFactory)new ScpCommandFactory.Builder().withDelegate(cmd -> new ShellCommand(sessionFactory, cmd)).build());
            server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
            server.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(Paths.get(System.getProperty("karaf.base"), new String[0])));
        } else {
            server.setCommandFactory(cmd -> new ShellCommand(sessionFactory, cmd));
        }
        server.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        server.setPasswordAuthenticator((PasswordAuthenticator)authenticator);
        server.setPublickeyAuthenticator((PublickeyAuthenticator)authenticator);
        server.setUserAuthFactories(authFactoriesFactory.getFactories());
        server.setAgentFactory((SshAgentFactory)KarafAgentFactory.getInstance());
        server.setForwardingFilter((ForwardingFilter)AcceptAllForwardingFilter.INSTANCE);
        server.getProperties().put("idle-timeout", Long.toString(sshIdleTimeout));
        server.getProperties().put("nio-workers", Integer.toString(nioWorkers));
        if (maxConcurrentSessions != -1) {
            server.getProperties().put("max-concurrent-sessions", Integer.toString(maxConcurrentSessions));
        }
        if (moduliUrl != null) {
            server.getProperties().put("moduli-url", moduliUrl);
        }
        if (welcomeBanner != null) {
            server.getProperties().put("welcome-banner", welcomeBanner);
        }
        return server;
    }
}

