/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework.wiring;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.framework.wiring.BundleWiringState;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.apache.aries.jmx.util.shared.RegistrableStandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;

public class BundleWiringStateMBeanHandler
implements MBeanHandler {
    private JMXAgentContext agentContext;
    private final String name;
    private final BundleContext bundleContext;
    private final Logger logger;
    private StandardMBean mbean;
    private BundleWiringState revisionsStateMBean;

    public BundleWiringStateMBeanHandler(JMXAgentContext agentContext) {
        this.agentContext = agentContext;
        this.bundleContext = agentContext.getBundleContext();
        this.logger = agentContext.getLogger();
        this.name = ObjectNameUtils.createFullObjectName(this.bundleContext, "osgi.core:type=wiringState,version=1.1");
    }

    @Override
    public void open() {
        this.revisionsStateMBean = new BundleWiringState(this.bundleContext, this.logger);
        try {
            this.mbean = new RegistrableStandardEmitterMBean(this.revisionsStateMBean, BundleWiringStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(1, "Failed to instantiate MBean for " + BundleWiringStateMBean.class.getName(), e);
        }
        this.agentContext.registerMBean(this);
    }

    @Override
    public StandardMBean getMbean() {
        return this.mbean;
    }

    @Override
    public void close() {
        this.agentContext.unregisterMBean(this);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

