/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.maven;

import java.net.MalformedURLException;
import java.util.Map;

public class Parser {
    public static final String VERSION_LATEST = "LATEST";
    private static final String SYNTAX = "mvn:[repository_url!]groupId/artifactId[/[version]/[type]]";
    private static final String REPOSITORY_SEPARATOR = "!";
    private static final String ARTIFACT_SEPARATOR = "/";
    private static final String VERSION_SNAPSHOT = "SNAPSHOT";
    private static final String TYPE_JAR = "jar";
    public static final String FILE_SEPARATOR = "/";
    private static final String GROUP_SEPARATOR = "\\.";
    private static final String VERSION_SEPARATOR = "-";
    private static final String TYPE_SEPARATOR = ".";
    private static final String CLASSIFIER_SEPARATOR = "-";
    private static final String METADATA_FILE = "maven-metadata.xml";
    private static final String METADATA_FILE_LOCAL = "maven-metadata-local.xml";
    private String m_repositoryURL;
    private String m_group;
    private String m_artifact;
    private String m_version;
    private String m_type;
    private String m_classifier;
    private String m_fullClassifier;

    public Parser(String path) throws MalformedURLException {
        if (path == null) {
            throw new MalformedURLException("Path cannot be null. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (path.startsWith(REPOSITORY_SEPARATOR) || path.endsWith(REPOSITORY_SEPARATOR)) {
            throw new MalformedURLException("Path cannot start or end with !. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (path.contains(REPOSITORY_SEPARATOR)) {
            int pos = path.lastIndexOf(REPOSITORY_SEPARATOR);
            this.parseArtifactPart(path.substring(pos + 1));
            this.m_repositoryURL = path.substring(0, pos) + "@snapshots";
        } else {
            this.parseArtifactPart(path);
        }
    }

    public static String pathFromMaven(String uri) throws MalformedURLException {
        return Parser.pathFromMaven(uri, null);
    }

    public static String pathFromMaven(String uri, String resolved) throws MalformedURLException {
        String grp;
        int idx;
        if (!uri.startsWith("mvn:")) {
            return uri;
        }
        Parser parser = new Parser(uri.substring("mvn:".length()));
        if (resolved != null && (idx = resolved.indexOf(grp = "/" + parser.getGroup().replaceAll(GROUP_SEPARATOR, "/") + "/" + parser.getArtifact() + "/")) >= 0) {
            String version = resolved.substring(idx + grp.length(), resolved.indexOf(47, idx + grp.length()));
            return parser.getArtifactPath(version);
        }
        return parser.getArtifactPath();
    }

    public static String pathToMaven(String location, Map parts) {
        String[] p = location.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuilder sb = new StringBuilder();
            String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
            String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
            sb.append("mvn:");
            if (parts != null) {
                parts.put("artifactId", artifactId);
                parts.put("version", version);
                parts.put("classifier", classifier);
                parts.put("type", type);
            }
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append('/').append(artifactId).append('/').append(version);
            if (!TYPE_JAR.equals(type) || classifier != null) {
                sb.append('/');
                if (!TYPE_JAR.equals(type)) {
                    sb.append(type);
                }
                if (classifier != null) {
                    sb.append('/').append(classifier);
                }
            }
            return sb.toString();
        }
        return location;
    }

    public static String pathToMaven(String location) {
        return Parser.pathToMaven(location, null);
    }

    private void parseArtifactPart(String part) throws MalformedURLException {
        String[] segments = part.split("/");
        if (segments.length < 2) {
            throw new MalformedURLException("Invalid path. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_group = segments[0];
        if (this.m_group.trim().length() == 0) {
            throw new MalformedURLException("Invalid groupId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_artifact = segments[1];
        if (this.m_artifact.trim().length() == 0) {
            throw new MalformedURLException("Invalid artifactId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_version = VERSION_LATEST;
        if (segments.length >= 3 && segments[2].trim().length() > 0) {
            this.m_version = segments[2];
        }
        this.m_type = TYPE_JAR;
        if (segments.length >= 4 && segments[3].trim().length() > 0) {
            this.m_type = segments[3];
        }
        this.m_fullClassifier = "";
        if (segments.length >= 5 && segments[4].trim().length() > 0) {
            this.m_classifier = segments[4];
            this.m_fullClassifier = "-" + this.m_classifier;
        }
    }

    public String getRepositoryURL() {
        return this.m_repositoryURL;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getArtifact() {
        return this.m_artifact;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getType() {
        return this.m_type;
    }

    public String getClassifier() {
        return this.m_classifier;
    }

    public String getArtifactPath() {
        return this.getArtifactPath(this.m_version);
    }

    public String getArtifactPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + this.m_artifact + "-" + version + this.m_fullClassifier + TYPE_SEPARATOR + this.m_type;
    }

    public String getSnapshotVersion(String version, String timestamp, String buildnumber) {
        return version.replace(VERSION_SNAPSHOT, timestamp) + "-" + buildnumber;
    }

    public String getSnapshotPath(String version, String timestamp, String buildnumber) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + this.m_artifact + "-" + this.getSnapshotVersion(version, timestamp, buildnumber) + this.m_fullClassifier + TYPE_SEPARATOR + this.m_type;
    }

    public String getVersionMetadataPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + METADATA_FILE;
    }

    public String getVersionLocalMetadataPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactLocalMetdataPath() {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactMetdataPath() {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + METADATA_FILE;
    }
}

