/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.locks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.apache.felix.utils.properties.TypedProperties;

public final class FileLockUtils {
    private FileLockUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(File file, Runnable<? super RandomAccessFile> callback) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            FileLock lock = raf.getChannel().lock();
            try {
                callback.run(raf);
            }
            finally {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(File file, Callable<? super RandomAccessFile, T> callback) throws IOException {
        Throwable throwable = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            T t;
            FileLock lock = raf.getChannel().lock();
            try {
                t = callback.call(raf);
            }
            catch (Throwable throwable2) {
                try {
                    lock.release();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            lock.release();
            return t;
        }
    }

    public static void execute(File file, Runnable<? super TypedProperties> callback, boolean writeToFile) throws IOException {
        FileLockUtils.execute(file, (? super RandomAccessFile raf) -> {
            TypedProperties props = FileLockUtils.load(raf);
            callback.run(props);
            if (writeToFile) {
                FileLockUtils.save(props, raf);
            }
        });
    }

    public static <T> T execute(File file, Callable<? super TypedProperties, T> callback, boolean writeToFile) throws IOException {
        return (T)FileLockUtils.execute(file, (? super RandomAccessFile raf) -> {
            TypedProperties props = FileLockUtils.load(raf);
            Object result = callback.call(props);
            if (writeToFile) {
                FileLockUtils.save(props, raf);
            }
            return result;
        });
    }

    private static TypedProperties load(RandomAccessFile raf) throws IOException {
        byte[] buffer = new byte[(int)raf.length()];
        raf.readFully(buffer);
        TypedProperties props = new TypedProperties();
        props.load(new ByteArrayInputStream(buffer));
        return props;
    }

    private static void save(TypedProperties props, RandomAccessFile raf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.save(baos);
        raf.setLength(0L);
        raf.write(baos.toByteArray());
    }

    public static interface Callable<T, U> {
        public U call(T var1) throws IOException;
    }

    public static interface Runnable<T> {
        public void run(T var1) throws IOException;
    }
}

