/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

public class PropertiesLoader {
    private static final String INCLUDES_PROPERTY = "${includes}";
    private static final String OPTIONALS_PROPERTY = "${optionals}";
    private static final String OVERRIDE_PREFIX = "karaf.override.";

    public static Properties loadConfigProperties(File file) throws Exception {
        URL configPropURL;
        try {
            configPropURL = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties configProps = PropertiesLoader.loadPropertiesFile(configPropURL, false);
        PropertiesLoader.copySystemProperties(configProps);
        configProps.substitute();
        return configProps;
    }

    public static void loadSystemProperties(File file) throws IOException {
        Properties props = null;
        try {
            URL configPropURL = file.toURI().toURL();
            props = PropertiesLoader.loadPropertiesFile(configPropURL, true);
        }
        catch (Exception ex) {
            return;
        }
        Enumeration e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith(OVERRIDE_PREFIX)) {
                String overrideName = name.substring(OVERRIDE_PREFIX.length());
                String value = props.getProperty(name);
                System.setProperty(overrideName, InterpolationHelper.substVars((String)value, (String)name, null, (Map)props));
                continue;
            }
            String value = System.getProperty(name, props.getProperty(name));
            System.setProperty(name, InterpolationHelper.substVars((String)value, (String)name, null, (Map)props));
        }
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("karaf.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    public static Properties loadPropertiesOrFail(File configFile) {
        try {
            URL configPropURL = configFile.toURI().toURL();
            return PropertiesLoader.loadPropertiesFile(configPropURL, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading properties from " + configFile, e);
        }
    }

    public static Properties loadPropertiesFile(URL configPropURL, boolean failIfNotFound) throws Exception {
        Properties configProps = new Properties(null, false);
        try {
            configProps.load(configPropURL);
        }
        catch (FileNotFoundException ex) {
            if (failIfNotFound) {
                throw ex;
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            return configProps;
        }
        PropertiesLoader.loadIncludes(INCLUDES_PROPERTY, true, configPropURL, configProps);
        PropertiesLoader.loadIncludes(OPTIONALS_PROPERTY, false, configPropURL, configProps);
        PropertiesLoader.trimValues(configProps);
        return configProps;
    }

    private static void loadIncludes(String propertyName, boolean mandatory, URL configPropURL, Properties configProps) throws Exception {
        StringTokenizer st;
        String includes = (String)configProps.get((Object)propertyName);
        if (includes != null && (st = new StringTokenizer(includes, "\" ", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = PropertiesLoader.nextLocation(st)) == null) continue;
                URL url = new URL(configPropURL, location);
                Properties props = PropertiesLoader.loadPropertiesFile(url, mandatory);
                configProps.putAll((Map)props);
            } while (location != null);
        }
        configProps.remove((Object)propertyName);
    }

    private static void trimValues(Properties configProps) {
        for (String key : configProps.keySet()) {
            configProps.put(key, ((String)configProps.get((Object)key)).trim());
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            block8: while (st.hasMoreTokens() && !exit) {
                String tok;
                switch (tok = st.nextToken(tokenList)) {
                    case "\"": {
                        boolean bl = inQuote = !inQuote;
                        if (inQuote) {
                            tokenList = "\"";
                            continue block8;
                        }
                        tokenList = "\" ";
                        continue block8;
                    }
                    case " ": {
                        if (!tokStarted) continue block8;
                        retVal = tokBuf.toString();
                        tokStarted = false;
                        tokBuf = new StringBuffer(10);
                        exit = true;
                        continue block8;
                    }
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }
}

