/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.internal.Parser;

public class ReactorMavenResolver
implements MavenResolver {
    private final WorkspaceReader reactor;
    private final MavenResolver fallback;

    public ReactorMavenResolver(WorkspaceReader reactor, MavenResolver fallback) {
        this.reactor = reactor;
        this.fallback = fallback;
    }

    private Artifact toArtifact(String url) throws MalformedURLException {
        if (url.startsWith("mvn:")) {
            url = url.substring(4);
        }
        Parser parser = new Parser(url);
        return new DefaultArtifact(parser.getGroup(), parser.getArtifact(), parser.getClassifier(), parser.getType(), parser.getVersion());
    }

    public File resolve(String url) throws IOException {
        Artifact artifact = this.toArtifact(url);
        File file = this.reactor.findArtifact(artifact);
        return file == null ? this.fallback.resolve(url) : file;
    }

    public File resolve(String url, Exception previousException) throws IOException {
        Artifact artifact = this.toArtifact(url);
        File file = this.reactor.findArtifact(artifact);
        return file == null ? this.fallback.resolve(url, previousException) : file;
    }

    public File resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        File file = this.reactor.findArtifact((Artifact)new DefaultArtifact(groupId, artifactId, classifier, extension, version));
        return file == null ? this.fallback.resolve(String.format("mvn:%s/%s/%s/%s/%s", groupId, artifactId, version, extension, classifier)) : file;
    }

    public File resolve(String groupId, String artifactId, String classifier, String extension, String version, Exception previousException) throws IOException {
        File file = this.reactor.findArtifact((Artifact)new DefaultArtifact(groupId, artifactId, classifier, extension, version));
        return file == null ? this.fallback.resolve(String.format("mvn:%s/%s/%s/%s/%s", groupId, artifactId, version, extension, classifier), previousException) : file;
    }

    public File resolveMetadata(String groupId, String artifactId, String type, String version) throws IOException {
        return this.fallback.resolveMetadata(groupId, artifactId, type, version);
    }

    public File resolveMetadata(String groupId, String artifactId, String type, String version, Exception previousException) throws IOException {
        return this.fallback.resolveMetadata(groupId, artifactId, type, version, previousException);
    }

    public void upload(String groupId, String artifactId, String classifier, String extension, String version, File artifact) throws IOException {
        this.fallback.upload(groupId, artifactId, classifier, extension, version, artifact);
    }

    public void uploadMetadata(String groupId, String artifactId, String type, String version, File artifact) throws IOException {
        this.fallback.uploadMetadata(groupId, artifactId, type, version, artifact);
    }

    public MavenResolver.RetryChance isRetryableException(Exception exception) {
        return this.fallback.isRetryableException(exception);
    }

    public void close() throws IOException {
        this.fallback.close();
    }
}

