/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoFailureException;

public enum FormatEnum {
    ASCIIDOC("asciidoc", "adoc"),
    DOCBX("docbx", "xml"),
    CONF("conf", "conf"),
    MARKDOWN("markdown", "md");

    private static final Map<String, FormatEnum> FORMAT_MAP;
    String format;
    String fileSuffix;

    private FormatEnum(String format, String fileSuffix) {
        this.format = format;
        this.fileSuffix = fileSuffix;
    }

    static FormatEnum fromString(String format) throws MojoFailureException {
        return Optional.ofNullable(FORMAT_MAP.get(format)).orElseThrow(() -> new MojoFailureException("Unsupported format: " + format + ". Supported formats are: " + FORMAT_MAP.keySet()));
    }

    static {
        FORMAT_MAP = Stream.of(FormatEnum.values()).collect(Collectors.toMap(formatEnum -> formatEnum.format, Function.identity()));
    }
}

