/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.token;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(TokenCache.class);
    private static final String DEFAULT_TOKEN_CACHE_PATH = ".tokenauth";
    private static final String TOKEN_CACHE_FILE = ".tokenauth.token";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readToken(String tokenCacheFile) {
        File cacheFile;
        if (tokenCacheFile != null && !tokenCacheFile.isEmpty()) {
            cacheFile = new File(tokenCacheFile);
            if (!cacheFile.exists()) {
                throw new RuntimeException("Invalid token cache specified: " + tokenCacheFile);
            }
        } else {
            cacheFile = TokenCache.getDefaultTokenCache();
            if (!cacheFile.exists()) {
                throw new RuntimeException("No token cache available by default");
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(cacheFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            LOG.error("Can't find the cache file. " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToken(String token) throws KrbException {
        File cacheFile = TokenCache.getDefaultTokenCache();
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding(cacheFile, StandardCharsets.UTF_8);
            writer.write(token);
            writer.flush();
            cacheFile.setReadable(false, false);
            cacheFile.setReadable(true, true);
            if (!cacheFile.setWritable(true, true)) {
                throw new KrbException("Cache file is not readable.");
            }
        }
        catch (IOException ioe) {
            if (cacheFile.delete()) {
                System.err.println("Cache file is deleted.");
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new KrbException(e.getMessage());
                }
            }
        }
    }

    public static File getDefaultTokenCache() {
        String homeDir = System.getProperty("user.home", DEFAULT_TOKEN_CACHE_PATH);
        return new File(homeDir, TOKEN_CACHE_FILE);
    }
}

