/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test;

import java.io.IOException;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;

public abstract class AppClient {
    private Transport.Connection conn;
    private boolean isTestOK = false;

    public AppClient(String[] args) throws Exception {
        this.usage(args);
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        this.conn = Transport.Connector.connect(hostName, port);
    }

    protected void usage(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java <options> AppClient <server-host> <server-port>");
            throw new RuntimeException("Arguments are invalid.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.withConnection(this.conn);
        }
        catch (Exception e) {
            System.err.println("Failed to connect. " + e.toString());
        }
        finally {
            try {
                this.conn.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close connection. " + e.toString());
            }
        }
    }

    protected abstract void withConnection(Transport.Connection var1) throws Exception;

    public boolean isTestOK() {
        return this.isTestOK;
    }

    protected synchronized void setTestOK(boolean isOK) {
        this.isTestOK = isOK;
    }
}

