/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test;

import java.io.IOException;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;

public abstract class AppServer
implements Runnable {
    protected Transport.Acceptor acceptor;
    private boolean terminated = false;

    public AppServer(String[] args) throws IOException {
        this.usage(args);
        int listenPort = Integer.parseInt(args[0]);
        this.acceptor = new Transport.Acceptor(listenPort);
    }

    protected void usage(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: AppServer <ListenPort>");
            throw new RuntimeException("Usage: AppServer <ListenPort>");
        }
    }

    public synchronized void start() {
        new Thread(this).start();
    }

    public synchronized void stop() {
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AppServer appServer = this;
            synchronized (appServer) {
                while (!this.terminated) {
                    this.runOnce();
                }
            }
        }
        finally {
            this.acceptor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce() {
        Transport.Connection conn = this.acceptor.accept();
        try {
            this.onConnection(conn);
        }
        catch (Exception e) {
            System.err.println("Failed to set onConnection. " + e.toString());
        }
        finally {
            try {
                conn.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close connection. " + e.toString());
            }
        }
    }

    protected abstract void onConnection(Transport.Connection var1) throws Exception;
}

