/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test.gss;

import java.nio.charset.StandardCharsets;
import org.apache.kerby.kerberos.kerb.integration.test.AppClient;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssAppClient
extends AppClient {
    private String clientPrincipal;
    private String serverPrincipal;
    private GSSManager manager;

    public GssAppClient(String[] args) throws Exception {
        super(args);
        this.clientPrincipal = args[2];
        this.serverPrincipal = args[3];
        this.manager = GSSManager.getInstance();
    }

    public static void main(String[] args) throws Exception {
        new GssAppClient(args).run();
    }

    @Override
    protected void usage(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: GssAppClient <server-host> <server-port> <client-principal> <server-principal> ");
            throw new RuntimeException("Usage: GssAppClient <server-host> <server-port> \"\n                    + \"<client-principal> <server-principal> ");
        }
    }

    @Override
    protected void withConnection(Transport.Connection conn) throws Exception {
        Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
        GSSName serverName = this.manager.createName(this.serverPrincipal, GSSName.NT_USER_NAME);
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSName clientName = this.manager.createName(this.clientPrincipal, GSSName.NT_USER_NAME);
        GSSCredential myCred = this.manager.createCredential(clientName, 0, oid, 1);
        GSSContext context = this.manager.createContext(serverName, krb5Oid, myCred, 0);
        context.requestMutualAuth(true);
        context.requestConf(true);
        context.requestInteg(true);
        byte[] token = new byte[]{};
        while (!context.isEstablished()) {
            if ((token = context.initSecContext(token, 0, token.length)) != null) {
                conn.sendToken(token);
            }
            if (context.isEstablished()) continue;
            token = conn.recvToken();
        }
        byte[] messageBytes = "Hello There!\u0000".getBytes(StandardCharsets.UTF_8);
        MessageProp prop = new MessageProp(0, true);
        token = context.wrap(messageBytes, 0, messageBytes.length, prop);
        conn.sendToken(token);
        token = conn.recvToken();
        context.verifyMIC(token, 0, token.length, messageBytes, 0, messageBytes.length, prop);
        this.setTestOK(true);
        context.dispose();
    }
}

