/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test.gss;

import org.apache.kerby.kerberos.kerb.integration.test.AppServer;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssAppServer
extends AppServer {
    private String serverPrincipal;
    private GSSManager manager;
    private GSSContext context;

    public GssAppServer(String[] args) throws Exception {
        super(args);
        if (args.length < 2) {
            this.usage(args);
        }
        this.serverPrincipal = args[1];
        this.manager = GSSManager.getInstance();
        GSSName gssService = this.manager.createName(this.serverPrincipal, GSSName.NT_USER_NAME);
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSCredential credentials = this.manager.createCredential(gssService, 0, oid, 2);
        this.context = this.manager.createContext(credentials);
    }

    public static void main(String[] args) throws Exception {
        new GssAppServer(args).run();
    }

    @Override
    protected void usage(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: AppServer <ListenPort> <server-principal>");
            throw new RuntimeException("Usage: AppServer <ListenPort> <server-principal>");
        }
    }

    @Override
    protected void onConnection(Transport.Connection conn) throws Exception {
        while (!this.context.isEstablished()) {
            byte[] token = conn.recvToken();
            if ((token = this.context.acceptSecContext(token, 0, token.length)) == null) continue;
            conn.sendToken(token);
        }
        this.doWith(this.context, conn);
        this.context.dispose();
    }

    protected void doWith(GSSContext context, Transport.Connection conn) throws Exception {
        MessageProp prop = new MessageProp(0, false);
        byte[] token = conn.recvToken();
        byte[] bytes = context.unwrap(token, 0, token.length, prop);
        prop.setQOP(0);
        token = context.getMIC(bytes, 0, bytes.length, prop);
        conn.sendToken(token);
    }
}

