/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test.sasl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kerby.kerberos.kerb.integration.test.AppServer;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;

public class SaslAppServer
extends AppServer {
    private String mechanism = "GSSAPI";
    private String serviceProtocol;
    private String serverFqdn;

    public SaslAppServer(String[] args) throws Exception {
        super(args);
        this.serviceProtocol = args[1];
        this.serverFqdn = args[2];
    }

    public static void main(String[] args) throws Exception {
        new SaslAppServer(args).run();
    }

    @Override
    protected void usage(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: SaslAppServer <ListenPort> <service-protocol> <server-fqdn>");
            throw new RuntimeException("Usage: SaslAppServer <ListenPort> <service-protocol> <server-fqdn>");
        }
    }

    @Override
    protected void onConnection(Transport.Connection conn) throws Exception {
        SaslGssCallbackHandler callbackHandler = new SaslGssCallbackHandler();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("javax.security.sasl.qop", "auth");
        SaslServer ss = Sasl.createSaslServer(this.mechanism, this.serviceProtocol, this.serverFqdn, props, callbackHandler);
        Transport.Message msg = conn.recvMessage();
        while (!ss.isComplete()) {
            try {
                byte[] respToken = ss.evaluateResponse(msg.body);
                if (ss.isComplete()) {
                    conn.sendMessage("OK", respToken);
                    continue;
                }
                conn.sendMessage("CONT", respToken);
                msg = conn.recvMessage();
            }
            catch (SaslException e) {
                conn.sendMessage("ERR", null);
                ss.dispose();
                break;
            }
        }
        this.doWith(ss, props, conn);
        ss.dispose();
    }

    protected void doWith(SaslServer ss, Map<String, Object> props, Transport.Connection conn) throws IOException, Exception {
        conn.recvToken();
    }

    public static class SaslGssCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

