/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss;

import java.security.Provider;
import java.util.Arrays;
import org.apache.kerby.kerberos.kerb.gss.KerbyGssProvider;
import org.apache.kerby.kerberos.kerb.gss.impl.GssAcceptCred;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssCredElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssInitCred;
import org.apache.kerby.kerberos.kerb.gss.impl.GssNameElement;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public class GssMechFactory
implements MechanismFactory {
    private static final Provider PROVIDER = new KerbyGssProvider();
    private static final String KRB5_OID_STRING = "1.2.840.113554.1.2.2";
    private static final Oid KRB5_OID = GssMechFactory.createOid("1.2.840.113554.1.2.2");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_EXPORT_NAME, GSSName.NT_HOSTBASED_SERVICE};
    private final GSSCaller caller;

    @Override
    public Oid getMechanismOid() {
        return KRB5_OID;
    }

    @Override
    public Provider getProvider() {
        return PROVIDER;
    }

    @Override
    public Oid[] getNameTypes() throws GSSException {
        return nameTypes;
    }

    public GssMechFactory(GSSCaller caller) {
        this.caller = caller;
    }

    @Override
    public GSSNameSpi getNameElement(String nameStr, Oid nameType) throws GSSException {
        return GssNameElement.getInstance(nameStr, nameType);
    }

    @Override
    public GSSNameSpi getNameElement(byte[] name, Oid nameType) throws GSSException {
        return GssNameElement.getInstance(Arrays.toString(name), nameType);
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myInitiatorCred, int lifetime) throws GSSException {
        if (peer != null && !(peer instanceof GssNameElement)) {
            peer = GssNameElement.getInstance(peer.toString(), peer.getStringNameType());
        }
        if (myInitiatorCred == null) {
            myInitiatorCred = this.getCredentialElement(null, lifetime, 0, 1);
        }
        return new GssContext(this.caller, (GssNameElement)peer, (GssInitCred)myInitiatorCred, lifetime);
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSCredentialSpi myAcceptorCred) throws GSSException {
        if (myAcceptorCred == null) {
            myAcceptorCred = this.getCredentialElement(null, 0, Integer.MAX_VALUE, 2);
        }
        return new GssContext(this.caller, (GssAcceptCred)myAcceptorCred);
    }

    @Override
    public GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        return new GssContext(this.caller, exportedContext);
    }

    @Override
    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        GssCredElement credElement;
        if (name != null && !(name instanceof GssNameElement)) {
            name = GssNameElement.getInstance(name.toString(), name.getStringNameType());
        }
        if (usage == 1) {
            credElement = GssInitCred.getInstance(this.caller, (GssNameElement)name, initLifetime);
        } else if (usage == 2) {
            credElement = GssAcceptCred.getInstance(this.caller, (GssNameElement)name, acceptLifetime);
        } else {
            if (usage == 0) {
                throw new GSSException(11, -1, "Unsupported usage mode: INITIATE_AND_ACCEPT");
            }
            throw new GSSException(11, -1, "Unknown usage mode: " + usage);
        }
        return credElement;
    }

    private static Oid createOid(String oidStr) {
        Oid retVal;
        try {
            retVal = new Oid(oidStr);
        }
        catch (GSSException e) {
            retVal = null;
        }
        return retVal;
    }

    public static Oid getOid() {
        return KRB5_OID;
    }
}

