/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.jgss.GSSCaller;

public class CredUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CredUtils.class);

    public static <T> Set<T> getContextPrivateCredentials(Class<T> credentialType, AccessControlContext acc) {
        Subject subject = Subject.getSubject(acc);
        Set<T> creds = subject.getPrivateCredentials(credentialType);
        return creds;
    }

    public static <T> Set<T> getContextCredentials(final Class<T> credentialType) throws GSSException {
        final AccessControlContext acc = AccessController.getContext();
        try {
            return (Set)AccessController.doPrivileged(new PrivilegedExceptionAction<Set<T>>(){

                @Override
                public Set<T> run() throws Exception {
                    return CredUtils.getContextPrivateCredentials(credentialType, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new GSSException(13, -1, "Get credential from context failed");
        }
    }

    public static Set<KerberosKey> getKerberosKeysFromContext(GSSCaller caller, String clientName, String serverName) throws GSSException {
        return CredUtils.getContextCredentials(KerberosKey.class);
    }

    public static KerberosTicket getKerberosTicketFromContext(GSSCaller caller, String clientName, String serverName) throws GSSException {
        Set<KerberosTicket> tickets = CredUtils.getContextCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!ticket.isCurrent() || serverName != null && !ticket.getServer().getName().equals(serverName) || clientName != null && !ticket.getClient().getName().equals(clientName)) continue;
            return ticket;
        }
        return null;
    }

    public static KeyTab getKeyTabFromContext(KerberosPrincipal principal) throws GSSException {
        Set<KeyTab> tabs = CredUtils.getContextCredentials(KeyTab.class);
        for (KeyTab tab : tabs) {
            KerberosKey[] keys;
            KerberosPrincipal princ = principal;
            if (princ == null) {
                try {
                    Method m = tab.getClass().getDeclaredMethod("getPrincipal", new Class[0]);
                    princ = (KerberosPrincipal)m.invoke((Object)tab, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.info("Can't get a principal from the keytab", (Throwable)e);
                }
            }
            if (princ == null || (keys = tab.getKeys(princ)) == null || keys.length <= 0) continue;
            return tab;
        }
        return null;
    }

    public static void addCredentialToSubject(final KerberosTicket ticket) throws GSSException {
        final AccessControlContext acc = AccessController.getContext();
        final Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(acc);
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                subject.getPrivateCredentials().add(ticket);
                return null;
            }
        });
    }

    public static void checkPrincipalPermission(String principalName, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServicePermission sp = new ServicePermission(principalName, action);
            sm.checkPermission(sp);
        }
    }
}

