/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import org.apache.kerby.kerberos.kerb.gss.impl.CredUtils;
import org.apache.kerby.kerberos.kerb.gss.impl.GssCredElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssNameElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssUtil;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.jgss.GSSCaller;

public final class GssAcceptCred
extends GssCredElement {
    private static final Logger LOG = LoggerFactory.getLogger(GssAcceptCred.class);
    private final KeyTab keyTab;
    private final Set<KerberosKey> kerberosKeySet;

    public static GssAcceptCred getInstance(GSSCaller caller, GssNameElement name, int lifeTime) throws GSSException {
        KeyTab keyTab = GssAcceptCred.getKeyTab(name);
        Set<KerberosKey> kerberosKeySet = null;
        if (keyTab == null) {
            kerberosKeySet = name == null ? CredUtils.getKerberosKeysFromContext(caller, null, null) : CredUtils.getKerberosKeysFromContext(caller, name.getPrincipalName().getName(), null);
        }
        if (keyTab == null && kerberosKeySet == null) {
            String error = "Failed to find any Kerberos credential";
            if (name != null) {
                error = error + " for " + name.getPrincipalName().getName();
            }
            throw new GSSException(13, -1, error);
        }
        if (name == null) {
            if (keyTab != null) {
                try {
                    Method m = keyTab.getClass().getDeclaredMethod("getPrincipal", new Class[0]);
                    KerberosPrincipal princ = (KerberosPrincipal)m.invoke((Object)keyTab, new Object[0]);
                    name = GssNameElement.getInstance(princ.getName(), GSSName.NT_HOSTBASED_SERVICE);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    String error = "Can't get a principal from the keytab";
                    LOG.info(error, (Throwable)e);
                    throw new GSSException(13, -1, error);
                }
            } else {
                name = GssNameElement.getInstance(kerberosKeySet.iterator().next().getPrincipal().getName(), GSSName.NT_HOSTBASED_SERVICE);
            }
        }
        return new GssAcceptCred(caller, name, keyTab, lifeTime, kerberosKeySet);
    }

    private static KeyTab getKeyTab(GssNameElement name) throws GSSException {
        if (name == null) {
            return CredUtils.getKeyTabFromContext(null);
        }
        KerberosPrincipal princ = new KerberosPrincipal(name.getPrincipalName().getName(), name.getPrincipalName().getNameType().getValue());
        return CredUtils.getKeyTabFromContext(princ);
    }

    private GssAcceptCred(GSSCaller caller, GssNameElement name, KeyTab keyTab, int lifeTime, Set<KerberosKey> kerberosKeySet) {
        super(caller, name);
        this.keyTab = keyTab;
        this.accLifeTime = lifeTime;
        this.kerberosKeySet = kerberosKeySet;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    public KeyTab getKeyTab() {
        return this.keyTab;
    }

    public EncryptionKey getEncryptionKey(int encryptType, int kvno) {
        if (this.kerberosKeySet != null) {
            KerberosKey[] keys = this.kerberosKeySet.toArray(new KerberosKey[this.kerberosKeySet.size()]);
            return GssUtil.getEncryptionKey(keys, encryptType);
        }
        KerberosPrincipal princ = new KerberosPrincipal(this.name.getPrincipalName().getName(), this.name.getPrincipalName().getNameType().getValue());
        KerberosKey[] keys = this.keyTab.getKeys(princ);
        return GssUtil.getEncryptionKey(keys, encryptType, kvno);
    }
}

