/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.Provider;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.gss.GssMechFactory;
import org.apache.kerby.kerberos.kerb.gss.KerbyGssProvider;
import org.apache.kerby.kerberos.kerb.gss.impl.CredUtils;
import org.apache.kerby.kerberos.kerb.gss.impl.GssAcceptCred;
import org.apache.kerby.kerberos.kerb.gss.impl.GssCredElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssEncryptor;
import org.apache.kerby.kerberos.kerb.gss.impl.GssInitCred;
import org.apache.kerby.kerberos.kerb.gss.impl.GssNameElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssUtil;
import org.apache.kerby.kerberos.kerb.gss.impl.MicTokenV1;
import org.apache.kerby.kerberos.kerb.gss.impl.MicTokenV2;
import org.apache.kerby.kerberos.kerb.gss.impl.WrapTokenV1;
import org.apache.kerby.kerberos.kerb.gss.impl.WrapTokenV2;
import org.apache.kerby.kerberos.kerb.request.ApRequest;
import org.apache.kerby.kerberos.kerb.response.ApResponse;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.ap.ApRep;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import org.apache.kerby.kerberos.kerb.type.ticket.KrbTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlags;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public class GssContext
implements GSSContextSpi {
    private static final int STATE_NONE = 0;
    private static final int STATE_ESTABLISHING = 1;
    private static final int STATE_ESTABLISHED = 2;
    private static final int STATE_DESTROYED = 3;
    private static final byte[] MSG_AP_REQ = new byte[]{1, 0};
    private static final byte[] MSG_AP_REP = new byte[]{2, 0};
    private int ctxState = 0;
    private final GSSCaller caller;
    private GssCredElement myCred;
    private boolean initiator;
    private GssNameElement myName;
    private GssNameElement peerName;
    private int lifeTime;
    private ChannelBinding channelBinding;
    private boolean mutualAuth = true;
    private boolean replayDet = true;
    private boolean sequenceDet = true;
    private boolean credDeleg = false;
    private boolean confState = true;
    private boolean integState = true;
    private boolean delegPolicy = false;
    public static final int INVALID_KEY = 0;
    public static final int SESSION_KEY = 1;
    public static final int INITIATOR_SUBKEY = 2;
    public static final int ACCEPTOR_SUBKEY = 4;
    private int keyComesFrom = 0;
    private EncryptionKey sessionKey;
    private TicketFlags ticketFlags;
    private ApReq outApReq;
    private GssEncryptor gssEncryptor;
    private String authTime;
    private AuthorizationData authData;
    private int mySequenceNumber;
    private int peerSequenceNumber;
    private Object mySequenceNumberLock;
    private Object peerSequenceNumberLock;

    public GssContext(GSSCaller caller, GssNameElement peerName, GssCredElement myCred, int lifeTime) throws GSSException {
        if (peerName == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        this.caller = caller;
        this.peerName = peerName;
        this.myCred = myCred;
        this.lifeTime = lifeTime;
        this.initiator = true;
        this.mySequenceNumberLock = new Object();
        this.peerSequenceNumberLock = new Object();
    }

    public GssContext(GSSCaller caller, GssAcceptCred myCred) throws GSSException {
        this.caller = caller;
        this.myCred = myCred;
        this.initiator = false;
        this.mySequenceNumberLock = new Object();
        this.peerSequenceNumberLock = new Object();
    }

    public GssContext(GSSCaller caller, byte[] interProcessToken) throws GSSException {
        throw new GSSException(16, -1, "Unsupported feature");
    }

    @Override
    public Provider getProvider() {
        return new KerbyGssProvider();
    }

    @Override
    public void requestLifetime(int lifeTime) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.lifeTime = lifeTime;
        }
    }

    @Override
    public void requestMutualAuth(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.mutualAuth = state;
        }
    }

    @Override
    public void requestReplayDet(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.replayDet = state;
        }
    }

    @Override
    public void requestSequenceDet(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.replayDet = state;
        }
    }

    @Override
    public void requestCredDeleg(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator() && this.myCred == null) {
            this.credDeleg = state;
        }
    }

    @Override
    public void requestAnonymity(boolean state) throws GSSException {
    }

    @Override
    public void requestConf(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.confState = state;
        }
    }

    @Override
    public void requestInteg(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.integState = state;
        }
    }

    @Override
    public void requestDelegPolicy(boolean state) throws GSSException {
        if (this.ctxState == 0 && this.isInitiator()) {
            this.delegPolicy = state;
        }
    }

    @Override
    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        this.channelBinding = cb;
    }

    @Override
    public boolean getCredDelegState() {
        return this.credDeleg;
    }

    @Override
    public boolean getMutualAuthState() {
        return this.mutualAuth;
    }

    @Override
    public boolean getReplayDetState() {
        return this.replayDet || this.sequenceDet;
    }

    @Override
    public boolean getSequenceDetState() {
        return this.sequenceDet;
    }

    @Override
    public boolean getAnonymityState() {
        return false;
    }

    @Override
    public boolean getDelegPolicyState() {
        return this.delegPolicy;
    }

    @Override
    public boolean isTransferable() throws GSSException {
        return false;
    }

    @Override
    public boolean isProtReady() {
        return this.ctxState == 2;
    }

    @Override
    public boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public boolean getConfState() {
        return this.confState;
    }

    @Override
    public boolean getIntegState() {
        return this.integState;
    }

    @Override
    public int getLifetime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isEstablished() {
        return this.ctxState == 2;
    }

    @Override
    public GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public Oid getMech() throws GSSException {
        return GssMechFactory.getOid();
    }

    @Override
    public GSSCredentialSpi getDelegCred() throws GSSException {
        throw new GSSException(11, -1, "API not implemented");
    }

    @Override
    public byte[] initSecContext(InputStream is, int mechTokenSize) throws GSSException {
        if (!this.isInitiator()) {
            throw new GSSException(11, -1, "initSecContext called on acceptor");
        }
        byte[] ret = null;
        if (this.ctxState == 0) {
            if (!this.myCred.isInitiatorCredential()) {
                throw new GSSException(13, -1, "No TGT available");
            }
            SgtTicket sgtTicket = null;
            String serviceName = this.peerName.getPrincipalName().getName();
            this.myName = (GssNameElement)this.myCred.getName();
            PrincipalName clientPrincipal = this.myName.getPrincipalName();
            sgtTicket = GssUtil.getSgtCredentialFromContext(this.caller, clientPrincipal.getName(), serviceName);
            if (sgtTicket == null) {
                sgtTicket = GssUtil.applySgtCredential(((GssInitCred)this.myCred).getKerberosTicket(), ((GssInitCred)this.myCred).getKrbToken(), serviceName);
                KerberosTicket ticket = GssUtil.convertKrbTicketToKerberosTicket((KrbTicket)sgtTicket, this.myName.getPrincipalName().getName());
                CredUtils.addCredentialToSubject(ticket);
            }
            ApRequest apRequest = new ApRequest(clientPrincipal, sgtTicket);
            try {
                this.outApReq = apRequest.getApReq();
            }
            catch (KrbException e) {
                throw new GSSException(11, -1, "Generate ApReq failed: " + e.getMessage());
            }
            this.setupInitiatorContext(sgtTicket, apRequest);
            try {
                ByteBuffer outBuffer = ByteBuffer.allocate(this.outApReq.encodingLength() + 2);
                outBuffer.put(MSG_AP_REQ);
                this.outApReq.encode(outBuffer);
                outBuffer.flip();
                ret = outBuffer.array();
            }
            catch (IOException e) {
                throw new GSSException(11, -1, "Generate ApReq bytes failed: " + e.getMessage());
            }
            this.ctxState = 1;
            if (!this.getMutualAuthState()) {
                this.gssEncryptor = new GssEncryptor(this.getSessionKey());
                this.ctxState = 2;
            }
        } else if (this.ctxState == 1) {
            this.verifyServerToken(is, mechTokenSize);
            this.gssEncryptor = new GssEncryptor(this.getSessionKey());
            this.outApReq = null;
            this.ctxState = 2;
        }
        return ret;
    }

    private void setupInitiatorContext(SgtTicket sgt, ApRequest apRequest) throws GSSException {
        Authenticator auth;
        EncKdcRepPart encKdcRepPart = sgt.getEncKdcRepPart();
        TicketFlags ticketFlags = encKdcRepPart.getFlags();
        this.setTicketFlags(ticketFlags);
        this.setAuthTime(encKdcRepPart.getAuthTime().toString());
        try {
            auth = apRequest.getApReq().getAuthenticator();
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "ApReq failed in Initiator");
        }
        this.setMySequenceNumber(auth.getSeqNumber());
        EncryptionKey subKey = auth.getSubKey();
        if (subKey != null) {
            this.setSessionKey(subKey, 2);
        } else {
            this.setSessionKey(sgt.getSessionKey(), 1);
        }
        if (!this.getMutualAuthState()) {
            this.setPeerSequenceNumber(0);
        }
    }

    private void verifyServerToken(InputStream is, int mechTokenSize) throws GSSException {
        int seqNum;
        ApRep apRep;
        try {
            if (is.read() != MSG_AP_REP[0] || is.read() != MSG_AP_REP[1]) {
                throw new GSSException(11, -1, "Invalid ApRep message ID");
            }
            byte[] token = new byte[mechTokenSize - MSG_AP_REP.length];
            is.read(token);
            apRep = new ApRep();
            apRep.decode(token);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Invalid ApRep " + e.getMessage());
        }
        try {
            ApResponse.validate((EncryptionKey)this.getSessionKey(), (ApRep)apRep, (ApReq)this.outApReq);
        }
        catch (KrbException e) {
            throw new GSSException(15, -1, "ApRep verification failed");
        }
        EncryptionKey key = apRep.getEncRepPart().getSubkey();
        if (key != null) {
            this.setSessionKey(key, 4);
        }
        this.setPeerSequenceNumber((seqNum = apRep.getEncRepPart().getSeqNumber()) == -1 ? 0 : seqNum);
    }

    @Override
    public byte[] acceptSecContext(InputStream is, int mechTokenSize) throws GSSException {
        byte[] ret = null;
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext called on initiator");
        }
        if (this.ctxState == 0) {
            this.ctxState = 1;
            if (!this.myCred.isAcceptorCredential()) {
                throw new GSSException(11, -1, "No acceptor credential available");
            }
            GssAcceptCred acceptCred = (GssAcceptCred)this.myCred;
            CredUtils.checkPrincipalPermission(((GssNameElement)acceptCred.getName()).getPrincipalName().getName(), "accept");
            if (this.getMutualAuthState()) {
                ret = this.verifyClientToken(acceptCred, is, mechTokenSize);
            }
            this.gssEncryptor = new GssEncryptor(this.getSessionKey());
            this.myCred = null;
            this.ctxState = 2;
        }
        return ret;
    }

    private byte[] verifyClientToken(GssAcceptCred acceptCred, InputStream is, int mechTokenSize) throws GSSException {
        ApRep apRep;
        ApReq apReq;
        try {
            if (is.read() != MSG_AP_REQ[0] || is.read() != MSG_AP_REQ[1]) {
                throw new GSSException(11, -1, "Invalid ApReq message ID");
            }
            byte[] token = new byte[mechTokenSize - MSG_AP_REQ.length];
            is.read(token);
            apReq = new ApReq();
            apReq.decode(token);
        }
        catch (IOException e) {
            throw new GSSException(15, -1, "ApReq invalid:" + e.getMessage());
        }
        int kvno = apReq.getTicket().getEncryptedEncPart().getKvno();
        int encryptType = apReq.getTicket().getEncryptedEncPart().getEType().getValue();
        EncryptionKey serverKey = acceptCred.getEncryptionKey(encryptType, kvno);
        if (serverKey == null) {
            throw new GSSException(11, -1, "Server key not found");
        }
        this.peerName = (GssNameElement)acceptCred.getName();
        try {
            ApRequest.validate((EncryptionKey)serverKey, (ApReq)apReq, (InetAddress)(this.channelBinding == null ? null : this.channelBinding.getInitiatorAddress()), (long)300000L);
        }
        catch (KrbException e) {
            throw new GSSException(15, -1, "ApReq verification failed: " + e.getMessage());
        }
        ApResponse apResponse = new ApResponse(apReq);
        try {
            apRep = apResponse.getApRep();
        }
        catch (KrbException e) {
            throw new GSSException(15, -1, "Generate ApRep failed");
        }
        EncTicketPart apReqTicketEncPart = apReq.getTicket().getEncPart();
        EncryptionKey ssKey = apReqTicketEncPart.getKey();
        Authenticator auth = apReq.getAuthenticator();
        EncryptionKey subKey = auth.getSubKey();
        if (subKey != null) {
            this.setSessionKey(subKey, 2);
        } else {
            this.setSessionKey(ssKey, 1);
        }
        int seqNumber = auth.getSeqNumber();
        this.setMySequenceNumber(seqNumber);
        this.setAuthTime(apReqTicketEncPart.getAuthTime().toString());
        this.setTicketFlags(apReqTicketEncPart.getFlags());
        this.setAuthData(apReqTicketEncPart.getAuthorizationData());
        byte[] ret = null;
        try {
            ByteBuffer outBuffer = ByteBuffer.allocate(apRep.encodingLength() + 2);
            outBuffer.put(MSG_AP_REP);
            apRep.encode(outBuffer);
            outBuffer.flip();
            ret = outBuffer.array();
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Generate ApRep bytes failed:" + e.getMessage());
        }
        return ret;
    }

    @Override
    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokSize) throws GSSException {
        if (this.gssEncryptor.isV2()) {
            return WrapTokenV2.getMsgSizeLimit(qop, confReq, maxTokSize, this.gssEncryptor);
        }
        return WrapTokenV1.getMsgSizeLimit(qop, confReq, maxTokSize, this.gssEncryptor);
    }

    @Override
    public void wrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        byte[] inBuf;
        int len;
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for wrap");
        }
        try {
            len = is.available();
            inBuf = new byte[len];
            is.read(inBuf);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error when get user data:" + e.getMessage());
        }
        if (this.gssEncryptor.isV2()) {
            WrapTokenV2 token = new WrapTokenV2(this, inBuf, 0, len, msgProp);
            token.wrap(os);
        } else {
            WrapTokenV1 token = new WrapTokenV1(this, inBuf, 0, len, msgProp);
            token.wrap(os);
        }
    }

    @Override
    public byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        byte[] ret;
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for wrap");
        }
        if (this.gssEncryptor.isV2()) {
            WrapTokenV2 token = new WrapTokenV2(this, inBuf, offset, len, msgProp);
            ret = token.wrap();
        } else {
            WrapTokenV1 token = new WrapTokenV1(this, inBuf, offset, len, msgProp);
            ret = token.wrap();
        }
        return ret;
    }

    @Override
    public void unwrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for unwrap");
        }
        if (this.gssEncryptor.isV2()) {
            WrapTokenV2 token = new WrapTokenV2(this, msgProp, is);
            token.unwrap(os);
        } else {
            WrapTokenV1 token = new WrapTokenV1(this, msgProp, is);
            token.unwrap(os);
        }
    }

    @Override
    public byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        byte[] ret;
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for unwrap");
        }
        if (this.gssEncryptor.isV2()) {
            WrapTokenV2 token = new WrapTokenV2(this, msgProp, inBuf, offset, len);
            ret = token.unwrap();
        } else {
            WrapTokenV1 token = new WrapTokenV1(this, msgProp, inBuf, offset, len);
            ret = token.unwrap();
        }
        return ret;
    }

    @Override
    public void getMIC(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for getMIC");
        }
        try {
            int len = is.available();
            byte[] inMsg = new byte[len];
            is.read(inMsg);
            if (this.gssEncryptor.isV2()) {
                MicTokenV2 token = new MicTokenV2(this, inMsg, 0, len, msgProp);
                token.getMic(os);
            } else {
                MicTokenV1 token = new MicTokenV1(this, inMsg, 0, len, msgProp);
                token.getMic(os);
            }
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error when get user data in getMIC:" + e.getMessage());
        }
    }

    @Override
    public byte[] getMIC(byte[] inMsg, int offset, int len, MessageProp msgProp) throws GSSException {
        byte[] ret;
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for getMIC");
        }
        if (this.gssEncryptor.isV2()) {
            MicTokenV2 token = new MicTokenV2(this, inMsg, offset, len, msgProp);
            ret = token.getMic();
        } else {
            MicTokenV1 token = new MicTokenV1(this, inMsg, offset, len, msgProp);
            ret = token.getMic();
        }
        return ret;
    }

    @Override
    public void verifyMIC(InputStream is, InputStream msgStr, MessageProp msgProp) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for verifyMIC");
        }
        try {
            int tokLen = is.available();
            byte[] inTok = new byte[tokLen];
            int msgLen = msgStr.available();
            byte[] inMsg = new byte[msgLen];
            this.verifyMIC(inTok, 0, tokLen, inMsg, 0, msgLen, msgProp);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error when get user data in verifyMIC:" + e.getMessage());
        }
    }

    @Override
    public void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Context invalid for verifyMIC");
        }
        if (this.gssEncryptor.isV2()) {
            MicTokenV2 token = new MicTokenV2(this, msgProp, inTok, tokOffset, tokLen);
            token.verify(inMsg, msgOffset, msgLen);
        } else {
            MicTokenV1 token = new MicTokenV1(this, msgProp, inTok, tokOffset, tokLen);
            token.verify(inMsg, msgOffset, msgLen);
        }
    }

    @Override
    public byte[] export() throws GSSException {
        throw new GSSException(16, -1, "Unsupported export() method");
    }

    @Override
    public void dispose() throws GSSException {
        this.ctxState = 3;
        this.setSessionKey(null, 0);
        this.peerName = null;
        this.myCred = null;
        this.myName = null;
    }

    private void setAuthTime(String authTime) {
        this.authTime = authTime;
    }

    @Override
    public Object inquireSecContext(String type) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Invalid context");
        }
        switch (type) {
            case "KRB5_GET_SESSION_KEY": {
                return this.getSessionKey();
            }
            case "KRB5_GET_TKT_FLAGS": {
                return GssUtil.ticketFlagsToBooleans(this.ticketFlags);
            }
            case "KRB5_GET_AUTHZ_DATA": {
                if (this.isInitiator()) {
                    throw new GSSException(16, -1, "Authorization data not available for initiator");
                }
                return GssUtil.kerbyAuthorizationDataToJgssAuthorizationDataEntries(this.authData);
            }
            case "KRB5_GET_AUTHTIME": {
                return this.authTime;
            }
        }
        throw new GSSException(16, -1, "Unsupported inquire type");
    }

    public Object inquireSecContext(InquireType type) throws GSSException {
        if (this.ctxState != 2) {
            throw new GSSException(12, -1, "Invalid context");
        }
        switch (type) {
            case KRB5_GET_SESSION_KEY: {
                return this.getSessionKey();
            }
            case KRB5_GET_TKT_FLAGS: {
                return GssUtil.ticketFlagsToBooleans(this.ticketFlags);
            }
            case KRB5_GET_AUTHZ_DATA: {
                if (this.isInitiator()) {
                    throw new GSSException(16, -1, "Authorization data not available for initiator");
                }
                return GssUtil.kerbyAuthorizationDataToJgssAuthorizationDataEntries(this.authData);
            }
            case KRB5_GET_AUTHTIME: {
                return this.authTime;
            }
        }
        throw new GSSException(16, -1, "Unsupported inquire type");
    }

    private void setSessionKey(EncryptionKey encryptionKey, int keyComesFrom) {
        this.sessionKey = encryptionKey;
        this.keyComesFrom = keyComesFrom;
    }

    public int getKeyComesFrom() {
        return this.keyComesFrom;
    }

    private EncryptionKey getSessionKey() {
        return this.sessionKey;
    }

    private void setTicketFlags(TicketFlags ticketFlags) {
        this.ticketFlags = ticketFlags;
    }

    private void setAuthData(AuthorizationData authData) {
        this.authData = authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMySequenceNumber(int sequenceNumber) {
        Object object = this.mySequenceNumberLock;
        synchronized (object) {
            this.mySequenceNumber = sequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incMySequenceNumber() {
        Object object = this.mySequenceNumberLock;
        synchronized (object) {
            return this.mySequenceNumber++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeerSequenceNumber(int sequenceNumber) {
        Object object = this.peerSequenceNumberLock;
        synchronized (object) {
            this.peerSequenceNumber = sequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incPeerSequenceNumber() {
        Object object = this.peerSequenceNumberLock;
        synchronized (object) {
            return this.peerSequenceNumber++;
        }
    }

    public GssEncryptor getGssEncryptor() {
        return this.gssEncryptor;
    }
}

