/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.security.Provider;
import org.apache.kerby.kerberos.kerb.gss.KerbyGssProvider;
import org.apache.kerby.kerberos.kerb.gss.impl.GssNameElement;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public abstract class GssCredElement
implements GSSCredentialSpi {
    static final Oid KRB5_OID = GssCredElement.createOid("1.2.840.113554.1.2.2");
    protected GSSCaller caller;
    protected GssNameElement name;
    protected int initLifeTime;
    protected int accLifeTime;

    GssCredElement(GSSCaller caller, GssNameElement name) {
        this.caller = caller;
        this.name = name;
    }

    @Override
    public Provider getProvider() {
        return new KerbyGssProvider();
    }

    @Override
    public void dispose() throws GSSException {
    }

    @Override
    public GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return this.initLifeTime;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return this.accLifeTime;
    }

    @Override
    public Oid getMechanism() {
        return KRB5_OID;
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi name) throws GSSException {
        throw new GSSException(11, -1, "Unsupported feature");
    }

    private static Oid createOid(String oidStr) {
        Oid retVal;
        try {
            retVal = new Oid(oidStr);
        }
        catch (GSSException e) {
            retVal = null;
        }
        return retVal;
    }
}

