/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import org.apache.kerby.kerberos.kerb.crypto.CheckSumTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.crypto.cksum.provider.Md5Provider;
import org.apache.kerby.kerberos.kerb.crypto.enc.provider.DesProvider;
import org.apache.kerby.kerberos.kerb.crypto.enc.provider.Rc4Provider;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.ietf.jgss.GSSException;

public class GssEncryptor {
    private final EncryptionKey encKey;
    private final EncryptionType encKeyType;
    private final byte[] encKeyBytes;
    private CheckSumType checkSumTypeDef;
    private int checkSumSize;
    private boolean isV2 = false;
    private int sgnAlg = 65535;
    private int sealAlg = 65535;
    private boolean isArcFourHmac = false;
    private static final byte[] IV_ZEROR_8B = new byte[8];

    public GssEncryptor(EncryptionKey key) throws GSSException {
        this.encKey = key;
        this.encKeyBytes = this.encKey.getKeyData();
        this.encKeyType = key.getKeyType();
        if (this.encKeyType == EncryptionType.AES128_CTS_HMAC_SHA1_96) {
            this.checkSumSize = 12;
            this.checkSumTypeDef = CheckSumType.HMAC_SHA1_96_AES128;
            this.isV2 = true;
        } else if (this.encKeyType == EncryptionType.AES256_CTS_HMAC_SHA1_96) {
            this.checkSumSize = 12;
            this.checkSumTypeDef = CheckSumType.HMAC_SHA1_96_AES256;
            this.isV2 = true;
        } else if (this.encKeyType == EncryptionType.DES_CBC_CRC || this.encKeyType == EncryptionType.DES_CBC_MD5) {
            this.sgnAlg = 0;
            this.sealAlg = 0;
            this.checkSumSize = 8;
        } else if (this.encKeyType == EncryptionType.DES3_CBC_SHA1) {
            this.sgnAlg = 1024;
            this.sealAlg = 512;
            this.checkSumSize = 20;
        } else if (this.encKeyType == EncryptionType.ARCFOUR_HMAC) {
            this.sgnAlg = 4352;
            this.sealAlg = 4096;
            this.checkSumSize = 16;
            this.isArcFourHmac = true;
        } else {
            throw new GSSException(11, -1, "Invalid encryption type: " + this.encKeyType.getDisplayName());
        }
    }

    public boolean isV2() {
        return this.isV2;
    }

    public int getSgnAlg() {
        return this.sgnAlg;
    }

    public int getSealAlg() {
        return this.sealAlg;
    }

    public boolean isArcFourHmac() {
        return this.isArcFourHmac;
    }

    public byte[] encryptData(byte[] tokenHeader, byte[] data, int offset, int len, int keyUsage) throws GSSException {
        byte[] toProcess = new byte[tokenHeader.length + len];
        System.arraycopy(data, offset, toProcess, 0, len);
        System.arraycopy(tokenHeader, 0, toProcess, len, tokenHeader.length);
        byte[] ret = this.encryptData(toProcess, keyUsage);
        return ret;
    }

    public byte[] encryptData(byte[] toProcess, int keyUsage) throws GSSException {
        byte[] ret;
        try {
            EncTypeHandler encHandler = EncryptionHandler.getEncHandler((EncryptionType)this.encKey.getKeyType());
            ret = encHandler.encrypt(toProcess, this.encKey.getKeyData(), keyUsage);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
        return ret;
    }

    public byte[] decryptData(byte[] dataEncrypted, int keyUsage) throws GSSException {
        byte[] ret;
        try {
            EncTypeHandler encHandler = EncryptionHandler.getEncHandler((EncryptionType)this.encKey.getKeyType());
            ret = encHandler.decrypt(dataEncrypted, this.encKey.getKeyData(), keyUsage);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
        return ret;
    }

    public byte[] calculateCheckSum(byte[] header, byte[] data, int offset, int len, int keyUsage) throws GSSException {
        int totalLen = len + (header == null ? 0 : header.length);
        byte[] buffer = new byte[totalLen];
        System.arraycopy(data, offset, buffer, 0, len);
        if (header != null) {
            System.arraycopy(header, 0, buffer, len, header.length);
        }
        try {
            return CheckSumHandler.getCheckSumHandler((CheckSumType)this.checkSumTypeDef).checksumWithKey(buffer, this.encKey.getKeyData(), keyUsage);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "Exception in checksum calculation:" + e.getMessage());
        }
    }

    public int getCheckSumSize() throws GSSException {
        return this.checkSumSize;
    }

    private void addPadding(int paddingLen, byte[] outBuf, int offset) {
        for (int i = 0; i < paddingLen; ++i) {
            outBuf[offset + i] = (byte)paddingLen;
        }
    }

    private byte[] getFirstBytes(byte[] src, int len) {
        if (len < src.length) {
            byte[] ret = new byte[len];
            System.arraycopy(src, 0, ret, 0, len);
            return ret;
        }
        return src;
    }

    private byte[] getKeyBytesWithLength(int len) {
        return this.getFirstBytes(this.encKeyBytes, len);
    }

    public byte[] calculateCheckSum(byte[] confounder, byte[] header, byte[] data, int offset, int len, int paddingLen, boolean isMic) throws GSSException {
        byte[] ret;
        int toOffset;
        byte[] toProc;
        int keyUsage = 23;
        int toLen = (confounder == null ? 0 : confounder.length) + (header == null ? 0 : header.length) + len + paddingLen;
        if (toLen == len) {
            toProc = data;
            toOffset = offset;
        } else {
            toOffset = 0;
            int idx = 0;
            toProc = new byte[toLen];
            if (header != null) {
                System.arraycopy(header, 0, toProc, idx, header.length);
                idx += header.length;
            }
            if (confounder != null) {
                System.arraycopy(confounder, 0, toProc, idx, confounder.length);
                idx += confounder.length;
            }
            System.arraycopy(data, offset, toProc, idx, len);
            this.addPadding(paddingLen, toProc, len + idx);
        }
        try {
            CheckSumType chksumType;
            switch (this.sgnAlg) {
                case 0: {
                    Md5Provider md5Provider = new Md5Provider();
                    md5Provider.hash(toProc);
                    toProc = md5Provider.output();
                }
                case 512: {
                    DesProvider desProvider = new DesProvider();
                    return desProvider.cbcMac(this.encKeyBytes, IV_ZEROR_8B, toProc);
                }
                case 1024: {
                    chksumType = CheckSumType.HMAC_SHA1_DES3_KD;
                    break;
                }
                case 4352: {
                    chksumType = CheckSumType.MD5_HMAC_ARCFOUR;
                    if (!isMic) break;
                    keyUsage = 15;
                    break;
                }
                case 256: {
                    throw new GSSException(11, -1, "CheckSum not implemented for SGN_ALG_MD25");
                }
                default: {
                    throw new GSSException(11, -1, "CheckSum not implemented for sgnAlg=" + this.sgnAlg);
                }
            }
            CheckSumTypeHandler handler = CheckSumHandler.getCheckSumHandler((CheckSumType)chksumType);
            int keySize = handler.keySize();
            byte[] key = this.getKeyBytesWithLength(keySize);
            ret = handler.checksumWithKey(toProc, toOffset, toLen, key, keyUsage);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "Exception in checksum calculation sgnAlg = " + this.sgnAlg + " : " + e.getMessage());
        }
        return ret;
    }

    public byte[] encryptSequenceNumber(byte[] seqBytes, byte[] ivSrc, boolean encrypt) throws GSSException {
        try {
            EncTypeHandler handler;
            switch (this.sgnAlg) {
                case 0: 
                case 512: {
                    DesProvider desProvider = new DesProvider();
                    byte[] data = (byte[])seqBytes.clone();
                    if (encrypt) {
                        desProvider.encrypt(this.encKeyBytes, ivSrc, data);
                    } else {
                        desProvider.decrypt(this.encKeyBytes, ivSrc, data);
                    }
                    return data;
                }
                case 1024: {
                    handler = EncryptionHandler.getEncHandler((EncryptionType)EncryptionType.DES3_CBC_SHA1_KD);
                    break;
                }
                case 4352: {
                    return this.encryptArcFourHmac(seqBytes, this.getKeyBytesWithLength(16), this.getFirstBytes(ivSrc, 8), encrypt);
                }
                case 256: {
                    throw new GSSException(11, -1, "EncSeq not implemented for SGN_ALG_MD25");
                }
                default: {
                    throw new GSSException(11, -1, "EncSeq not implemented for sgnAlg=" + this.sgnAlg);
                }
            }
            int keySize = handler.keySize();
            byte[] key = this.getKeyBytesWithLength(keySize);
            int ivLen = handler.encProvider().blockSize();
            byte[] iv = this.getFirstBytes(ivSrc, ivLen);
            if (encrypt) {
                return handler.encryptRaw(seqBytes, key, iv, 24);
            }
            return handler.decryptRaw(seqBytes, key, iv, 24);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "Exception in encrypt seq number sgnAlg = " + this.sgnAlg + " : " + e.getMessage());
        }
    }

    private byte[] getHmacMd5(byte[] key, byte[] salt) throws GSSException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(secretKey);
            return mac.doFinal(salt);
        }
        catch (Exception e) {
            throw new GSSException(11, -1, "Get HmacMD5 failed: " + e.getMessage());
        }
    }

    private byte[] encryptArcFourHmac(byte[] data, byte[] key, byte[] iv, boolean encrypt) throws GSSException {
        byte[] sk1 = this.getHmacMd5(key, new byte[4]);
        byte[] sk2 = this.getHmacMd5(sk1, iv);
        Rc4Provider provider = new Rc4Provider();
        try {
            byte[] ret = (byte[])data.clone();
            if (encrypt) {
                provider.encrypt(sk2, ret);
            } else {
                provider.decrypt(sk2, ret);
            }
            return ret;
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "En/Decrypt sequence failed for ArcFourHmac: " + e.getMessage());
        }
    }

    private byte[] encryptDataArcFourHmac(byte[] data, byte[] key, byte[] seqNum, boolean encrypt) throws GSSException {
        byte[] dataKey = new byte[key.length];
        for (int i = 0; i <= 15; ++i) {
            dataKey[i] = (byte)(key[i] ^ 0xF0);
        }
        return this.encryptArcFourHmac(data, dataKey, seqNum, encrypt);
    }

    public byte[] encryptTokenV1(byte[] confounder, byte[] data, int offset, int len, int paddingLen, byte[] seqNumber, boolean encrypt) throws GSSException {
        byte[] toProc;
        if (encrypt) {
            int toLen = (confounder == null ? 0 : confounder.length) + len + paddingLen;
            int index = 0;
            toProc = new byte[toLen];
            if (confounder != null) {
                System.arraycopy(confounder, 0, toProc, 0, confounder.length);
                index += confounder.length;
            }
            System.arraycopy(data, offset, toProc, index, len);
            this.addPadding(paddingLen, toProc, index + len);
        } else {
            toProc = data;
            if (data.length != len) {
                toProc = new byte[len];
                System.arraycopy(data, offset, toProc, 0, len);
            }
        }
        try {
            EncTypeHandler handler;
            switch (this.sealAlg) {
                case 0: {
                    handler = EncryptionHandler.getEncHandler((EncryptionType)EncryptionType.DES_CBC_MD5);
                    break;
                }
                case 512: {
                    handler = EncryptionHandler.getEncHandler((EncryptionType)EncryptionType.DES3_CBC_SHA1_KD);
                    break;
                }
                case 4096: {
                    return this.encryptDataArcFourHmac(toProc, this.getKeyBytesWithLength(16), seqNumber, encrypt);
                }
                default: {
                    throw new GSSException(11, -1, "Unknown encryption type sealAlg = " + this.sealAlg);
                }
            }
            int keySize = handler.keySize();
            byte[] key = this.getKeyBytesWithLength(keySize);
            if (encrypt) {
                return handler.encryptRaw(toProc, key, 22);
            }
            return handler.decryptRaw(toProc, key, 22);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, "Exception in encrypt data sealAlg = " + this.sealAlg + " : " + e.getMessage());
        }
    }
}

