/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.util.Set;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.kerby.kerberos.kerb.gss.impl.CredUtils;
import org.apache.kerby.kerberos.kerb.gss.impl.GssCredElement;
import org.apache.kerby.kerberos.kerb.gss.impl.GssNameElement;
import org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import sun.security.jgss.GSSCaller;

public final class GssInitCred
extends GssCredElement {
    private KerberosTicket ticket;
    private KrbToken krbToken;

    private GssInitCred(GSSCaller caller, GssNameElement name, KerberosTicket ticket, KrbToken krbToken, int lifeTime) {
        super(caller, name);
        this.ticket = ticket;
        this.initLifeTime = lifeTime;
        this.krbToken = krbToken;
    }

    public static GssInitCred getInstance(GSSCaller caller, GssNameElement name, int lifeTime) throws GSSException {
        KrbToken krbToken;
        Set<KrbToken> krbTokens = CredUtils.getContextCredentials(KrbToken.class);
        KrbToken krbToken2 = krbToken = krbTokens != null && !krbTokens.isEmpty() ? krbTokens.iterator().next() : null;
        if (name == null) {
            KerberosTicket ticket = CredUtils.getKerberosTicketFromContext(caller, null, null);
            GssNameElement clientName = GssNameElement.getInstance(ticket.getClient().getName(), GSSName.NT_USER_NAME);
            return new GssInitCred(caller, clientName, ticket, krbToken, lifeTime);
        }
        KerberosTicket ticket = CredUtils.getKerberosTicketFromContext(caller, name.getPrincipalName().getName(), null);
        return new GssInitCred(caller, name, ticket, krbToken, lifeTime);
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    public KerberosTicket getKerberosTicket() {
        return this.ticket;
    }

    public KrbToken getKrbToken() {
        return this.krbToken;
    }
}

