/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import org.apache.kerby.kerberos.kerb.gss.GssMechFactory;
import org.apache.kerby.kerberos.kerb.gss.KerbyGssProvider;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.PrincipalName;

public class GssNameElement
implements GSSNameSpi {
    private org.apache.kerby.kerberos.kerb.type.base.PrincipalName principalName;
    private Oid nameType = null;

    GssNameElement(org.apache.kerby.kerberos.kerb.type.base.PrincipalName principalName, Oid nameType) {
        this.principalName = principalName;
        this.nameType = nameType;
    }

    public org.apache.kerby.kerberos.kerb.type.base.PrincipalName toKerbyPrincipalName(PrincipalName name) {
        return new org.apache.kerby.kerberos.kerb.type.base.PrincipalName(name.getNameString(), this.toKerbyNameType(name.getNameType()));
    }

    private NameType toKerbyNameType(int intNameType) {
        return NameType.fromValue((Integer)intNameType);
    }

    public static NameType toKerbyNameType(Oid nameType) throws GSSException {
        NameType kerbyNameType;
        if (nameType == null) {
            throw new GSSException(4);
        }
        if (nameType.equals(GSSName.NT_EXPORT_NAME) || nameType.equals(GSSName.NT_USER_NAME)) {
            kerbyNameType = NameType.NT_PRINCIPAL;
        } else if (nameType.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            kerbyNameType = NameType.NT_SRV_HST;
        } else {
            throw new GSSException(4, 0, "Unsupported Oid name type");
        }
        return kerbyNameType;
    }

    public static GssNameElement getInstance(String name, Oid oidNameType) throws GSSException {
        if (oidNameType == null) {
            org.apache.kerby.kerberos.kerb.type.base.PrincipalName principalName = new org.apache.kerby.kerberos.kerb.type.base.PrincipalName(name);
            return new GssNameElement(principalName, null);
        }
        org.apache.kerby.kerberos.kerb.type.base.PrincipalName principalName = new org.apache.kerby.kerberos.kerb.type.base.PrincipalName(name, GssNameElement.toKerbyNameType(oidNameType));
        return new GssNameElement(principalName, oidNameType);
    }

    @Override
    public Provider getProvider() {
        return new KerbyGssProvider();
    }

    @Override
    public boolean equals(GSSNameSpi name) throws GSSException {
        if (name == null || name.isAnonymousName() || this.isAnonymousName()) {
            return false;
        }
        return this.toString().equals(name.toString()) && this.getStringNameType().equals(name.getStringNameType());
    }

    public final org.apache.kerby.kerberos.kerb.type.base.PrincipalName getPrincipalName() {
        return this.principalName;
    }

    @Override
    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        try {
            if (another instanceof GSSNameSpi) {
                return this.equals((GSSNameSpi)another);
            }
        }
        catch (GSSException e) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.principalName.hashCode();
    }

    @Override
    public byte[] export() throws GSSException {
        return this.principalName.getName().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Oid getMechanism() {
        return GssMechFactory.getOid();
    }

    @Override
    public String toString() {
        return this.principalName.toString();
    }

    @Override
    public Oid getStringNameType() {
        return this.nameType;
    }

    @Override
    public boolean isAnonymousName() {
        return this.nameType.equals(GSSName.NT_ANONYMOUS);
    }
}

