/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssEncryptor;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenBase;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.util.ObjectIdentifier;

abstract class GssTokenV1
extends GssTokenBase {
    public static final int SGN_ALG_DES_MAC_MD5 = 0;
    public static final int SGN_ALG_MD25 = 256;
    public static final int SGN_ALG_DES_MAC = 512;
    public static final int SGN_ALG_HMAC_SHA1_DES3_KD = 1024;
    public static final int SGN_ALG_RC4_HMAC = 4352;
    public static final int SEAL_ALG_NONE = 65535;
    public static final int SEAL_ALG_DES = 0;
    public static final int SEAL_ALG_DES3_KD = 512;
    public static final int SEAL_ALG_RC4_HMAC = 4096;
    public static final int KG_USAGE_SEAL = 22;
    public static final int KG_USAGE_SIGN = 23;
    public static final int KG_USAGE_SEQ = 24;
    public static final int KG_USAGE_MS_SIGN = 15;
    private boolean isInitiator;
    private boolean confState;
    private int sequenceNumber;
    protected GssEncryptor encryptor;
    private GSSHeader gssHeader;
    public static final int TOKEN_HEADER_COMM_SIZE = 8;
    public static final int TOKEN_HEADER_SEQ_SIZE = 8;
    private int tokenType;
    private byte[] commHeader = new byte[8];
    private int sgnAlg;
    private int sealAlg;
    private byte[] plainSequenceBytes;
    private byte[] encryptedSequenceNumber = new byte[8];
    private byte[] checkSum;
    private int checkSumSize;
    protected int reconHeaderLen;
    public static ObjectIdentifier objId;

    protected int getTokenHeaderSize() {
        return 16 + this.checkSumSize;
    }

    protected byte[] getPlainSequenceBytes() {
        byte[] ret = new byte[]{this.plainSequenceBytes[0], this.plainSequenceBytes[1], this.plainSequenceBytes[2], this.plainSequenceBytes[3]};
        return ret;
    }

    GssTokenV1(int tokenType, GssContext context) throws GSSException {
        this.initialize(tokenType, context, false);
        this.createTokenHeader();
    }

    GssTokenV1(int tokenType, GssContext context, MessageProp prop, byte[] token, int offset, int size) throws GSSException {
        int proxLen = size > 64 ? 64 : size;
        ByteArrayInputStream is = new ByteArrayInputStream(token, offset, proxLen);
        this.reconstructInitializaion(tokenType, context, prop, is);
        this.reconHeaderLen = this.gssHeader.getLength() + this.getTokenHeaderSize();
    }

    GssTokenV1(int tokenType, GssContext context, MessageProp prop, InputStream is) throws GSSException {
        this.reconstructInitializaion(tokenType, context, prop, is);
    }

    private void reconstructInitializaion(int tokenType, GssContext context, MessageProp prop, InputStream is) throws GSSException {
        this.initialize(tokenType, context, true);
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        try {
            this.gssHeader = new GSSHeader(is);
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid token:" + e.getMessage());
        }
        if (!this.gssHeader.getOid().equals(objId)) {
            throw new GSSException(10, -1, "Invalid token OID");
        }
        this.reconstructTokenHeader(is, prop);
    }

    private void initialize(int tokenType, GssContext context, boolean reconstruct) throws GSSException {
        this.tokenType = tokenType;
        this.isInitiator = context.isInitiator();
        this.confState = context.getConfState();
        this.encryptor = context.getGssEncryptor();
        this.checkSumSize = this.encryptor.getCheckSumSize();
        if (!reconstruct) {
            this.sequenceNumber = context.incMySequenceNumber();
        } else {
            this.checkSum = new byte[this.checkSumSize];
        }
    }

    protected void calcPrivacyInfo(MessageProp prop, byte[] confounder, byte[] data, int dataOffset, int dataLength, int paddingLen) throws GSSException {
        prop.setQOP(0);
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        this.checkSum = this.calcCheckSum(confounder, this.commHeader, data, dataOffset, dataLength, paddingLen);
        this.encryptSequenceNumber();
    }

    protected void verifyToken(byte[] confounder, byte[] data, int dataOffset, int dataLength, int paddingLen) throws GSSException {
        byte[] sum = this.calcCheckSum(confounder, this.commHeader, data, dataOffset, dataLength, paddingLen);
        if (!MessageDigest.isEqual(this.checkSum, sum)) {
            throw new GSSException(6, -1, "Corrupt token checksum for " + (this.tokenType == 257 ? "Mic" : "Wrap") + "TokenV1");
        }
    }

    private byte[] calcCheckSum(byte[] confounder, byte[] header, byte[] data, int dataOffset, int dataLength, int paddingLen) throws GSSException {
        return this.encryptor.calculateCheckSum(confounder, header, data, dataOffset, dataLength, paddingLen, this.tokenType == 257);
    }

    private void encryptSequenceNumber() throws GSSException {
        this.plainSequenceBytes = new byte[8];
        if (this.encryptor.isArcFourHmac()) {
            BytesUtil.int2bytes((int)this.sequenceNumber, (byte[])this.plainSequenceBytes, (int)0, (boolean)true);
        } else {
            BytesUtil.int2bytes((int)this.sequenceNumber, (byte[])this.plainSequenceBytes, (int)0, (boolean)false);
        }
        if (!this.isInitiator) {
            this.plainSequenceBytes[4] = -1;
            this.plainSequenceBytes[5] = -1;
            this.plainSequenceBytes[6] = -1;
            this.plainSequenceBytes[7] = -1;
        }
        this.encryptedSequenceNumber = this.encryptor.encryptSequenceNumber(this.plainSequenceBytes, this.checkSum, true);
    }

    public void encodeHeader(OutputStream os) throws GSSException, IOException {
        GSSHeader gssHeader = new GSSHeader(objId, this.getTokenSizeWithoutGssHeader());
        gssHeader.encode(os);
        os.write(this.commHeader);
        os.write(this.encryptedSequenceNumber);
        os.write(this.checkSum);
    }

    private void createTokenHeader() {
        this.commHeader[0] = (byte)(this.tokenType >>> 8);
        this.commHeader[1] = (byte)this.tokenType;
        this.sgnAlg = this.encryptor.getSgnAlg();
        this.commHeader[2] = (byte)(this.sgnAlg >>> 8);
        this.commHeader[3] = (byte)this.sgnAlg;
        if (this.tokenType == 513) {
            this.sealAlg = this.encryptor.getSealAlg();
            this.commHeader[4] = (byte)(this.sealAlg >>> 8);
            this.commHeader[5] = (byte)this.sealAlg;
        } else {
            this.commHeader[4] = -1;
            this.commHeader[5] = -1;
        }
        this.commHeader[6] = -1;
        this.commHeader[7] = -1;
    }

    private void reconstructTokenHeader(InputStream is, MessageProp prop) throws GSSException {
        try {
            byte dirc;
            if (is.read(this.commHeader) != this.commHeader.length || is.read(this.encryptedSequenceNumber) != this.encryptedSequenceNumber.length || is.read(this.checkSum) != this.checkSum.length) {
                throw new GSSException(11, -1, "Insufficient in reconstruct token header");
            }
            this.initTokenHeader(this.commHeader, prop);
            this.plainSequenceBytes = this.encryptor.encryptSequenceNumber(this.encryptedSequenceNumber, this.checkSum, false);
            byte by = dirc = this.isInitiator ? (byte)-1 : 0;
            if (this.plainSequenceBytes[4] != dirc || this.plainSequenceBytes[5] != dirc || this.plainSequenceBytes[6] != dirc || this.plainSequenceBytes[7] != dirc) {
                throw new GSSException(6, -1, "Corrupt token sequence for " + (this.tokenType == 257 ? "Mic" : "Wrap") + "TokenV1");
            }
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error in reconstruct token header:" + e.getMessage());
        }
    }

    private void initTokenHeader(byte[] tokenBytes, MessageProp prop) throws GSSException {
        int tokenIDRecv = (tokenBytes[0] << 8) + tokenBytes[1];
        if (this.tokenType != tokenIDRecv) {
            throw new GSSException(10, -1, "Token ID should be " + this.tokenType + " instead of " + tokenIDRecv);
        }
        this.sgnAlg = (tokenBytes[2] << 8) + tokenBytes[3];
        this.sealAlg = (tokenBytes[4] << 8) + tokenBytes[5];
        if (tokenBytes[6] != -1 || tokenBytes[7] != -1) {
            throw new GSSException(10, -1, "Invalid token head filler");
        }
        prop.setQOP(0);
        prop.setPrivacy(this.sealAlg != 65535);
    }

    protected GSSHeader getGssHeader() {
        return this.gssHeader;
    }

    abstract int getTokenSizeWithoutGssHeader();

    static {
        try {
            objId = new ObjectIdentifier("1.2.840.113554.1.2.2");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

