/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssEncryptor;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenBase;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

abstract class GssTokenV2
extends GssTokenBase {
    public static final int CONFOUNDER_SIZE = 16;
    public static final int TOKEN_HEADER_SIZE = 16;
    private static final int OFFSET_EC = 4;
    private static final int OFFSET_RRC = 6;
    private boolean isInitiator = true;
    private boolean acceptorSubKey = false;
    private boolean confState = true;
    private int sequenceNumber;
    protected int tokenType;
    private byte[] header = new byte[16];
    protected byte[] tokenData;
    protected byte[] checkSum;
    private int ec;
    private int rrc;
    static final int KG_USAGE_ACCEPTOR_SEAL = 22;
    static final int KG_USAGE_ACCEPTOR_SIGN = 23;
    static final int KG_USAGE_INITIATOR_SEAL = 24;
    static final int KG_USAGE_INITIATOR_SIGN = 25;
    private int keyUsage;
    private static final int FLAG_SENT_BY_ACCEPTOR = 1;
    private static final int FLAG_SEALED = 2;
    private static final int FLAG_ACCEPTOR_SUBKEY = 4;
    protected GssEncryptor encryptor;

    GssTokenV2(int tokenType, GssContext context) throws GSSException {
        this.initialize(tokenType, context, false);
    }

    private void initialize(int tokenType, GssContext context, boolean reconstruct) throws GSSException {
        boolean usageFlag;
        this.tokenType = tokenType;
        this.isInitiator = context.isInitiator();
        this.acceptorSubKey = context.getKeyComesFrom() == 4;
        this.confState = context.getConfState();
        boolean bl = reconstruct ? !this.isInitiator : (usageFlag = this.isInitiator);
        if (tokenType == 1284) {
            this.keyUsage = usageFlag ? 24 : 22;
        } else if (tokenType == 1028) {
            this.keyUsage = usageFlag ? 25 : 23;
        }
        this.encryptor = context.getGssEncryptor();
        if (!reconstruct) {
            this.sequenceNumber = context.incMySequenceNumber();
        }
    }

    GssTokenV2(int tokenType, GssContext context, MessageProp prop, byte[] token, int offset, int len) throws GSSException {
        this(tokenType, context, prop, new ByteArrayInputStream(token, offset, len));
    }

    GssTokenV2(int tokenType, GssContext context, MessageProp prop, InputStream is) throws GSSException {
        this.initialize(tokenType, context, true);
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        this.reconstructTokenHeader(prop, is);
        int minSize = tokenType == 1284 && prop.getPrivacy() ? 32 + this.encryptor.getCheckSumSize() : this.encryptor.getCheckSumSize();
        try {
            int tokenLen = is.available();
            if (tokenType == 1028) {
                tokenLen = minSize;
                this.tokenData = new byte[tokenLen];
                is.read(this.tokenData);
            } else if (tokenLen >= minSize) {
                this.tokenData = new byte[tokenLen];
                is.read(this.tokenData);
            } else {
                throw new GSSException(10, -1, "Invalid token length");
            }
            if (tokenType == 1284) {
                this.tokenData = this.rotate(this.tokenData);
            }
            if (tokenType == 1028 || tokenType == 1284 && !prop.getPrivacy()) {
                int checksumLen = this.encryptor.getCheckSumSize();
                if (tokenType != 1028 && checksumLen != this.ec) {
                    throw new GSSException(10, -1, "Invalid EC");
                }
                this.checkSum = new byte[checksumLen];
                System.arraycopy(this.tokenData, tokenLen - checksumLen, this.checkSum, 0, checksumLen);
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid token");
        }
    }

    private byte[] rotate(byte[] data) {
        int dataLen = data.length;
        if (this.rrc % dataLen != 0) {
            this.rrc %= dataLen;
            byte[] newBytes = new byte[dataLen];
            System.arraycopy(data, this.rrc, newBytes, 0, dataLen - this.rrc);
            System.arraycopy(data, 0, newBytes, dataLen - this.rrc, this.rrc);
            data = newBytes;
        }
        return data;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public void generateCheckSum(MessageProp prop, byte[] data, int offset, int len) throws GSSException {
        this.createTokenHeader(prop.getPrivacy());
        if (this.tokenType == 1028 || !prop.getPrivacy() && this.tokenType == 1284) {
            this.checkSum = this.getCheckSum(data, offset, len);
        }
        if (!prop.getPrivacy() && this.tokenType == 1284) {
            this.header[4] = (byte)(this.checkSum.length >>> 8);
            this.header[5] = (byte)(this.checkSum.length & 0xFF);
        }
    }

    public byte[] getCheckSum(byte[] data, int offset, int len) throws GSSException {
        int confidentialFlag = this.header[2] & 2;
        if (confidentialFlag == 0 && this.tokenType == 1284) {
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.header[7] = 0;
        }
        return this.encryptor.calculateCheckSum(this.header, data, offset, len, this.keyUsage);
    }

    public boolean verifyCheckSum(byte[] data, int offset, int len) throws GSSException {
        byte[] dataCheckSum = this.getCheckSum(data, offset, len);
        return MessageDigest.isEqual(this.checkSum, dataCheckSum);
    }

    private void createTokenHeader(boolean privacy) {
        this.header[0] = (byte)(this.tokenType >>> 8);
        this.header[1] = (byte)this.tokenType;
        int flags = this.isInitiator ? 0 : 1;
        flags |= privacy && this.tokenType != 1028 ? 2 : 0;
        this.header[2] = (byte)((flags |= this.acceptorSubKey ? 4 : 0) & 0xFF);
        this.header[3] = -1;
        if (this.tokenType == 1284) {
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.header[7] = 0;
        } else if (this.tokenType == 1028) {
            this.header[4] = -1;
            this.header[5] = -1;
            this.header[6] = -1;
            this.header[7] = -1;
        }
        BytesUtil.int2bytes((int)this.sequenceNumber, (byte[])this.header, (int)12, (boolean)true);
    }

    private void reconstructTokenHeader(MessageProp prop, InputStream is) throws GSSException {
        try {
            if (is.read(this.header, 0, this.header.length) != this.header.length) {
                throw new GSSException(11, -1, "Token header can not be read");
            }
            int tokenIDRecv = (this.header[0] << 8) + this.header[1];
            if (tokenIDRecv != this.tokenType) {
                throw new GSSException(10, -1, "Token ID should be " + this.tokenType + " instead of " + tokenIDRecv);
            }
            int senderFlagRecv = this.header[2] & 1;
            int senderFlag = this.isInitiator ? 1 : 0;
            if (senderFlagRecv != senderFlag) {
                throw new GSSException(10, -1, "Invalid acceptor flag");
            }
            int confFlagRecv = this.header[2] & 2;
            if (confFlagRecv == 2 && this.tokenType == 1284) {
                prop.setPrivacy(true);
            } else {
                prop.setPrivacy(false);
            }
            if (this.tokenType == 1284) {
                if (this.header[3] != -1) {
                    throw new GSSException(10, -1, "Invalid token filler");
                }
                this.ec = BytesUtil.bytes2short((byte[])this.header, (int)4, (boolean)true);
                this.rrc = BytesUtil.bytes2short((byte[])this.header, (int)6, (boolean)true);
            } else if (this.tokenType == 1028) {
                for (int i = 3; i < 8; ++i) {
                    if ((this.header[i] & 0xFF) == 255) continue;
                    throw new GSSException(10, -1, "Invalid token filler");
                }
            }
            prop.setQOP(0);
            this.sequenceNumber = (int)BytesUtil.bytes2long((byte[])this.header, (int)0, (boolean)true);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Phrase token header failed");
        }
    }

    public int encodeHeader(byte[] buf, int offset) {
        System.arraycopy(this.header, 0, buf, offset, 16);
        return 16;
    }

    public void encodeHeader(OutputStream os) throws IOException {
        os.write(this.header);
    }
}

