/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import com.sun.security.jgss.AuthorizationDataEntry;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClientBase;
import org.apache.kerby.kerberos.kerb.client.KrbTokenClient;
import org.apache.kerby.kerberos.kerb.gss.impl.CredUtils;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.EncTgsRepPart;
import org.apache.kerby.kerberos.kerb.type.ticket.KrbTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlags;
import org.ietf.jgss.GSSException;
import sun.security.jgss.GSSCaller;

public class GssUtil {
    private static final int KERBEROS_TICKET_NUM_FLAGS = 32;

    public static TgtTicket getTgtTicketFromKerberosTicket(KerberosTicket kerberosTicket) throws GSSException {
        String clientName = kerberosTicket.getClient().getName();
        PrincipalName clientPrincipal = new PrincipalName(clientName);
        byte[] asn1Encoded = kerberosTicket.getEncoded();
        Ticket ticket = GssUtil.getTicketFromAsn1Encoded(asn1Encoded);
        EncAsRepPart encAsRepPart = new EncAsRepPart();
        GssUtil.fillEncKdcRepPart((EncKdcRepPart)encAsRepPart, kerberosTicket);
        TgtTicket tgt = new TgtTicket(ticket, encAsRepPart, clientPrincipal);
        return tgt;
    }

    public static void fillEncKdcRepPart(EncKdcRepPart encKdcRepPart, KerberosTicket kerberosTicket) {
        Date startTimeDate;
        String clientName = kerberosTicket.getClient().getName();
        PrincipalName clientPrincipal = new PrincipalName(clientName);
        SecretKey secretKey = kerberosTicket.getSessionKey();
        int keyType = kerberosTicket.getSessionKeyType();
        EncryptionKey key = new EncryptionKey(keyType, secretKey.getEncoded());
        encKdcRepPart.setKey(key);
        encKdcRepPart.setSname(clientPrincipal);
        Date authTimeDate = kerberosTicket.getAuthTime();
        if (authTimeDate != null) {
            encKdcRepPart.setAuthTime(new KerberosTime(authTimeDate.getTime()));
        }
        if ((startTimeDate = kerberosTicket.getStartTime()) != null) {
            encKdcRepPart.setStartTime(new KerberosTime(startTimeDate.getTime()));
        }
        KerberosTime endTime = new KerberosTime(kerberosTicket.getEndTime().getTime());
        encKdcRepPart.setEndTime(endTime);
        InetAddress[] clientAddresses = kerberosTicket.getClientAddresses();
        HostAddresses hostAddresses = null;
        if (clientAddresses != null) {
            hostAddresses = new HostAddresses();
            for (InetAddress iAddr : clientAddresses) {
                hostAddresses.add((Asn1Type)new HostAddress(iAddr));
            }
        }
        encKdcRepPart.setCaddr(hostAddresses);
        boolean[] tf = kerberosTicket.getFlags();
        TicketFlags ticketFlags = GssUtil.getTicketFlags(tf);
        encKdcRepPart.setFlags(ticketFlags);
        Date renewTillDate = kerberosTicket.getRenewTill();
        KerberosTime renewTill = renewTillDate == null ? null : new KerberosTime(renewTillDate.getTime());
        encKdcRepPart.setRenewTill(renewTill);
        String serverRealm = kerberosTicket.getServer().getRealm();
        encKdcRepPart.setSrealm(serverRealm);
    }

    public static TicketFlags getTicketFlags(boolean[] flags) {
        if (flags == null || flags.length != 32) {
            return null;
        }
        int value = 0;
        for (boolean flag : flags) {
            value = (value << 1) + (flag ? 1 : 0);
        }
        return new TicketFlags(value);
    }

    public static boolean[] ticketFlagsToBooleans(TicketFlags ticketFlags) {
        boolean[] ret = new boolean[32];
        int value = ticketFlags.getFlags();
        for (int i = 0; i < 32; ++i) {
            ret[32 - i - 1] = (value & 1) != 0;
            value >>= 1;
        }
        return ret;
    }

    public static Ticket getTicketFromAsn1Encoded(byte[] encoded) throws GSSException {
        Ticket ticket = new Ticket();
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        try {
            ticket.decode(byteBuffer);
            return ticket;
        }
        catch (IOException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
    }

    public static SgtTicket getSgtCredentialFromContext(GSSCaller caller, String client, String service) throws GSSException {
        KerberosTicket ticket = CredUtils.getKerberosTicketFromContext(caller, client, service);
        return GssUtil.getSgtTicketFromKerberosTicket(ticket);
    }

    public static SgtTicket getSgtTicketFromKerberosTicket(KerberosTicket kerberosTicket) throws GSSException {
        if (kerberosTicket == null) {
            return null;
        }
        Ticket ticket = GssUtil.getTicketFromAsn1Encoded(kerberosTicket.getEncoded());
        EncTgsRepPart encTgsRepPart = new EncTgsRepPart();
        GssUtil.fillEncKdcRepPart((EncKdcRepPart)encTgsRepPart, kerberosTicket);
        SgtTicket sgt = new SgtTicket(ticket, encTgsRepPart);
        return sgt;
    }

    public static SgtTicket applySgtCredential(KerberosTicket ticket, KrbToken krbToken, String service) throws GSSException {
        TgtTicket tgt = GssUtil.getTgtTicketFromKerberosTicket(ticket);
        if (krbToken == null) {
            return GssUtil.applySgtCredential(tgt, service);
        }
        return GssUtil.applySgtCredential(tgt, krbToken, service);
    }

    public static SgtTicket applySgtCredential(TgtTicket tgt, String server) throws GSSException {
        KrbClientBase client = GssUtil.getKrbClient();
        try {
            client.init();
            return client.requestSgt(tgt, server);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
    }

    public static SgtTicket applySgtCredential(TgtTicket tgt, KrbToken krbToken, String server) throws GSSException {
        KrbTokenClient client = GssUtil.getKrbTokenClient();
        try {
            client.init();
            return client.requestSgt(krbToken, server, tgt);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
    }

    public static KerberosTicket convertKrbTicketToKerberosTicket(KrbTicket krbTicket, String clientName) throws GSSException {
        List hostAddresses;
        byte[] asn1Encoding;
        try {
            asn1Encoding = krbTicket.getTicket().encode();
        }
        catch (IOException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
        byte[] sessionKey = krbTicket.getSessionKey().getKeyData();
        int keyType = krbTicket.getSessionKey().getKeyType().getValue();
        EncKdcRepPart encKdcRepPart = krbTicket.getEncKdcRepPart();
        KerberosPrincipal client = new KerberosPrincipal(clientName);
        PrincipalName serverPrinc = krbTicket.getTicket().getSname();
        String serverName = serverPrinc.getName() + "@" + krbTicket.getTicket().getRealm();
        KerberosPrincipal server = new KerberosPrincipal(serverName, serverPrinc.getNameType().getValue());
        TicketFlags ticketFlags = encKdcRepPart.getFlags();
        boolean[] flags = GssUtil.ticketFlagsToBooleans(ticketFlags);
        Date authTime = new Date(encKdcRepPart.getAuthTime().getTime());
        Date startTime = null;
        if (encKdcRepPart.getStartTime() != null) {
            startTime = new Date(encKdcRepPart.getStartTime().getTime());
        }
        Date endTime = new Date(encKdcRepPart.getEndTime().getTime());
        Date renewTill = new Date(encKdcRepPart.getRenewTill().getTime());
        InetAddress[] clientAddresses = null;
        if (encKdcRepPart.getCaddr() != null && (hostAddresses = encKdcRepPart.getCaddr().getElements()) != null) {
            int i = 0;
            clientAddresses = new InetAddress[hostAddresses.size()];
            for (HostAddress hostAddr : hostAddresses) {
                try {
                    InetAddress iAddr = InetAddress.getByAddress(hostAddr.getAddress());
                    clientAddresses[i++] = iAddr;
                }
                catch (UnknownHostException e) {
                    throw new GSSException(11, -1, "Bad client address");
                }
            }
        }
        KerberosTicket ticket = new KerberosTicket(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
        return ticket;
    }

    public static KrbClientBase getKrbClient() {
        try {
            File confSpecified;
            String systemProperty = GssUtil.getSystemProperty("java.security.krb5.conf");
            if (systemProperty != null && (confSpecified = new File(systemProperty)).exists()) {
                return new KrbClientBase(confSpecified);
            }
            return new KrbClientBase();
        }
        catch (KrbException e) {
            return null;
        }
    }

    public static KrbTokenClient getKrbTokenClient() {
        try {
            File confSpecified;
            String systemProperty = GssUtil.getSystemProperty("java.security.krb5.conf");
            if (systemProperty != null && (confSpecified = new File(systemProperty)).exists()) {
                return new KrbTokenClient(confSpecified);
            }
            return new KrbTokenClient();
        }
        catch (KrbException e) {
            return null;
        }
    }

    public static EncryptionKey[] convertKerberosKeyToEncryptionKey(KerberosKey[] krbKeys) {
        if (krbKeys == null) {
            return null;
        }
        EncryptionKey[] keys = new EncryptionKey[krbKeys.length];
        int i = 0;
        for (KerberosKey krbKey : krbKeys) {
            keys[i++] = new EncryptionKey(krbKey.getKeyType(), krbKey.getEncoded());
        }
        return keys;
    }

    public static EncryptionKey getEncryptionKey(KerberosKey[] krbKeys, int encType, int kvno) {
        if (krbKeys == null) {
            return null;
        }
        for (KerberosKey krbKey : krbKeys) {
            if (krbKey.getKeyType() != encType || krbKey.getVersionNumber() != kvno || krbKey.isDestroyed()) continue;
            return new EncryptionKey(krbKey.getKeyType(), krbKey.getEncoded());
        }
        return null;
    }

    public static EncryptionKey getEncryptionKey(KerberosKey[] krbKeys, int encType) {
        if (krbKeys == null) {
            return null;
        }
        for (KerberosKey krbKey : krbKeys) {
            if (krbKey.getKeyType() != encType || krbKey.isDestroyed()) continue;
            return new EncryptionKey(krbKey.getKeyType(), krbKey.getEncoded());
        }
        return null;
    }

    private static String getSystemProperty(String name) {
        if (name == null) {
            return null;
        }
        final String propertyName = name;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    public static AuthorizationDataEntry[] kerbyAuthorizationDataToJgssAuthorizationDataEntries(AuthorizationData authData) {
        if (authData == null) {
            return null;
        }
        List kerbyEntries = authData.getElements();
        AuthorizationDataEntry[] entries = new AuthorizationDataEntry[kerbyEntries.size()];
        for (int i = 0; i < kerbyEntries.size(); ++i) {
            entries[i] = new AuthorizationDataEntry(((org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry)kerbyEntries.get(i)).getAuthzType().getValue(), ((org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry)kerbyEntries.get(i)).getAuthzData());
        }
        return entries;
    }
}

