/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenV1;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class MicTokenV1
extends GssTokenV1 {
    public MicTokenV1(GssContext context, byte[] inMsg, int msgOffset, int msgLength, MessageProp messageProp) throws GSSException {
        super(257, context);
        this.calcPrivacyInfo(messageProp, null, inMsg, msgOffset, msgLength, 0);
    }

    MicTokenV1(GssContext context, MessageProp messageProp, byte[] inToken, int tokenOffset, int tokenLength) throws GSSException {
        super(257, context, messageProp, inToken, tokenOffset, tokenLength);
    }

    public int getMic(byte[] outToken, int offset) throws GSSException, IOException {
        byte[] data = this.getMic();
        System.arraycopy(data, 0, outToken, offset, data.length);
        return data.length;
    }

    public byte[] getMic() throws GSSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        this.getMic(os);
        return os.toByteArray();
    }

    public void getMic(OutputStream os) throws GSSException {
        try {
            this.encodeHeader(os);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error in output MicTokenV1 bytes:" + e.getMessage());
        }
    }

    public void verify(InputStream is) throws GSSException {
        byte[] data;
        try {
            data = new byte[is.available()];
            is.read(data);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Read plain data for MicTokenV1 error:" + e.getMessage());
        }
        this.verify(data, 0, data.length);
    }

    public void verify(byte[] data, int offset, int len) throws GSSException {
        this.verifyToken(null, data, offset, len, 0);
    }

    @Override
    protected int getTokenSizeWithoutGssHeader() {
        return this.getTokenHeaderSize();
    }
}

