/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenV2;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class MicTokenV2
extends GssTokenV2 {
    private MessageProp prop;

    MicTokenV2(GssContext context, byte[] inMsg, int msgOffset, int msgLength, MessageProp messageProp) throws GSSException {
        super(1028, context);
        this.prop = messageProp;
        if (this.prop == null) {
            this.prop = new MessageProp(0, false);
        }
        this.generateCheckSum(this.prop, inMsg, msgOffset, msgLength);
    }

    MicTokenV2(GssContext context, MessageProp messageProp, byte[] inToken, int tokenOffset, int tokenLength) throws GSSException {
        super(1028, context, messageProp, inToken, tokenOffset, tokenLength);
        this.prop = messageProp;
    }

    public int getMic(byte[] outToken, int offset) {
        this.encodeHeader(outToken, offset);
        System.arraycopy(this.checkSum, 0, outToken, 16 + offset, this.checkSum.length);
        return 16 + this.checkSum.length;
    }

    public byte[] getMic() {
        byte[] ret = new byte[16 + this.checkSum.length];
        this.getMic(ret, 0);
        return ret;
    }

    public void getMic(OutputStream os) throws GSSException {
        try {
            this.encodeHeader(os);
            os.write(this.checkSum);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Output MicTokenV2 error:" + e.getMessage());
        }
    }

    public void verify(byte[] inMsg, int msgOffset, int msgLen) throws GSSException {
        if (!this.verifyCheckSum(inMsg, msgOffset, msgLen)) {
            throw new GSSException(6, -1, "Corrupt MIC token");
        }
    }
}

