/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.kerby.kerberos.kerb.crypto.util.Random;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssEncryptor;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenV1;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;

public class WrapTokenV1
extends GssTokenV1 {
    public static final int CONFOUNDER_SIZE = 8;
    private boolean privacy;
    private byte[] inData;
    private int inOffset;
    private int inLen;
    private int paddingLen;
    private byte[] confounder;
    private int tokenBodyLen;
    private byte[] bodyData;
    private int bodyOffset;
    private int bodyLen;
    private int rawDataLength;
    private byte[] rawData;
    private int rawDataOffset;

    public WrapTokenV1(GssContext context, byte[] inMsg, int msgOffset, int msgLength, MessageProp prop) throws GSSException {
        super(513, context);
        this.paddingLen = this.getPaddingLength(msgLength);
        this.confounder = Random.makeBytes((int)8);
        this.tokenBodyLen = 8 + msgLength + this.paddingLen;
        this.calcPrivacyInfo(prop, this.confounder, inMsg, msgOffset, msgLength, this.paddingLen);
        if (!context.getConfState()) {
            prop.setPrivacy(false);
        }
        this.privacy = prop.getPrivacy();
        this.inData = inMsg;
        this.inOffset = msgOffset;
        this.inLen = msgLength;
    }

    public WrapTokenV1(GssContext context, MessageProp prop, byte[] token, int offset, int len) throws GSSException {
        super(513, context, prop, token, offset, len);
        this.bodyData = token;
        this.bodyOffset = offset + this.reconHeaderLen;
        this.bodyLen = len - this.reconHeaderLen;
        this.getRawData(prop);
    }

    public WrapTokenV1(GssContext context, MessageProp prop, InputStream is) throws GSSException {
        super(513, context, prop, is);
        byte[] token;
        int len;
        try {
            len = is.available();
            token = new byte[len];
            is.read(token);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Read wrap token V1 error:" + e.getMessage());
        }
        this.bodyData = token;
        this.bodyOffset = 0;
        this.bodyLen = len;
        this.getRawData(prop);
    }

    private void getRawData(MessageProp prop) throws GSSException {
        this.privacy = prop.getPrivacy();
        this.tokenBodyLen = this.getGssHeader().getMechTokenLength() - this.getTokenHeaderSize();
        if (this.bodyLen < this.tokenBodyLen) {
            throw new GSSException(11, -1, "Insufficient data for Wrap token V1");
        }
        if (this.privacy) {
            this.rawData = this.encryptor.encryptTokenV1(null, this.bodyData, this.bodyOffset, this.tokenBodyLen, 0, this.encryptor.isArcFourHmac() ? this.getPlainSequenceBytes() : null, false);
            this.paddingLen = this.rawData[this.rawData.length - 1];
            this.rawDataOffset = 8;
        } else {
            this.rawData = this.bodyData;
            this.paddingLen = this.bodyData[this.bodyOffset + this.tokenBodyLen - 1];
            this.rawDataOffset = this.bodyOffset + 8;
        }
        this.rawDataLength = this.tokenBodyLen - 8 - this.paddingLen;
        this.verifyToken(null, this.rawData, this.rawDataOffset - 8, this.tokenBodyLen, 0);
    }

    public byte[] unwrap() throws GSSException {
        byte[] ret = new byte[this.rawDataLength];
        System.arraycopy(this.rawData, this.rawDataOffset, ret, 0, this.rawDataLength);
        return ret;
    }

    public void unwrap(OutputStream os) throws GSSException {
        try {
            os.write(this.rawData, this.rawDataOffset, this.rawDataLength);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error in output wrap token v1 data bytes:" + e.getMessage());
        }
    }

    public byte[] wrap() throws GSSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(this.getTokenSizeWithoutGssHeader() + this.inLen + 64);
        this.wrap(os);
        return os.toByteArray();
    }

    public void wrap(OutputStream os) throws GSSException {
        try {
            this.encodeHeader(os);
            if (this.privacy) {
                byte[] enc = this.encryptor.encryptTokenV1(this.confounder, this.inData, this.inOffset, this.inLen, this.paddingLen, this.encryptor.isArcFourHmac() ? this.getPlainSequenceBytes() : null, true);
                os.write(enc);
            } else {
                os.write(this.confounder);
                os.write(this.inData, this.inOffset, this.inLen);
                os.write(this.getPaddingBytes(this.paddingLen));
            }
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Error in output wrap token v1 bytes:" + e.getMessage());
        }
    }

    @Override
    protected int getTokenSizeWithoutGssHeader() {
        return this.tokenBodyLen + this.getTokenHeaderSize();
    }

    private int getPaddingLength(int dataLen) {
        if (this.encryptor.isArcFourHmac()) {
            return 1;
        }
        return 8 - dataLen % 8;
    }

    private byte[] getPaddingBytes(int len) {
        byte[] ret = new byte[len];
        int i = 0;
        while (i < len) {
            ret[i++] = (byte)len;
        }
        return ret;
    }

    public static int getMsgSizeLimit(int qop, boolean confReq, int maxTokSize, GssEncryptor encryptor) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(objId, maxTokSize) - encryptor.getCheckSumSize() - 8 - 8 - 8 - 8;
    }
}

