/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.gss.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.kerby.kerberos.kerb.gss.impl.GssContext;
import org.apache.kerby.kerberos.kerb.gss.impl.GssEncryptor;
import org.apache.kerby.kerberos.kerb.gss.impl.GssTokenV2;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class WrapTokenV2
extends GssTokenV2 {
    private MessageProp prop;

    WrapTokenV2(GssContext context, byte[] data, int dataOffset, int dataLength, MessageProp messageProp) throws GSSException {
        super(1284, context);
        this.prop = messageProp;
        if (this.prop.getQOP() != 0) {
            this.prop.setQOP(0);
        }
        if (!context.getConfState()) {
            this.prop.setPrivacy(false);
        }
        this.generateCheckSum(this.prop, data, dataOffset, dataLength);
        if (this.prop.getPrivacy()) {
            byte[] toProcess = new byte[dataLength + 16];
            System.arraycopy(data, dataOffset, toProcess, 0, dataLength);
            this.encodeHeader(toProcess, dataLength);
            this.tokenData = this.encryptor.encryptData(toProcess, this.getKeyUsage());
        } else {
            this.tokenData = data;
        }
    }

    public byte[] wrap() {
        int dataSize = this.tokenData.length;
        int ckSize = this.checkSum == null ? 0 : this.checkSum.length;
        byte[] ret = new byte[16 + dataSize + ckSize];
        this.encodeHeader(ret, 0);
        System.arraycopy(this.tokenData, 0, ret, 16, dataSize);
        if (ckSize > 0) {
            System.arraycopy(this.checkSum, 0, ret, 16 + dataSize, ckSize);
        }
        return ret;
    }

    public void wrap(OutputStream os) throws GSSException {
        try {
            int ckSize;
            this.encodeHeader(os);
            os.write(this.tokenData);
            int n = ckSize = this.checkSum == null ? 0 : this.checkSum.length;
            if (ckSize > 0) {
                os.write(this.checkSum);
            }
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Output token error:" + e.getMessage());
        }
    }

    public WrapTokenV2(GssContext context, MessageProp prop, byte[] token, int offset, int len) throws GSSException {
        super(1284, context, prop, token, offset, len);
        this.prop = prop;
    }

    public WrapTokenV2(GssContext context, MessageProp prop, InputStream is) throws GSSException {
        super(1284, context, prop, is);
        this.prop = prop;
    }

    public byte[] unwrap(byte[] outBuffer, int offset) throws GSSException {
        if (this.prop.getPrivacy()) {
            byte[] plainText = this.encryptor.decryptData(this.tokenData, this.getKeyUsage());
            int lenToCopy = plainText.length - 16;
            if (outBuffer == null) {
                outBuffer = new byte[lenToCopy];
                offset = 0;
            }
            System.arraycopy(plainText, 0, outBuffer, offset, lenToCopy);
        } else {
            int lenToCopy = this.tokenData.length - this.encryptor.getCheckSumSize();
            if (outBuffer == null) {
                outBuffer = new byte[lenToCopy];
                offset = 0;
            }
            System.arraycopy(this.tokenData, 0, outBuffer, offset, lenToCopy);
            if (!this.verifyCheckSum(outBuffer, offset, lenToCopy)) {
                throw new GSSException(6, -1, "Corrupt token checksum");
            }
        }
        return outBuffer;
    }

    public byte[] unwrap() throws GSSException {
        return this.unwrap(null, 0);
    }

    public void unwrap(OutputStream os) throws GSSException {
        byte[] data = this.unwrap();
        try {
            os.write(data);
        }
        catch (IOException e) {
            throw new GSSException(11, -1, "Output token error:" + e.getMessage());
        }
    }

    public static int getMsgSizeLimit(int qop, boolean confReq, int maxTokSize, GssEncryptor encryptor) throws GSSException {
        if (confReq) {
            return maxTokSize - encryptor.getCheckSumSize() - 32 - 16;
        }
        return maxTokSize - encryptor.getCheckSumSize() - 16;
    }
}

